/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.databind.generator;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.databind.dnd.TableInspectorUtil;
import com.ibm.etools.jsf.databind.generator.ActionGenerator;
import com.ibm.etools.jsf.databind.generator.DataTableGenerator;
import com.ibm.etools.jsf.databind.generator.JsfGeneratorBase;
import com.ibm.etools.jsf.databind.generator.SingleControlGenerator;
import com.ibm.etools.jsf.internal.databind.templates.TemplateGenerator;
import com.ibm.etools.jsf.internal.databind.templates.TemplateProvider;
import com.ibm.etools.jsf.internal.databind.templates.resolvers.BaseVariableResolver;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.preferences.JsfTagModeUtil;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.CodeGenerationManager;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IGenerationTemplate;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.Interface;
import com.ibm.etools.webtools.pagedatamodel.impl.PageActionNode;
import com.ibm.etools.webtools.wizards.cgen.FilesPreferenceUtil;
import java.util.List;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TableGenerator
extends JsfGeneratorBase {
    private int extraColumns;
    private int currentColumn;
    private String parentBeanName;
    private String templateName;
    private boolean addMessages = true;
    private boolean addSubmitButton = true;
    private boolean addDeleteButton = true;

    @Override
    protected void clear() {
        super.clear();
        this.extraColumns = 0;
        this.currentColumn = 0;
        this.parentBeanName = null;
        this.templateName = null;
        this.addMessages = true;
        this.addSubmitButton = true;
        this.addDeleteButton = true;
    }

    public String perform(ICodeGenNode node) {
        try {
            this.setCodeGenNode(node);
            ICodeGenModel model = node.getCodeGenModel();
            List nodesList = model.getCodeGenNodes();
            this.setExtraColumns(0);
            this.checkUnderDataTable();
            this.setDefaultTemplateName();
            IGenerationTemplate template = null;
            StringBuffer generatedCode = new StringBuffer();
            if (!TemplateProvider.useJavajetTemplates()) {
                BaseVariableResolver baseResolver = new BaseVariableResolver(node, null, this.getParentBeanName(), null, null);
                TemplateGenerator t = new TemplateGenerator(baseResolver);
                generatedCode = t.resolveWrapperTemplates();
                if (this.getModel().getControlType() == 2 || this.getModel().getControlType() == 1) {
                    this.getModel().addCustomProperty((Object)"requires_form", (Object)Boolean.TRUE);
                }
            }
            if (generatedCode.length() == 0) {
                if (nodesList != null && !nodesList.isEmpty() && (template = this.isJspPanelRequired() ? CodeGenerationManager.getTemplateForControl((String)this.getModel().getPageType(), (String)"tableInJspPanel") : CodeGenerationManager.getTemplateForControl((String)this.getModel().getPageType(), (String)this.templateName)) != null) {
                    String string = template.generate((Interface)this);
                    return string;
                }
                return "";
            }
            String string = generatedCode.toString();
            return string;
        }
        catch (Exception e) {
            JsfPlugin.log(e);
            return "";
        }
        finally {
            this.clear();
        }
    }

    protected boolean isJspPanelRequired() {
        Node dropTarget = JsfCommandUtil.getTargetNode(EditDomainUtil.getEditDomain().getSelectionMediator().getRange());
        if (dropTarget == null) {
            return false;
        }
        if (!JsfTagModeUtil.isUsingIbmTags(JsfProjectUtil.getProjectForPage((IDOMDocument)((IDOMDocument)JsfCommandUtil.getDocument(dropTarget))))) {
            return false;
        }
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)JsfCommandUtil.getDocument(dropTarget));
        String uri = mapper.getUriForPrefix(dropTarget.getPrefix());
        String tagName = dropTarget.getLocalName();
        return "http://java.sun.com/jsf/html".equals(uri) && "panelGrid".equals(tagName) || "http://www.ibm.com/jsf/html_extended".equals(uri) && "panelBox".equals(tagName) || "http://www.ibm.com/jsf/html_extended".equals(uri) && "panelLayout".equals(tagName) || "http://java.sun.com/jsf/core".equals(uri) && "facet".equals(tagName);
    }

    protected void checkUnderDataTable() {
        Node target = JsfCommandUtil.getTargetNode(EditDomainUtil.getEditDomain().getSelectionMediator().getRange());
        Node outerDataTable = TableInspectorUtil.getParentDataTable(target);
        if (outerDataTable != null && !outerDataTable.equals("")) {
            this.disableAdditionalControls();
        }
    }

    protected int getChildCount() {
        return this.getModel().getCodeGenNodes().size();
    }

    public String generateLabelTag(int row) {
        IGenerationTemplate template = CodeGenerationManager.getTemplateForControl((String)this.getModel().getPageType(), (String)"outputLabel");
        if (Boolean.TRUE == this.getModel().getCustomProperty((Object)"add_label_component") && template != null) {
            return template.generate((Interface)this);
        }
        return this.getLabelTag(row);
    }

    public String getLabelTag(int row) {
        return ((ICodeGenNode)this.getModel().getCodeGenNodes().get(row)).getLabel();
    }

    public String getCurrentControlsId(int row) {
        ICodeGenNode currentNode = (ICodeGenNode)this.getModel().getCodeGenNodes().get(row);
        String id = null;
        if (currentNode.isListNode()) {
            id = this.getId("http://java.sun.com/jsf/html", "dataTable");
        } else {
            SingleControlGenerator generator = new SingleControlGenerator();
            generator.setCodeGenNode(currentNode);
            id = generator.internalGetId(currentNode);
        }
        if ("".equals(id) || id == null) {
            id = this.getId(null, null);
        }
        this.getModel().addCustomProperty((Object)"precomputed_id", (Object)id);
        return id;
    }

    public String generateControlTag(int row) {
        ICodeGenNode child = (ICodeGenNode)this.getModel().getCodeGenNodes().get(row);
        return this.getControlTag(child);
    }

    protected String getControlTag(ICodeGenNode currentNode) {
        if (currentNode.isListNode()) {
            DataTableGenerator generator = new DataTableGenerator();
            generator.setParentBeanName(this.parentBeanName);
            generator.setRootCodeGenNode(this.getCodeGenModel().getRoot());
            return generator.perform(currentNode);
        }
        SingleControlGenerator generator = new SingleControlGenerator();
        generator.setParentBeanName(this.parentBeanName);
        generator.setRootCodeGenNode(this.getCodeGenModel().getRoot());
        return generator.perform(currentNode);
    }

    public String getAlign() {
        ICodeGenModel dataModel = this.getModel();
        switch (dataModel.getAlignment()) {
            case 0: {
                return "left";
            }
            case 1: {
                return "center";
            }
            case 2: {
                return "right";
            }
        }
        return "left";
    }

    public String generateRows() {
        StringBuffer buffer = new StringBuffer();
        int numRows = this.getChildCount();
        boolean emptyTable = true;
        int i = 0;
        while (i < numRows) {
            IGenerationTemplate template = CodeGenerationManager.getTemplateForControl((String)this.getModel().getPageType(), (String)"tableRow");
            this.setCurrentColumn(i);
            ICodeGenNode currentNode = (ICodeGenNode)this.getModel().getCodeGenNodes().get(i);
            if (currentNode.isSelected() && template != null) {
                emptyTable = false;
                buffer.append(template.generate((Interface)this));
            }
            ++i;
        }
        if (emptyTable) {
            buffer.append("<tr><td/></tr>");
        }
        return buffer.toString();
    }

    public String getExtraColumnTags() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.extraColumns) {
            buffer.append(FilesPreferenceUtil.getEndOfLineCodeForJSP());
            buffer.append("<td></td>");
            ++i;
        }
        return buffer.toString();
    }

    public String generateButtonTags() {
        IBindingAttribute bindingAttr;
        PageActionNode actionNode;
        StringBuffer result = new StringBuffer();
        if (!(this.getModel().isCreateSubmitButton() && this.addSubmitButton || this.getModel().isCreateDeleteButton() && this.addDeleteButton)) {
            return result.toString();
        }
        ActionGenerator generator = new ActionGenerator();
        ICodeGenNode codeGenNode = this.getCodeGenNode();
        result.append(FilesPreferenceUtil.getEndOfLineCodeForJSP());
        result.append("<br />");
        result.append(FilesPreferenceUtil.getEndOfLineCodeForJSP());
        if (JsfTagModeUtil.isUsingIbmTags(JsfProjectUtil.getProjectForPage((IDOMDocument)EditDomainUtil.getEditDomain().getModel().getDocument()))) {
            codeGenNode.setControlId("commandExButton");
        } else {
            codeGenNode.setControlId("commandButton");
        }
        if (this.getModel().isCreateSubmitButton() && this.addSubmitButton) {
            generator.setForceJavajet(true);
            actionNode = this.getCodeGenModel().getSubmitButtonAction();
            if (actionNode != null) {
                bindingAttr = (IBindingAttribute)this.getCodeGenModel().getSubmitButtonAction().getAdapter(IBindingAttribute.ADAPTER_KEY);
                generator.setTagId(this.getId("http://java.sun.com/jsf/html", "commandButton", JsfComponentUtil.fixupId((String)bindingAttr.getReferenceString((IPageDataNode)actionNode))));
            } else {
                generator.setTagId(this.getId("http://java.sun.com/jsf/html", "commandButton", null));
            }
            generator.setButtonType("submit");
            generator.setActionAttribute(actionNode);
            generator.setTagLabel(this.getCodeGenModel().getSubmitButtonLabel());
            result.append(generator.perform(codeGenNode));
        }
        if (this.getModel().isCreateDeleteButton() && this.addDeleteButton) {
            generator.setForceJavajet(true);
            actionNode = this.getCodeGenModel().getDeleteButtonAction();
            if (actionNode != null) {
                bindingAttr = (IBindingAttribute)this.getCodeGenModel().getDeleteButtonAction().getAdapter(IBindingAttribute.ADAPTER_KEY);
                generator.setTagId(this.getId("http://java.sun.com/jsf/html", "commandButton", JsfComponentUtil.fixupId((String)bindingAttr.getReferenceString((IPageDataNode)actionNode))));
            } else {
                generator.setTagId(this.getId("http://java.sun.com/jsf/html", "commandButton", null));
            }
            generator.setButtonType("submit");
            generator.setActionAttribute(actionNode);
            generator.setTagLabel(this.getCodeGenModel().getDeleteButtonLabel());
            result.append(generator.perform(codeGenNode));
        }
        return result.toString();
    }

    public String generateMessagesTag() {
        if (this.addMessages && Boolean.FALSE != this.getModel().getCustomProperty((Object)"add_messages")) {
            this.getModel().addCustomProperty((Object)"add_messages", (Object)Boolean.FALSE);
            IGenerationTemplate template = CodeGenerationManager.getTemplateForControl((String)this.getModel().getPageType(), (String)"messages");
            if (template != null) {
                return template.generate((Interface)this);
            }
            return "";
        }
        return "";
    }

    protected void disableAdditionalControls() {
        this.setAddMessages(false);
        this.setAddDeleteButton(false);
        this.setAddSubmitButton(false);
    }

    protected void setDefaultTemplateName() {
        if (this.templateName == null || this.templateName.equals("")) {
            this.templateName = "table";
        }
    }

    public String getSpace() {
        if (JsfCommandUtil.isXMLSyntax(EditDomainUtil.getEditDomain().getActiveModel())) {
            return "&amp;nbsp;";
        }
        return "&nbsp;";
    }

    protected int getExtraColumns() {
        return this.extraColumns;
    }

    public void setExtraColumns(int i) {
        this.extraColumns = i;
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }

    protected void setCurrentColumn(int i) {
        this.currentColumn = i;
    }

    protected String getParentBeanName() {
        return this.parentBeanName;
    }

    public void setParentBeanName(String string) {
        this.parentBeanName = string;
    }

    protected boolean isAddDeleteButton() {
        return this.addDeleteButton;
    }

    protected boolean isAddMessages() {
        return this.addMessages;
    }

    protected boolean isAddSubmitButton() {
        return this.addSubmitButton;
    }

    protected void setAddDeleteButton(boolean b) {
        this.addDeleteButton = b;
    }

    protected void setAddMessages(boolean b) {
        this.addMessages = b;
    }

    protected void setAddSubmitButton(boolean b) {
        this.addSubmitButton = b;
    }

    protected String getTemplateName() {
        return this.templateName;
    }

    protected void setTemplateName(String string) {
        this.templateName = string;
    }
}

