/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.databind.generator;

import com.ibm.etools.jsf.databind.generator.ICodeGenerationProvider;
import com.ibm.etools.jsf.databind.generator.JsfGeneratorBase;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.Generator;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DelegatingGenerator
extends JsfGeneratorBase {
    public String perform(ICodeGenNode codeGenNode) {
        Iterator providersIter = ExtensionRegistry.getRegistry().getCodeGenerationProviders().iterator();
        boolean prohibit = false;
        while (providersIter.hasNext() && !prohibit) {
            ICodeGenerationProvider provider = (ICodeGenerationProvider)providersIter.next();
            int intent = provider.getGeneratorIntent(codeGenNode);
            switch (intent) {
                case 0: {
                    break;
                }
                case 1: {
                    Generator generator = provider.getGenerator(codeGenNode);
                    return generator.perform(codeGenNode);
                }
                case 2: {
                    prohibit = true;
                    if (Display.getCurrent() != null && EditDomainUtil.getEditDomain().getDialogParent() != null) {
                        Shell shell = EditDomainUtil.getEditDomain().getDialogParent();
                        MessageDialog.openInformation((Shell)shell, (String)Messages.DelegatingGenerator_Prohibited, (String)Messages.DelegatingGenerator_ProhibitedInfo);
                        break;
                    }
                    System.out.println(Messages.BindingCommandFactory_Prohibited);
                    System.out.println(Messages.BindingCommandFactory_ProhibitedInfo);
                }
            }
        }
        return "";
    }
}

