/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.databind.commands.builder;

import com.ibm.etools.jsf.databind.commands.DataTableBindingHelper;
import com.ibm.etools.jsf.databind.commands.builder.BindingCommandFactory;
import com.ibm.etools.jsf.databind.commands.builder.BindingContext;
import com.ibm.etools.jsf.internal.databind.CommandUtil;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webtools.model.ModelManager;
import com.ibm.etools.webtools.model.api.JSP;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.IBindingAttribute;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import com.ibm.etools.webtools.pagedatamodel.sse.api.ISSEPageDataNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BindingUtil {
    private static final String VAR_PREFIX = "var";

    private BindingUtil() {
    }

    public static String computeVarAttribute(Node n, String beanName) {
        String tagName = n.getNodeName();
        if (beanName == null) {
            return "";
        }
        int lastDot = beanName.lastIndexOf(".");
        String varName = lastDot > -1 ? VAR_PREFIX + beanName.substring(lastDot + 1) : VAR_PREFIX + beanName;
        boolean needsCheck = true;
        block0: while (needsCheck) {
            needsCheck = false;
            Node cursorNode = n.getParentNode();
            while (cursorNode != null) {
                String parentVar;
                if (cursorNode.getNodeName().equals(tagName) && varName.equals(parentVar = ((Element)cursorNode).getAttribute(CommandUtil.getRepeatingValueAttribute(cursorNode)))) {
                    varName = String.valueOf(varName) + "X";
                    needsCheck = true;
                    continue block0;
                }
                cursorNode = cursorNode.getParentNode();
            }
        }
        return varName;
    }

    public static String computeVarAttribute(String beanName, Stack<String> varStack) {
        if (beanName == null) {
            return "";
        }
        int lastDot = beanName.lastIndexOf(".");
        String varName = lastDot > -1 ? VAR_PREFIX + beanName.substring(lastDot + 1) : VAR_PREFIX + beanName;
        if (varName.indexOf("[") > -1) {
            varName = varName.substring(0, varName.indexOf("["));
        }
        boolean needsCheck = true;
        while (needsCheck) {
            needsCheck = false;
            if (!varStack.contains(varName)) continue;
            varName = String.valueOf(varName) + "X";
            needsCheck = true;
        }
        return varName;
    }

    public static boolean isListType(IPageDataNode pdNode) {
        IBindingAttribute attr = (IBindingAttribute)pdNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
        return attr.getCollectionType(pdNode) == 1;
    }

    public static boolean isMapType(IPageDataNode pdNode) {
        IBindingAttribute attr = (IBindingAttribute)pdNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
        return attr.getCollectionType(pdNode) == 3;
    }

    public static boolean isCollectionType(IPageDataNode pdNode) {
        IBindingAttribute attr = (IBindingAttribute)pdNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
        int type = attr.getCollectionType(pdNode);
        return type == 1 || type == 2;
    }

    public static boolean isArrayType(IPageDataNode pdNode) {
        IBindingAttribute attr = (IBindingAttribute)pdNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
        return attr.isArrayType(pdNode);
    }

    public static boolean isListNode(IPageDataNode pdNode) {
        return BindingUtil.isListType(pdNode) || BindingUtil.isArrayType(pdNode);
    }

    public static HTMLCommand generateBindingCommand(Node targetNode, String targetAttribute, IPageDataNode dropObject, boolean simpleBinding) {
        if (dropObject == null) {
            return null;
        }
        if (EditDomainUtil.getEditDomain() == null) {
            return null;
        }
        ICodeGenModel model = BindingUtil.constructModel(new IPageDataNode[]{dropObject});
        if (model == null) {
            return null;
        }
        return BindingCommandFactory.generateCommand(targetNode, targetAttribute, model, simpleBinding);
    }

    public static HTMLCommand generateBindingCommand(Node targetNode, IPageDataNode dropObject, boolean simpleBinding) {
        return BindingUtil.generateBindingCommand(targetNode, "value", dropObject, simpleBinding);
    }

    private static ICodeGenModel constructModel(IPageDataNode[] pdNodes) {
        try {
            IDOMDocument d = BindingUtil.getDocument(pdNodes[0]);
            Path jspPath = new Path(d.getModel().getBaseLocation());
            IProject project = JsfProjectUtil.getProjectForPage((IDOMDocument)d);
            IFile file = (IFile)project.getWorkspace().getRoot().findMember((IPath)jspPath);
            JSP jsp = ModelManager.getModel((IResource)project).getJSP(file);
            ICodeGenModel model = CodeGenModelFactory.createCodeGenModel((IPageDataNode[])pdNodes, null, (JSP)jsp, (String)"JSF", (boolean)true);
            CodeGenModelFactory.finalizeModel((ICodeGenModel)model);
            return model;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String removeLastIndexReference(String beanName) {
        int lastLBracket;
        if (beanName == null) {
            return null;
        }
        if ((beanName = beanName.trim()).lastIndexOf("]") == beanName.length() - 1 && (lastLBracket = beanName.lastIndexOf("[")) > -1) {
            beanName = beanName.substring(0, lastLBracket);
        }
        return beanName;
    }

    public static String removeAllIndexReferences(String beanName) {
        if (beanName == null) {
            return null;
        }
        int leftBracketIndex = beanName.indexOf("[");
        if (leftBracketIndex == -1) {
            return beanName;
        }
        StringBuffer sb = new StringBuffer();
        while (leftBracketIndex > -1) {
            sb.append(beanName.substring(0, leftBracketIndex));
            int rightBracketIndex = beanName.indexOf("]");
            if (rightBracketIndex > -1) {
                beanName = beanName.substring(rightBracketIndex + 1);
                leftBracketIndex = beanName.indexOf("[");
                continue;
            }
            leftBracketIndex = -1;
        }
        sb.append(beanName);
        return sb.toString();
    }

    public static String makeVbl(String reference) {
        if (reference == null) {
            return null;
        }
        if (BindingUtil.isVblExpression(reference)) {
            return reference;
        }
        return "#{" + reference + "}";
    }

    public static boolean isVblExpression(String reference) {
        if (reference == null) {
            return false;
        }
        return reference.indexOf("#{") != -1 && reference.indexOf("#{") < reference.indexOf(125);
    }

    public static String removeVbl(String reference) {
        if (reference == null) {
            return null;
        }
        int startIndex = reference.indexOf("#{");
        int endIndex = reference.lastIndexOf("}");
        if (startIndex > -1 && endIndex > -1 && endIndex > startIndex + 1) {
            return reference.substring(startIndex + 2, endIndex);
        }
        return reference;
    }

    public static boolean hasChildren(IPageDataNode node) {
        if (!node.hasChildren()) {
            return false;
        }
        return node.getChildren().size() != 0;
    }

    public static String getType(IPageDataNode node) {
        IBindingAttribute attr = (IBindingAttribute)node.getAdapter(IBindingAttribute.ADAPTER_KEY);
        return attr.getRuntimeType(node);
    }

    public static IDOMDocument getDocument(IPageDataNode pdNode) {
        IDOMDocument d = null;
        IDOMNode node = null;
        if (pdNode instanceof ISSEPageDataNode) {
            node = ((ISSEPageDataNode)pdNode).getDOMNode();
        }
        d = node != null ? (node.getNodeType() == 9 ? (IDOMDocument)node : (IDOMDocument)node.getOwnerDocument()) : EditDomainUtil.getEditDomain().getActiveModel().getDocument();
        return d;
    }

    public static IPageDataNode findCommonRootNode(IPageDataNode[] nodes) {
        IPageDataNode commonRootNode = nodes[0];
        if (nodes.length > 1) {
            ArrayList<IPageDataNode> parentNodes = new ArrayList<IPageDataNode>();
            IPageDataNode node = nodes[0].getParent();
            while (node.getParent().getParent() != null) {
                parentNodes.add(node);
                node = node.getParent();
            }
            commonRootNode = nodes[0].getParent();
            int i = 1;
            while (i < nodes.length) {
                node = nodes[1];
                while (node.getParent() != null) {
                    if (parentNodes.contains(node) && parentNodes.indexOf(node) > parentNodes.indexOf(commonRootNode)) {
                        commonRootNode = node;
                        break;
                    }
                    node = node.getParent();
                }
                ++i;
            }
        } else {
            if (BindingUtil.isListNode(commonRootNode)) {
                return commonRootNode;
            }
            IPageDataNode tempNode = commonRootNode;
            while (tempNode.getParent().getParent() != null) {
                IPageDataNode parent = tempNode.getParent();
                if (BindingUtil.isListNode(parent)) {
                    commonRootNode = parent;
                    break;
                }
                tempNode = parent;
            }
        }
        return commonRootNode;
    }

    public static String calculateEquivalentValue(Node startNode) {
        StringBuffer buffer = new StringBuffer();
        Node currentNode = startNode;
        Node cursor = startNode.getParentNode();
        Node varDefiningNode = null;
        while (cursor != null) {
            if (JsfComponentUtil.isJsfTag((Node)cursor) && ((Element)cursor).hasAttribute(CommandUtil.getRepeatingValueAttribute(cursor))) {
                varDefiningNode = cursor;
                String currentValue = BindingUtil.removeVbl(((Element)currentNode).getAttribute(CommandUtil.getMainBindingAttribute(currentNode)));
                String currentVar = BindingUtil.removeVbl(((Element)cursor).getAttribute(CommandUtil.getRepeatingValueAttribute(cursor)));
                if (currentValue != null && currentValue.startsWith(currentVar)) {
                    buffer.insert(0, currentValue.substring(currentVar.length()));
                }
                currentNode = cursor;
            }
            cursor = cursor.getParentNode();
        }
        if (varDefiningNode != null) {
            buffer.insert(0, BindingUtil.removeVbl(((Element)varDefiningNode).getAttribute(CommandUtil.getMainBindingAttribute(varDefiningNode))));
        } else {
            buffer.insert(0, BindingUtil.removeVbl(((Element)startNode).getAttribute(CommandUtil.getMainBindingAttribute(startNode))));
        }
        return buffer.toString();
    }

    public static void resetModel(Node targetNode, BindingContext context) {
        ICodeGenModel newModel = BindingUtil.findYoungestModel(context.getModel());
        if (newModel != null) {
            context.setModel(newModel);
        }
    }

    public static void resetModelForVarTag(Node targetNode, BindingContext context) {
        String equivalentValue = BindingUtil.calculateEquivalentValue(targetNode);
        ICodeGenModel currentModel = context.getModel();
        if (BindingUtil.isDisjointSelection(currentModel)) {
            return;
        }
        ICodeGenModel newModel = BindingUtil.findMatchingModel(equivalentValue, currentModel);
        if (newModel != null && newModel != currentModel) {
            context.setModel(newModel);
        }
    }

    private static boolean isDisjointSelection(ICodeGenModel model) {
        List childNodes = model.getCodeGenNodes();
        Iterator iter = childNodes.iterator();
        boolean hasNonListNode = false;
        boolean hasListNode = false;
        while (iter.hasNext()) {
            ICodeGenNode child = (ICodeGenNode)iter.next();
            if (child.isListNode()) {
                if (BindingUtil.isDisjointSelection(child.getChildCodeGenModel())) {
                    return true;
                }
                hasListNode = true;
                continue;
            }
            hasNonListNode = true;
        }
        return hasListNode && hasNonListNode;
    }

    private static ICodeGenModel findMatchingModel(String value, ICodeGenModel model) {
        IPageDataNode pdNode = model.getRoot().getEnclosedNode();
        IBindingAttribute attr = (IBindingAttribute)pdNode.getAdapter(IBindingAttribute.ADAPTER_KEY);
        if (DataTableBindingHelper.sameBean(BindingUtil.removeAllIndexReferences(value), BindingUtil.removeAllIndexReferences(attr.getReferenceString(pdNode)))) {
            return model;
        }
        List childNodes = model.getCodeGenNodes();
        for (ICodeGenNode child : childNodes) {
            ICodeGenModel childModel;
            if (!child.isListNode() || (childModel = BindingUtil.findMatchingModel(value, child.getChildCodeGenModel())) == null) continue;
            return childModel;
        }
        return null;
    }

    private static ICodeGenModel findYoungestModel(ICodeGenModel model) {
        if (model == null || model.getCodeGenNodes() == null) {
            return model;
        }
        List childNodes = model.getCodeGenNodes();
        for (ICodeGenNode child : childNodes) {
            ICodeGenModel childModel;
            if (!child.isListNode() || (childModel = child.getChildCodeGenModel()) == null) continue;
            return BindingUtil.findYoungestModel(childModel);
        }
        return model;
    }

    public static boolean allowsAttribute(Element tag, String attributeName) {
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)tag.getOwnerDocument());
        if (modelQuery == null) {
            return false;
        }
        CMElementDeclaration decl = modelQuery.getCMElementDeclaration(tag);
        if (decl == null) {
            return false;
        }
        CMNamedNodeMap declAttrs = decl.getAttributes();
        if (declAttrs == null) {
            return false;
        }
        return declAttrs.getNamedItem(attributeName) != null;
    }
}

