/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.databind.commands.builder;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.databind.commands.builder.BindingContext;
import com.ibm.etools.jsf.databind.commands.builder.IBindingCommandProvider;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.registry.ExtensionRegistry;
import com.ibm.etools.jsf.support.Debug;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Node;

public class BindingCommandFactory {
    private BindingCommandFactory() {
    }

    public static HTMLCommand generateCommand(Node targetNode, String targetAttribute, ICodeGenModel model, boolean simpleBinding) {
        if (targetNode == null || model == null) {
            return null;
        }
        BindingContext context = new BindingContext(model, targetAttribute, simpleBinding);
        Debug.trace("\n[data] bind to target: " + targetNode.getNodeName(), "databind");
        HTMLCommand cmd = BindingCommandFactory.determineBindingCommand(targetNode, context);
        return cmd;
    }

    private static HTMLCommand determineBindingCommand(Node targetNode, BindingContext context) {
        try {
            Iterator providersIter = BindingCommandFactory.getProvidersList().iterator();
            boolean prohibit = false;
            HTMLCommand command = null;
            while (providersIter.hasNext() && !prohibit) {
                IBindingCommandProvider provider = (IBindingCommandProvider)providersIter.next();
                int code = provider.getBindingIntent(targetNode, context);
                switch (code) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        command = provider.determineBindingCommand(targetNode, context);
                        prohibit = true;
                        break;
                    }
                    case 2: {
                        prohibit = true;
                        if (Boolean.TRUE.equals(context.getModel().getCustomProperty((Object)"previewCommandOnly"))) break;
                        if (Display.getCurrent() != null && EditDomainUtil.getEditDomain().getDialogParent() != null) {
                            Shell shell = EditDomainUtil.getEditDomain().getDialogParent();
                            MessageDialog.openInformation((Shell)shell, (String)Messages.BindingCommandFactory_Prohibited, (String)Messages.BindingCommandFactory_ProhibitedInfo);
                            break;
                        }
                        System.out.println(Messages.BindingCommandFactory_Prohibited);
                        System.out.println(Messages.BindingCommandFactory_ProhibitedInfo);
                    }
                }
            }
            return command;
        }
        catch (Exception e) {
            JsfPlugin.log(e);
            return null;
        }
    }

    private static List getProvidersList() {
        return ExtensionRegistry.getRegistry().getBindingCommandProviders();
    }
}

