/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.databind.commands;

import com.ibm.etools.jsf.JsfPlugin;
import com.ibm.etools.jsf.databind.adapters.IJsfDataAdapter;
import com.ibm.etools.jsf.databind.adapters.ITagDefinition;
import com.ibm.etools.jsf.databind.commands.AbstractDataBindCommand;
import com.ibm.etools.jsf.databind.commands.builder.BindingContext;
import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.databind.commands.builder.IJsfCommandPreviewer;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.support.StringUtil;
import com.ibm.etools.jsf.util.JsfComponentUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.jsf.util.constants.BasicTags;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SetValueCommand
extends AbstractDataBindCommand
implements IJsfCommandPreviewer {
    private static final String VALUE_HOLDER_CLASSNAME = "javax.faces.component.ValueHolder";
    protected boolean resetModel = true;
    private boolean bindToParent = false;
    private boolean multiValuedReference = false;

    @Override
    protected boolean isValidTarget(Node node) {
        return JsfComponentUtil.isJsfTag((Node)node) || JsfComponentUtil.isConverterTag((Node)node) || JsfComponentUtil.isValidatorTag((Node)node);
    }

    @Override
    protected void doDataBind() {
        String attributeName;
        BindingContext context = this.getBindingContext();
        Element tag = (Element)this.getTargetNode();
        if (!this.allowsAttribute(tag, attributeName = context.getTargetAttribute())) {
            return;
        }
        if (this.resetModel) {
            BindingUtil.resetModel(tag, context);
        }
        IPageDataNode bindToNode = null;
        String ref = null;
        int numProperties = context.getPropertyNames().length;
        if (context.getPropertyNames() != null && numProperties == 1) {
            if (this.bindToParent || this.multiValuedReference && context.getBeanNode().getChildren() != null && context.getBeanNode().getChildren().size() == 1 && !((ICodeGenNode)context.getModel().getCodeGenNodes().get(0)).isListNode()) {
                ref = context.getBeanName();
                bindToNode = context.getBeanNode();
            } else {
                ref = context.getFullPropertyNames()[0];
                bindToNode = context.getPropertyNodes()[0];
            }
        } else {
            IPageDataNode beanNode = context.getBeanNode();
            if (BindingUtil.hasChildren(beanNode) && numProperties > 0) {
                if (beanNode.getChildren().size() > 1) {
                    ref = context.getBeanName();
                    bindToNode = context.getBeanNode();
                } else {
                    ref = context.getFullPropertyNames()[0];
                    bindToNode = context.getPropertyNodes()[0];
                }
            } else {
                ref = context.getBeanName();
                bindToNode = context.getBeanNode();
            }
        }
        if (ref != null) {
            if (!this.multiValuedReference) {
                tag.setAttribute(attributeName, BindingUtil.makeVbl(ref));
            } else {
                tag.setAttribute(attributeName, BindingUtil.makeVbl(BindingUtil.removeLastIndexReference(ref)));
            }
        }
        if ("value".equals(context.getTargetAttribute()) && JsfComponentUtil.checkComponentSuperclass((Node)tag, (String)VALUE_HOLDER_CLASSNAME) && !StringUtil.belongsTo(tag.getLocalName(), BasicTags.SELECT_TAGS) && !"selectBooleanCheckbox".equals(tag.getLocalName())) {
            this.setConverter(bindToNode);
        }
    }

    public void setMultiValuedReference(boolean b) {
        this.multiValuedReference = b;
    }

    private void setConverter(IPageDataNode bindToNode) {
        IJsfDataAdapter adapter = (IJsfDataAdapter)bindToNode.getAdapter(IJsfDataAdapter.ADAPTER_KEY);
        if (adapter == null) {
            return;
        }
        String converterTaglibUri = null;
        String converterTagName = null;
        ITagDefinition converterTag = adapter.getConverterTag();
        if (converterTag != null) {
            converterTaglibUri = converterTag.getTaglibUri();
            converterTagName = converterTag.getTagName();
        }
        if (converterTaglibUri != null && converterTagName != null) {
            String prefix;
            Document d = this.getTargetNode().getOwnerDocument();
            TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)d);
            Node existingConverter = this.findExistingConverter();
            if (existingConverter != null) {
                String existingUri = mapper.getUriForPrefix(existingConverter.getPrefix());
                String existingName = existingConverter.getLocalName();
                if (converterTaglibUri.equals(existingUri) && converterTagName.equals(existingName)) {
                    return;
                }
            }
            if ((prefix = mapper.getPrefixForUri(converterTaglibUri)) == null) {
                if (converterTag != null) {
                    prefix = converterTag.getPreferredPrefix();
                }
                if (prefix == null) {
                    prefix = "fx";
                }
                while (mapper.getUriForPrefix(prefix) != null) {
                    prefix = String.valueOf(prefix) + "x";
                }
                HTMLCommand cmd = JsfCommandUtil.getTaglibInsertCommand(converterTaglibUri, prefix);
                this.getDomain().execCommand((Command)cmd);
                mapper.addMapping(prefix, converterTaglibUri);
            }
            Element newConverter = d.createElement(String.valueOf(prefix) + ":" + converterTagName);
            Map converterAttributes = null;
            if (converterTag != null) {
                converterAttributes = converterTag.getAttributes();
            }
            if (converterAttributes != null) {
                for (String attribute : converterAttributes.keySet()) {
                    String value = (String)converterAttributes.get(attribute);
                    newConverter.setAttribute(attribute, value);
                }
                JsfCommandUtil.cleanupNodeAttributes(newConverter);
            }
            if (existingConverter != null) {
                existingConverter.getParentNode().replaceChild(newConverter, existingConverter);
            } else {
                this.getTargetNode().appendChild(newConverter);
            }
        } else {
            Node existingConverter = this.findExistingConverter();
            if (existingConverter != null) {
                if ("convertMask".equals(existingConverter.getLocalName())) {
                    return;
                }
                existingConverter.getParentNode().removeChild(existingConverter);
            }
        }
    }

    private Node findExistingConverter() {
        Node target = this.getTargetNode();
        Node child = target.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 3 && JsfComponentUtil.isConverterTag((Node)child)) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public boolean getMultiValuedReference() {
        return this.multiValuedReference;
    }

    public void setResetModel(boolean value) {
        this.resetModel = value;
    }

    public void setBindToParent(boolean value) {
        this.bindToParent = value;
    }

    @Override
    public String getCommandPreview() {
        IPageDataNode beanNode;
        Element tag;
        BindingContext context;
        block6: {
            block5: {
                try {
                    if (this.isValidTarget(this.getTargetNode())) break block5;
                    return null;
                }
                catch (Exception e) {
                    JsfPlugin.log(e);
                    return null;
                }
            }
            context = this.getBindingContext();
            tag = (Element)this.getTargetNode();
            String attributeName = context.getTargetAttribute();
            if (this.allowsAttribute(tag, attributeName)) break block6;
            return null;
        }
        if (this.resetModel) {
            BindingUtil.resetModel(tag, context);
        }
        String ref = null;
        int numProperties = context.getPropertyNames().length;
        ref = context.getPropertyNames() != null && numProperties == 1 ? (this.bindToParent || this.multiValuedReference && context.getBeanNode().getChildren() != null && context.getBeanNode().getChildren().size() == 1 && !((ICodeGenNode)context.getModel().getCodeGenNodes().get(0)).isListNode() ? context.getBeanName() : context.getFullPropertyNames()[0]) : (BindingUtil.hasChildren(beanNode = context.getBeanNode()) && numProperties > 0 ? (beanNode.getChildren().size() > 1 ? context.getBeanName() : context.getFullPropertyNames()[0]) : context.getBeanName());
        return ref;
    }
}

