/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.databind.commands;

import com.ibm.etools.jsf.databind.commands.AbstractDataBindCommand;
import com.ibm.etools.jsf.databind.commands.DataTableBindingHelper;
import com.ibm.etools.jsf.databind.commands.builder.BindingContext;
import com.ibm.etools.jsf.databind.commands.builder.BindingUtil;
import com.ibm.etools.jsf.databind.generator.DataTableGenerator;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.palette.commands.JsfCommandUtil;
import com.ibm.etools.jsf.util.EditDomainUtil;
import com.ibm.etools.jsf.util.TaglibPrefixUtil;
import com.ibm.etools.webedit.common.utils.SelectionUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.databinding.CodeGenModelFactory;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenModel;
import com.ibm.etools.webtools.pagedatamodel.databinding.api.ICodeGenNode;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.DocumentRange;
import org.w3c.dom.ranges.Range;

public class DataTableCommand
extends AbstractDataBindCommand {
    private Document doc;
    private String corePrefix;
    private String htmlPrefix;
    private String extPrefix;
    private Node dataTable;
    private Node targetColumn;

    @Override
    protected boolean isValidTarget(Node node) {
        if (node != null) {
            if (node.getLocalName().equals("dataTable")) {
                return true;
            }
            if (node.getLocalName().equals("column")) {
                return true;
            }
            if (node.getLocalName().equals("dataTableEx")) {
                return true;
            }
            if (node.getLocalName().equals("columnEx")) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void doDataBind() {
        IPageDataNode pdNode;
        Node targetNode = this.getTargetNode();
        this.doc = targetNode.getOwnerDocument();
        BindingContext context = this.getBindingContext();
        if (context.getPropertyNames().length == 0) {
            return;
        }
        TaglibPrefixUtil mapper = TaglibPrefixUtil.getMapperUtil((Document)this.doc);
        this.corePrefix = mapper.getPrefixForUri("http://java.sun.com/jsf/core");
        this.htmlPrefix = mapper.getPrefixForUri("http://java.sun.com/jsf/html");
        this.extPrefix = mapper.getPrefixForUri("http://www.ibm.com/jsf/html_extended");
        if (this.corePrefix == null || this.htmlPrefix == null && this.extPrefix == null) {
            return;
        }
        String targetName = targetNode.getLocalName();
        if (targetName.equals("dataTable")) {
            this.dataTable = targetNode;
        }
        if (targetName.equals("column")) {
            this.dataTable = targetNode.getParentNode();
            this.targetColumn = targetNode;
        }
        if (targetName.equals("dataTableEx")) {
            this.dataTable = targetNode;
        }
        if (targetName.equals("columnEx")) {
            this.dataTable = targetNode.getParentNode();
            this.targetColumn = targetNode;
        }
        if (context.getPropertyNames().length == 1 && context.isListNode(pdNode = context.getPropertyNodes()[0]) && !BindingUtil.hasChildren(pdNode) && !context.isListNode(context.getBeanNode())) {
            context.setBeanName(String.valueOf(context.getBeanName()) + "." + context.getPropertyNames()[0]);
        }
        if (!this.checkMatchingValueReferences()) {
            if (Display.getCurrent() != null && EditDomainUtil.getEditDomain().getDialogParent() != null) {
                Shell shell = EditDomainUtil.getEditDomain().getDialogParent();
                MessageDialog.openInformation((Shell)shell, (String)Messages.DataTableCommand_Failed, (String)Messages.DataTableCommand_FailedInfo);
            } else {
                System.out.println(Messages.DataTableCommand_Failed);
                System.out.println(Messages.DataTableCommand_FailedInfo);
            }
            return;
        }
        if (this.launchWizard()) {
            this.bindDataTableAttributes();
            this.addColumns();
        }
    }

    private boolean launchWizard() {
        ICodeGenModel model = this.getBindingContext().getModel();
        try {
            CodeGenModelFactory.configureInWizard((ICodeGenModel)model);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean checkMatchingValueReferences() {
        String dataTableValue = ((Element)this.dataTable).getAttribute("value");
        String dataTableVar = ((Element)this.dataTable).getAttribute("var");
        String equivalentValue = BindingUtil.calculateEquivalentValue(this.dataTable);
        dataTableValue = BindingUtil.removeAllIndexReferences(BindingUtil.removeVbl(dataTableValue));
        dataTableVar = BindingUtil.removeAllIndexReferences(BindingUtil.removeVbl(dataTableVar));
        String droppedValue = BindingUtil.removeAllIndexReferences(BindingUtil.removeVbl(this.getBindingContext().getBeanName()));
        return DataTableBindingHelper.sameBean(droppedValue, dataTableValue) || DataTableBindingHelper.sameBean(droppedValue, dataTableVar) || DataTableBindingHelper.sameBean(droppedValue, equivalentValue);
    }

    private void bindDataTableAttributes() {
        Element elem = (Element)this.dataTable;
        String currentVar = elem.getAttribute("var");
        if (currentVar == null) {
            BindingContext context = this.getBindingContext();
            String beanName = BindingUtil.removeLastIndexReference(context.getBeanName());
            elem.setAttribute("value", BindingUtil.makeVbl(beanName));
            elem.setAttribute("var", BindingUtil.computeVarAttribute(this.dataTable, beanName));
        }
    }

    protected void addColumns() {
        String currentVar = ((Element)this.dataTable).getAttribute("var");
        ICodeGenModel model = this.getBindingContext().getModel();
        DataTableGenerator generator = new DataTableGenerator();
        ICodeGenNode gridNode = model.getRoot();
        generator.setCodeGenNode(gridNode);
        generator.setVar(currentVar);
        String columnTags = generator.generateColumns();
        Range newRange = null;
        if (this.targetColumn != null) {
            String rowCatTagName;
            NodeList rowCatNodes;
            Document d = this.targetColumn.getOwnerDocument();
            if (this.extPrefix != null && (rowCatNodes = ((Element)this.targetColumn).getElementsByTagName(rowCatTagName = String.valueOf(this.extPrefix) + ":" + "panelRowCategory")).getLength() > 0) {
                newRange = ((DocumentRange)((Object)d)).createRange();
                newRange.setStartAfter(this.targetColumn);
                newRange.setEndAfter(this.targetColumn);
            }
            if (newRange == null) {
                newRange = ((DocumentRange)((Object)d)).createRange();
                newRange.setStartBefore(this.targetColumn);
                newRange.setEndBefore(this.targetColumn);
            }
        } else {
            NodeList gridChildren = this.dataTable.getChildNodes();
            int numChildren = gridChildren.getLength();
            if (numChildren == 0) {
                newRange = this.getRange();
            } else {
                newRange = ((DocumentRange)((Object)this.dataTable.getOwnerDocument())).createRange();
                Node appendAfterNode = gridChildren.item(numChildren - 1);
                newRange.setStartAfter(appendAfterNode);
                newRange.setEndAfter(appendAfterNode);
            }
        }
        if (columnTags == null || columnTags.length() == 0) {
            return;
        }
        int start = SelectionUtil.calcFlatModelOffset((IDOMNode)((IDOMNode)newRange.getStartContainer()), (int)newRange.getStartOffset());
        Document d = JsfCommandUtil.getDocument(this.dataTable);
        try {
            ((IDOMDocument)d).getStructuredDocument().replace(start, 0, columnTags);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    protected String getCorePrefix() {
        return this.corePrefix;
    }

    protected void setCorePrefix(String corePrefix) {
        this.corePrefix = corePrefix;
    }

    protected Node getDataTable() {
        return this.dataTable;
    }

    protected void setDataTable(Node dataTable) {
        this.dataTable = dataTable;
    }

    protected Document getDoc() {
        return this.doc;
    }

    protected void setDoc(Document doc) {
        this.doc = doc;
    }

    protected String getExtPrefix() {
        return this.extPrefix;
    }

    protected void setExtPrefix(String extPrefix) {
        this.extPrefix = extPrefix;
    }

    protected String getHtmlPrefix() {
        return this.htmlPrefix;
    }

    protected void setHtmlPrefix(String htmlPrefix) {
        this.htmlPrefix = htmlPrefix;
    }

    protected Node getTargetColumn() {
        return this.targetColumn;
    }

    protected void setTargetColumn(Node targetColumn) {
        this.targetColumn = targetColumn;
    }
}

