/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview.parts;

import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVStringComponent;
import com.ibm.etools.attrview.sdk.AVTextConverter;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class TextPart
extends AVPart
implements AVStringComponent,
VerifyListener {
    static final int KC_ENTER = 13;
    protected Text text;
    private AVTextConverter converter;
    private boolean labelAlignLeft;
    private boolean noborder;
    private boolean fill;
    private String message = null;
    private int numRows = 1;

    public TextPart(AVData data, Composite parent, String title, AVTextConverter converter) {
        this(data, parent, title, converter, false);
    }

    public TextPart(AVData data, Composite parent, String title, AVTextConverter converter, boolean labelAlignLeft) {
        this(data, parent, title, converter, labelAlignLeft, false, false);
    }

    public TextPart(AVData data, Composite parent, String title, AVTextConverter converter, boolean labelAlignLeft, boolean noborder, boolean fill) {
        super(data, parent, title);
        this.converter = converter;
        this.labelAlignLeft = labelAlignLeft;
        this.noborder = noborder;
        this.fill = fill;
        this.createContents();
    }

    public TextPart(AVData data, Composite parent, String title, AVTextConverter converter, boolean labelAlignLeft, boolean noborder, boolean fill, int numRows) {
        this(data, parent, title, converter, labelAlignLeft, noborder, fill, numRows, null);
    }

    public TextPart(AVData data, Composite parent, String title, AVTextConverter converter, boolean labelAlignLeft, boolean noborder, boolean fill, int numRows, String message) {
        super(data, parent, title);
        this.converter = converter;
        this.labelAlignLeft = labelAlignLeft;
        this.noborder = noborder;
        this.fill = fill;
        this.numRows = numRows;
        this.message = message;
        this.createContents();
    }

    protected void createContents() {
        Object data;
        if (this.getTitle() != null) {
            this.initializeContainer(this.labelAlignLeft ? 2 : 1, this.fill);
            this.createLabel();
            if (this.labelAlignLeft) {
                WidgetUtil.setVerticalAlignment((Control)this.getAccLabel(), (int)1);
            }
        } else {
            this.initializeContainer(1, this.fill);
        }
        ((GridLayout)this.getContainer().getLayout()).verticalSpacing = 8;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = this.fill ? 4 : 1;
        gridData.verticalAlignment = 1;
        gridData.heightHint = WidgetUtil.getTextExtent((Control)this.getContainer(), (String)"X").y * this.numRows;
        int style = 578;
        if (!this.noborder) {
            style |= 0x800;
        }
        this.text = this.getWidgetFactory().createText(this.getContainer(), style);
        this.text.setLayoutData((Object)gridData);
        this.text.addFocusListener((FocusListener)this);
        this.text.addKeyListener((KeyListener)this);
        this.text.addModifyListener((ModifyListener)this);
        this.text.addMouseListener((MouseListener)this);
        this.text.addVerifyListener((VerifyListener)this);
        if (this.message != null) {
            this.text.setText(this.message);
        }
        if (this.fill && (data = this.text.getLayoutData()) instanceof GridData) {
            ((GridData)data).widthHint = 0;
        }
        this.setControls(new Control[]{this.text});
        this.createAdditionalControls(this.getContainer());
    }

    protected abstract void createAdditionalControls(Composite var1);

    public void dispose() {
        TextPart.dispose((Widget)this.text);
        this.text = null;
        super.dispose();
    }

    public Control getFocusControl() {
        if (this.text.isFocusControl()) {
            return this.text;
        }
        return super.getFocusControl();
    }

    public String getString() {
        String string = this.text.getText();
        if (string != null && string.length() > 0 && string.indexOf(this.message) == -1) {
            return string;
        }
        return null;
    }

    public Text getTextControl() {
        return this.text;
    }

    public String getValue() {
        return this.converter.convertLineDelimiters(this.getString(), null);
    }

    public boolean isSpecified() {
        return this.getString() != null;
    }

    public void keyPressed(KeyEvent e) {
        if (e.character == '\r' && (e.stateMask & 0x20000) == 0) {
            super.keyPressed(e);
        }
    }

    public void reset() {
        super.reset();
        if (this.message == null) {
            this.text.setText("");
        } else {
            this.text.setText(this.message);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }

    private void setValue(String string) {
        if (string != null && this.converter != null) {
            string = this.converter.convertLineDelimiters(string, null);
        }
        this.text.setText(string != null ? string : "");
    }

    protected void update() {
        AVData data = this.getDataComponent();
        if (data != null && data.isValueSpecified()) {
            this.setValue(data.getValue());
            this.setAmbiguous(data.isAmbiguous());
            this.setEnabled(data.isEditable());
        } else {
            this.reset();
        }
    }

    public void verifyText(VerifyEvent e) {
        if (e.character == '\r' && (e.stateMask & 0x20000) != 0) {
            e.doit = false;
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

