/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview.parts;

import com.ibm.etools.attrview.internal.sdk.DisplayString;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.attrview.sdk.AVValueItemUtil;
import com.ibm.etools.jsf.attrview.JsfWidgetUtil;
import com.ibm.etools.jsf.attrview.parts.ComboButtonPart;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.dialogs.PatternBuilderDialog;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ConverterPatternComboPart
extends ComboButtonPart {
    private DisplayString displayString;
    final int patternType;

    public ConverterPatternComboPart(AVData data, Composite parent, String title, int patternType, boolean fill) {
        super(data, parent, title, null, false, fill);
        this.patternType = patternType;
    }

    @Override
    protected Button createBrowseButton(Composite parent) {
        Button button = JsfWidgetUtil.createImageButton(this.getWidgetFactory(), this.getContainer(), "browse_pattern", Messages.BuildPattern, Messages.BuildPattern);
        return button;
    }

    @Override
    protected void browse(TypedEvent e) {
        PatternBuilderDialog dlg = new PatternBuilderDialog(this.getParent().getShell(), this.patternType);
        dlg.setAttrVal(this.getValue(), null);
        if (dlg.open() == 0) {
            this.setString(dlg.getAttrVal());
            this.setModified(true);
            this.getComboControl().setFocus();
            this.fireValueChange();
            this.getPage().updateData(this.getDataComponent().getSelection().getEditorContextProvider());
        }
    }

    @Override
    protected void setValue(String value) {
        this.setString(value);
    }

    public String getString() {
        String string = this.combo.getText();
        if (this.displayString != null) {
            string = this.displayString.getValue(string);
        }
        String value = string;
        AVValueItem[] items = this.getItems();
        int index = AVValueItemUtil.getItemIndexByDisplayString((AVValueItem[])items, (String)string);
        if (index != -1) {
            value = items[index].getValue();
        }
        if (value != null && value.length() > 0) {
            return value;
        }
        return null;
    }

    public String getValue() {
        return this.getString();
    }

    public void setString(String string) {
        AVValueItem[] items = this.getItems();
        int index = AVValueItemUtil.getItemIndexByValue((AVValueItem[])items, (String)string);
        if (index != -1) {
            int comboIndex = this.combo.getSelectionIndex();
            if (index != comboIndex) {
                String title = items[index].getDisplayString();
                this.displayString = new DisplayString(title);
                this.combo.setText(this.displayString.getDisplayString());
                this.combo.select(index);
            }
        } else {
            this.displayString = new DisplayString(string);
            this.combo.setText(this.displayString.getDisplayString());
        }
    }

    public void reset() {
        super.reset();
        this.combo.setText("");
        this.displayString = null;
    }
}

