/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview.parts;

import com.ibm.etools.attrview.AVWidgetFactory;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVSelectComponent;
import com.ibm.etools.attrview.sdk.AVValueItem;
import com.ibm.etools.attrview.utils.WidgetUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class ComboButtonPart
extends AVPart
implements AVSelectComponent {
    protected CCombo combo;
    protected Button button;
    protected boolean readOnly;
    protected boolean fill;
    protected String tagName;
    protected String attrName;
    protected String oldValue = null;
    private String[] comboItems = null;
    private boolean selectionChanged = false;
    protected IPageDataModel model;

    public ComboButtonPart(AVData data, Composite parent, String title, String[] comboValues) {
        super(data, parent, title);
        this.readOnly = true;
        this.fill = true;
        this.comboItems = comboValues;
        this.createContents();
    }

    public ComboButtonPart(AVData data, Composite parent, String title, String[] comboValues, boolean readonly, boolean fill) {
        super(data, parent, title);
        this.readOnly = readonly;
        this.fill = fill;
        this.comboItems = comboValues;
        this.createContents();
    }

    protected void createContents() {
        if (this.getTitle() != null) {
            this.initializeContainer(3);
            this.createLabel();
        } else {
            this.initializeContainer(2);
        }
        if (this.comboItems == null) {
            this.setComboItems(new String[]{""});
        }
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        int n = gridData.horizontalAlignment = this.fill ? 4 : 1;
        if (this.readOnly) {
            this.combo = WidgetUtil.createCombo((AVWidgetFactory)this.getWidgetFactory(), (Composite)this.getContainer(), (String[])this.comboItems, (int)(8 | WidgetUtil.COMBO_BORDER_STYLE), (GridData)gridData);
        } else {
            this.combo = WidgetUtil.createCombo((AVWidgetFactory)this.getWidgetFactory(), (Composite)this.getContainer(), (String[])this.comboItems, (int)WidgetUtil.COMBO_BORDER_STYLE, (GridData)gridData);
            this.combo.addFocusListener((FocusListener)this);
            this.combo.addKeyListener((KeyListener)this);
            this.combo.addModifyListener((ModifyListener)this);
            this.combo.addMouseListener((MouseListener)this);
        }
        this.combo.addSelectionListener((SelectionListener)this);
        this.button = this.createBrowseButton(this.getContainer());
        this.button.addFocusListener((FocusListener)this);
        this.button.addSelectionListener((SelectionListener)this);
        this.setControls(new Control[]{this.combo});
    }

    protected abstract Button createBrowseButton(Composite var1);

    protected abstract void browse(TypedEvent var1);

    public void dispose() {
        super.dispose();
        ComboButtonPart.dispose((Widget)this.combo);
        this.combo = null;
        ComboButtonPart.dispose((Widget)this.button);
        this.button = null;
    }

    public CCombo getComboControl() {
        return this.combo;
    }

    protected void addListeners() {
        if (!this.readOnly) {
            this.combo.addFocusListener((FocusListener)this);
            this.combo.addKeyListener((KeyListener)this);
            this.combo.addModifyListener((ModifyListener)this);
            this.combo.addMouseListener((MouseListener)this);
        }
        this.combo.addSelectionListener((SelectionListener)this);
        this.button.addFocusListener((FocusListener)this);
        this.button.addSelectionListener((SelectionListener)this);
    }

    protected void removeListeners() {
        if (!this.readOnly) {
            this.combo.removeFocusListener((FocusListener)this);
            this.combo.removeKeyListener((KeyListener)this);
            this.combo.removeModifyListener((ModifyListener)this);
            this.combo.removeMouseListener((MouseListener)this);
        }
        this.combo.removeSelectionListener((SelectionListener)this);
        this.button.removeFocusListener((FocusListener)this);
        this.button.removeSelectionListener((SelectionListener)this);
    }

    public Control getFocusControl() {
        if (this.combo.isFocusControl()) {
            return this.combo;
        }
        return super.getFocusControl();
    }

    public int getItemCount() {
        if (this.getDataComponent() instanceof AVSelectComponent) {
            return ((AVSelectComponent)this.getDataComponent()).getItemCount();
        }
        return 0;
    }

    public AVValueItem[] getItems() {
        if (this.getDataComponent() instanceof AVSelectComponent) {
            return ((AVSelectComponent)this.getDataComponent()).getItems();
        }
        return null;
    }

    public int getSelectionIndex() {
        return this.combo.getSelectionIndex();
    }

    protected void initItems(AVData data) {
        AVValueItem[] items;
        if (this.combo == null) {
            return;
        }
        if (data != null && data instanceof AVSelectComponent && (items = ((AVSelectComponent)data).getItems()) != null && items.length > 0) {
            this.combo.removeAll();
            int i = 0;
            while (i < items.length) {
                this.combo.add(items[i].getDisplayString());
                ++i;
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.combo.setEnabled(this.isEnabled());
        this.button.setEnabled(this.isEnabled());
    }

    protected abstract void setValue(String var1);

    protected void update() {
        this.setValid(true);
        AVData data = this.getDataComponent();
        this.initItems(data);
        if (data != null && data.isValueSpecified()) {
            String value = data.getValue();
            this.setValue(value);
            this.setAmbiguous(data.isAmbiguous());
        } else {
            this.reset();
        }
    }

    public void setComboItems(String[] strings) {
        this.comboItems = strings;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.button) {
            this.browse((TypedEvent)e);
        } else if (e.widget == this.combo && !((CCombo)e.widget).getText().equals(this.oldValue)) {
            this.oldValue = ((CCombo)e.widget).getText();
            this.selectionChanged = true;
            if (this.isAmbiguous()) {
                this.setAmbiguous(false);
            }
            this.setModified(true);
            this.fireValueChange();
            super.widgetSelected(e);
            this.selectionChanged = true;
            super.widgetSelected(e);
        }
    }

    public boolean hasSelectionChanged() {
        return this.selectionChanged;
    }

    public void setSelectionChanged(boolean changed) {
        this.selectionChanged = changed;
    }
}

