/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.attrview.pages;

import com.ibm.etools.attrview.AVEditorContextProvider;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVEditableComboPart;
import com.ibm.etools.attrview.sdk.AVNumberPart;
import com.ibm.etools.attrview.sdk.AVPage;
import com.ibm.etools.jsf.attrview.JsfWidgetUtil;
import com.ibm.etools.jsf.attrview.pages.JsfPage;
import com.ibm.etools.jsf.attrview.pairs.RadioButtonPair;
import com.ibm.etools.jsf.internal.nls.Messages;
import com.ibm.etools.jsf.support.JsfAccessibleAdapter;
import com.ibm.etools.jsf.support.visualization.VisualizerUtil;
import com.ibm.etools.webedit.common.attrview.data.AttributeData;
import com.ibm.etools.webedit.common.attrview.pairs.AccessKeysPair;
import com.ibm.etools.webedit.common.attrview.pairs.HTMLPair;
import com.ibm.etools.webedit.common.attrview.pairs.StringPair;
import com.ibm.etools.webedit.common.attrview.pairs.TabPair;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Node;

public class AccessibilityPageBase
extends JsfPage {
    private Composite container = null;
    protected static final String ACCESSKEY = Messages.UI_PROPPAGE_Others_Access_key__1;
    protected static final String TABINDEX = Messages.UI_PROPPAGE_Others_Tab_display_order__2;
    protected static final String TITLE = Messages.UI_PROPPAGE_Others_Title_3;
    protected static final String EMPTY = Messages._UI_Alt_Empty;
    protected static final String ALT = Messages.UI_PROPPAGE_Others_Alt__4;
    protected AccessKeysPair accessKeyPair = null;
    protected StringPair titleTextPair = null;
    protected TabPair tabIndexPair = null;
    private RadioButtonPair radioPair = null;
    private StringPair alternateTextPair = null;
    protected Composite parent = null;

    public AccessibilityPageBase() {
        super(Messages.AccessibilityPageBase_Accessibility_2);
        this.tagName = String.valueOf(this.HTML_PREFIX) + "inputText";
    }

    public AccessibilityPageBase(String name) {
        super(name);
        this.tagName = String.valueOf(this.HTML_PREFIX) + "inputText";
    }

    protected void create() {
        this.container = this.createPageContainer(2);
        this.parent = this.createAreaComposite(this.container, 7);
        this.createAccessKey();
        this.createTabIndex();
        this.createTitle();
        this.createAlt();
        this.align();
    }

    protected void createAccessKey() {
        this.accessKeyPair = new AccessKeysPair((AVPage)this, new String[]{this.tagName}, "accesskey", this.parent, ACCESSKEY);
        this.resetPairContainer((HTMLPair)this.accessKeyPair, 1, 3);
        this.addPairComponent((HTMLPair)this.accessKeyPair);
    }

    protected void createTabIndex() {
        this.tabIndexPair = new TabPair((AVPage)this, new String[]{this.tagName}, "tabindex", this.parent, TABINDEX);
        this.resetPairContainer((HTMLPair)this.tabIndexPair, 1, 3);
        this.addPairComponent((HTMLPair)this.tabIndexPair);
    }

    protected void createTitle() {
        this.titleTextPair = new StringPair((AVPage)this, new String[]{this.tagName}, "title", this.parent, TITLE);
        this.resetPairContainer((HTMLPair)this.titleTextPair, 1, 3);
        this.addPairComponent((HTMLPair)this.titleTextPair);
    }

    protected void createAlt() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 7;
        gridLayout.makeColumnsEqualWidth = false;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 3;
        Composite twoCols = this.getWidgetFactory().createComposite(this.parent, 0);
        twoCols.setLayout((Layout)gridLayout);
        twoCols.setLayoutData((Object)gridData);
        String[] values = new String[]{"1", "2"};
        String[] displays = new String[]{EMPTY, ALT};
        this.radioPair = new RadioButtonPair((AVPage)this, new String[]{this.tagName}, "alt", twoCols, null, values, displays, 2);
        if (this.radioPair.getContainer().getLayoutData() == null) {
            this.radioPair.getContainer().setLayoutData((Object)new GridData());
        }
        ((GridData)this.radioPair.getContainer().getLayoutData()).grabExcessHorizontalSpace = false;
        ((GridData)this.radioPair.getContainer().getLayoutData()).horizontalAlignment = 1;
        this.radioPair.removeValidators();
        this.addPairComponent(this.radioPair);
        this.resetPairContainer(this.radioPair, 0, 0);
        this.alternateTextPair = new StringPair((AVPage)this, new String[]{this.tagName}, "alt", twoCols, "");
        this.alternateTextPair.getControl().getAccessible().addAccessibleListener((AccessibleListener)new JsfAccessibleAdapter(ALT));
        this.resetPairContainer((HTMLPair)this.alternateTextPair, 1, 3);
        this.addPairComponent((HTMLPair)this.alternateTextPair);
    }

    protected void align() {
        int num = 0;
        if (this.accessKeyPair != null) {
            ++num;
        }
        if (this.tabIndexPair != null) {
            ++num;
        }
        if (this.titleTextPair != null) {
            ++num;
        }
        if (num >= 2) {
            Control[] controls = new Control[num];
            int i = 0;
            if (this.accessKeyPair != null) {
                controls[i++] = this.accessKeyPair.getLabel();
            }
            if (this.tabIndexPair != null) {
                controls[i++] = this.tabIndexPair.getLabel();
            }
            if (this.titleTextPair != null) {
                controls[i++] = this.titleTextPair.getLabel();
            }
            this.alignWidth(controls);
        }
        int width = JsfWidgetUtil.getLenInPixels(this.parent, "XX") + 20;
        if (this.accessKeyPair != null) {
            if (((AVEditableComboPart)this.accessKeyPair.getPart()).getComboControl().getLayoutData() == null) {
                ((AVEditableComboPart)this.accessKeyPair.getPart()).getComboControl().setLayoutData((Object)new GridData());
            }
            ((GridData)((AVEditableComboPart)this.accessKeyPair.getPart()).getComboControl().getLayoutData()).widthHint = width;
            ((GridData)((AVEditableComboPart)this.accessKeyPair.getPart()).getComboControl().getLayoutData()).horizontalAlignment = 1;
        }
        if (this.tabIndexPair != null) {
            if (((AVNumberPart)this.tabIndexPair.getPart()).getTextControl().getLayoutData() == null) {
                ((AVNumberPart)this.tabIndexPair.getPart()).getTextControl().setLayoutData((Object)new GridData());
            }
            ((GridData)((AVNumberPart)this.tabIndexPair.getPart()).getTextControl().getLayoutData()).widthHint = width + 17;
        }
    }

    public void fireValueChange(AVData data) {
        if (this.radioPair != null && data == this.radioPair.getData()) {
            String value = this.alternateTextPair.getPart().getValue();
            String radioValue = this.radioPair.getPart().getValue();
            if (radioValue.equals("1")) {
                value = "";
            } else if (value == null || value.equals("")) {
                value = null;
            }
            this.launchCommand(this.tagName, ((AttributeData)data).getAttributeName(), value, true);
        } else {
            this.launchCommand(this.tagName, data);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.accessKeyPair != null) {
            AccessibilityPageBase.dispose((HTMLPair)this.accessKeyPair);
            this.accessKeyPair = null;
        }
        if (this.tabIndexPair != null) {
            AccessibilityPageBase.dispose((HTMLPair)this.tabIndexPair);
            this.tabIndexPair = null;
        }
        if (this.titleTextPair != null) {
            AccessibilityPageBase.dispose((HTMLPair)this.titleTextPair);
            this.titleTextPair = null;
        }
        if (this.radioPair != null) {
            AccessibilityPageBase.dispose(this.radioPair);
            this.radioPair = null;
        }
        if (this.alternateTextPair != null) {
            AccessibilityPageBase.dispose((HTMLPair)this.alternateTextPair);
            this.alternateTextPair = null;
        }
    }

    public void updateData(AVEditorContextProvider editorContext) {
        super.updateData(editorContext);
        if (this.radioPair != null) {
            Node targetNode = this.getSelectedNode();
            if (targetNode == null) {
                return;
            }
            String target = VisualizerUtil.getAttribute(targetNode, "alt");
            if (target != null && target.equals("")) {
                this.radioPair.getData().setValue("1");
                this.radioPair.getData().setValueSpecified(true);
            } else {
                this.radioPair.getData().setValue("2");
                this.radioPair.getData().setValueSpecified(true);
            }
        }
    }
}

