/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.internal.ui.editor.dialogs;

import com.ibm.etools.jsf.library.internal.nls.Messages;
import com.ibm.etools.jsf.library.internal.registry.ProductTaglibRegistry;
import com.ibm.etools.jsf.library.util.LibraryManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class TaglibSelectionDialog
extends TrayDialog {
    private List<String> productTaglibUris = ProductTaglibRegistry.getInstance().getProductTaglibUris();
    private Table table;
    private List<String> excludedUris;
    private String selectedUri;

    public TaglibSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TaglibSelectionDialog_SelectTaglib);
    }

    protected Control createDialogArea(Composite parent) {
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        page.setLayout((Layout)layout);
        GridData data = new GridData(768);
        page.setLayoutData((Object)data);
        new Label(parent, 0);
        Composite tableArea = new Composite(page, 0);
        GridLayout tableLayout = new GridLayout();
        tableLayout.marginHeight = 0;
        tableLayout.marginWidth = 0;
        tableArea.setLayout((Layout)tableLayout);
        GridData gridData = new GridData(770);
        gridData.heightHint = 150;
        gridData.widthHint = 250;
        tableArea.setLayoutData((Object)gridData);
        this.table = new Table(tableArea, 2052);
        this.table.setLinesVisible(true);
        this.initializeDialogUnits((Control)this.table);
        this.table.setLayoutData((Object)gridData);
        new TableColumn(this.table, 0);
        this.fillTable();
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle currentBounds = TaglibSelectionDialog.this.table.getBounds();
                TaglibSelectionDialog.this.table.setBounds(currentBounds.x, currentBounds.y, currentBounds.width, TaglibSelectionDialog.this.table.getItemHeight() * 10 + TaglibSelectionDialog.this.table.getBorderWidth() * 2);
                TaglibSelectionDialog.this.table.getColumn(0).setWidth(((TaglibSelectionDialog)TaglibSelectionDialog.this).table.getClientArea().width);
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TaglibSelectionDialog.this.okPressed();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.etools.jsf.library.TaglibSelectionDlg");
        return super.createDialogArea(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private void fillTable() {
        TableItem defaultItem = new TableItem(this.table, 0);
        defaultItem.setText("[" + Messages.TaglibSelectionDialog_NewTaglib + "]");
        ArrayList<String> allUris = new ArrayList<String>();
        int i = 0;
        while (i < this.productTaglibUris.size()) {
            if (!this.excludedUris.contains(this.productTaglibUris.get(i))) {
                allUris.add(this.productTaglibUris.get(i));
            }
            ++i;
        }
        String[] libraryTaglibUris = LibraryManager.getInstance().getLibraryTaglibUris();
        int i2 = 0;
        while (i2 < libraryTaglibUris.length) {
            if (!this.excludedUris.contains(libraryTaglibUris[i2])) {
                allUris.add(libraryTaglibUris[i2]);
            }
            ++i2;
        }
        Collections.sort(allUris);
        i2 = 0;
        while (i2 < allUris.size()) {
            TableItem item = new TableItem(this.table, 0);
            item.setText((String)allUris.get(i2));
            ++i2;
        }
    }

    public void setExcludedUris(List<String> excludedUris) {
        this.excludedUris = excludedUris;
    }

    protected void okPressed() {
        TableItem[] items = this.table.getSelection();
        if (items.length > 0) {
            this.selectedUri = items[0].getText();
        }
        super.okPressed();
    }

    public String getSelectedUri() {
        if (this.selectedUri != null) {
            return this.selectedUri;
        }
        String newTaglib = "[" + Messages.TaglibSelectionDialog_NewTaglib + "]";
        return newTaglib;
    }
}

