/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.internal.ui.editor.dialogs;

import com.ibm.etools.jsf.library.internal.nls.Messages;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SelectFilterDispatchersDialog
extends TrayDialog
implements SelectionListener {
    private String content;
    private List dispatchersList;

    public SelectFilterDispatchersDialog(Shell shell, String currentValue) {
        super(shell);
        this.content = currentValue;
    }

    private Composite createBaseComposite(Composite parent, int numColumns, boolean makeColumnsEqualWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = this.createBaseComposite(parent, 1, false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setData((Object)gridData);
        Label dispatchersLabel = new Label(composite, 0);
        dispatchersLabel.setText(Messages.SelectFilterDispatchersDialog_Label);
        this.dispatchersList = new List(composite, 2562);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.dispatchersList.setLayoutData((Object)gridData);
        this.dispatchersList.addSelectionListener((SelectionListener)this);
        this.dispatchersList.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                SelectFilterDispatchersDialog.this.okPressed();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.dispatchersList.add("FORWARD");
        this.dispatchersList.add("INCLUDE");
        this.dispatchersList.add("REQUEST");
        this.dispatchersList.add("ERROR");
        this.initializeSelection();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.jsf.library.SelectFilterDispatchersDialog");
        return composite;
    }

    protected void initializeSelection() {
        if (this.content != null) {
            ArrayList<String> selectedStrings = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(this.content, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                selectedStrings.add(token.trim());
            }
            this.dispatchersList.setSelection(selectedStrings.toArray(new String[0]));
        }
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        return control;
    }

    protected void okPressed() {
        StringBuffer buffer = new StringBuffer();
        String[] selected = this.dispatchersList.getSelection();
        int i = 0;
        while (i < selected.length) {
            buffer.append(selected[i]);
            if (i < selected.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        this.content = buffer.toString();
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SelectFilterDispatchersDialog_Title);
    }

    public String getContent() {
        return this.content;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
    }
}

