/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.internal.ui.editor.dialogs;

import com.ibm.etools.jsf.library.internal.nls.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class ExtendedElementTreeSelectionDialog
extends ElementTreeSelectionDialog
implements SelectionListener {
    private Button importBtn;
    private String[] filterExtensions = null;

    public ExtendedElementTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        this(parent, labelProvider, contentProvider, null);
    }

    public ExtendedElementTreeSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, String[] filterExtensions) {
        super(parent, labelProvider, contentProvider);
        this.filterExtensions = filterExtensions;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.importBtn = new Button(composite, 8);
        this.importBtn.setText(Messages.JSFLibrary_ExtendedElementTreeSelectionDialog_Import);
        this.importBtn.addSelectionListener((SelectionListener)this);
        this.importBtn.setEnabled(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.etools.jsf.library.SelectFileOrFolder");
        return composite;
    }

    private void enableControls() {
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        if (selection != null) {
            Object object = selection.getFirstElement();
            if (object instanceof IFolder || object instanceof IProject) {
                this.importBtn.setEnabled(true);
            } else {
                this.importBtn.setEnabled(false);
            }
        } else {
            this.importBtn.setEnabled(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() == this.importBtn) {
            String selectedFile = null;
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            dialog.setFilterExtensions(this.filterExtensions);
            selectedFile = dialog.open();
            if (selectedFile != null) {
                this.copyFile(selectedFile);
            }
        }
    }

    private void copyFile(String filePath) {
        File sourceFile = new File(filePath);
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        String targetFileName = sourceFile.getName();
        if (selection != null) {
            Object object = selection.getFirstElement();
            if (object instanceof IFolder) {
                IFolder targetFolder = (IFolder)object;
                IFile targetFile = targetFolder.getFile(targetFileName);
                try {
                    FileInputStream sourceStream = new FileInputStream(sourceFile);
                    if (!targetFile.exists()) {
                        targetFile.create((InputStream)sourceStream, true, null);
                    } else {
                        targetFile.setContents((InputStream)sourceStream, true, false, null);
                    }
                    this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)targetFile), true);
                    sourceStream.close();
                }
                catch (IOException iOException) {
                }
                catch (CoreException coreException) {}
            } else if (object instanceof IProject) {
                IFile targetFile = ((IProject)object).getFile(targetFileName);
                try {
                    FileInputStream sourceStream = new FileInputStream(sourceFile);
                    if (!targetFile.exists()) {
                        targetFile.create((InputStream)sourceStream, true, null);
                    } else {
                        targetFile.setContents((InputStream)sourceStream, true, false, null);
                    }
                    this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)targetFile), true);
                    sourceStream.close();
                }
                catch (IOException iOException) {
                }
                catch (CoreException coreException) {}
            }
        }
    }

    protected void updateOKStatus() {
        super.updateOKStatus();
        this.enableControls();
    }
}

