/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library.internal.palette;

import com.ibm.etools.jsf.library.event.ILibraryDefinitionChangeListener;
import com.ibm.etools.jsf.library.event.LibraryDefinitionChangeEvent;
import com.ibm.etools.jsf.util.JsfProjectUtil;
import com.ibm.etools.webedit.editor.HTMLEditor;
import com.ibm.etools.webedit.palette.PaletteRefresher;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class PaletteRefreshListener
implements ILibraryDefinitionChangeListener,
IPartListener2 {
    private static String lastUsedProjectName = null;

    public PaletteRefreshListener() {
        IWorkbenchWindow window;
        IWorkbench workbench;
        if (PlatformUI.isWorkbenchRunning() && (workbench = PlatformUI.getWorkbench()) != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            window.getPartService().addPartListener((IPartListener2)this);
        }
    }

    @Override
    public void libraryChanged(LibraryDefinitionChangeEvent event) {
        PaletteRefresher.getInstance().refreshAll();
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
        HTMLEditor editor;
        IEditorPart editorPart;
        if (partRef != null && partRef.getPart(false) instanceof IEditorPart && (editorPart = (IEditorPart)partRef.getPart(false)) instanceof HTMLEditor && (editor = (HTMLEditor)editorPart) != null && editor.getActiveModel() != null) {
            IDOMDocument doc = editor.getActiveModel().getDocument();
            if (doc == null) {
                return;
            }
            IProject project = JsfProjectUtil.getProjectForPage((IDOMDocument)doc);
            if (project == null) {
                return;
            }
            String projectName = project.getName();
            if (projectName == null) {
                return;
            }
            if (projectName.equals(lastUsedProjectName)) {
                return;
            }
            lastUsedProjectName = projectName;
            if (!JsfProjectUtil.isJsfProject((IProject)project)) {
                return;
            }
            PaletteRefresher.getInstance().refreshAll();
            return;
        }
        lastUsedProjectName = null;
    }

    public void partClosed(IWorkbenchPartReference arg0) {
    }

    public void partDeactivated(IWorkbenchPartReference arg0) {
    }

    public void partHidden(IWorkbenchPartReference arg0) {
    }

    public void partInputChanged(IWorkbenchPartReference arg0) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }
}

