/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.library;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.osgi.framework.Bundle;

public class Debug {
    public static final String TRACESTRING_LIBRARY = "library";
    public static final String PREFIX_LIBRARY = "[lib] ";
    private static final String PLUGIN_ID = "com.ibm.etools.jsf.library";
    private static final String DEBUG_OPTION = "com.ibm.etools.jsf.library/debug";
    public static final int OK_DEBUG = 0;
    public static final int INFO_DEBUG = 1;
    public static final int WARNING_DEBUG = 2;
    public static final int ERROR_DEBUG = 3;
    public static final int OK_ALWAYS = 4;
    public static final int INFO_ALWAYS = 5;
    public static final int WARNING_ALWAYS = 6;
    public static final int ERROR_ALWAYS = 7;
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;

    private static boolean isDebugging() {
        String debug = Platform.getDebugOption((String)DEBUG_OPTION);
        return debug == null ? false : debug.equalsIgnoreCase("true");
    }

    public static void trace(String message) {
        if (!Debug.isDebugging()) {
            return;
        }
        if (message == null) {
            return;
        }
        String option = "com.ibm.etools.jsf.library/debug/tracefilter";
        String traceFilter = Platform.getDebugOption((String)option);
        if (traceFilter != null && traceFilter.length() != 0) {
            return;
        }
        System.out.println(message);
    }

    public static void trace(String message, String category) {
        if (!Debug.isDebugging()) {
            return;
        }
        if (message == null) {
            return;
        }
        String option = "com.ibm.etools.jsf.library/debug/tracefilter";
        String traceFilter = Platform.getDebugOption((String)option);
        if (traceFilter == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(traceFilter, ", ");
        while (tokens.hasMoreTokens()) {
            String filter = tokens.nextToken();
            if (!category.equals(filter)) continue;
            System.out.println(message);
            break;
        }
    }

    public static void log(int level, String message) {
        if (message == null) {
            return;
        }
        if (!(level != 0 && level != 1 && level != 2 && level != 3 || Debug.isDebugging())) {
            return;
        }
        int severity = 0;
        switch (level) {
            case 1: 
            case 5: {
                severity = 1;
                break;
            }
            case 2: 
            case 6: {
                severity = 2;
                break;
            }
            case 3: 
            case 7: {
                severity = 4;
            }
        }
        Status StatusObj = new Status(severity, PLUGIN_ID, severity, message, null);
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log((IStatus)StatusObj);
    }

    public static void alert(int level, String message, String reason, String details) {
        if (message == null) {
            return;
        }
        if (!(level != 0 && level != 1 && level != 2 && level != 3 || Debug.isDebugging())) {
            return;
        }
        int severity = 0;
        switch (level) {
            case 1: 
            case 5: {
                severity = 1;
                break;
            }
            case 2: 
            case 6: {
                severity = 2;
                break;
            }
            case 3: 
            case 7: {
                severity = 4;
            }
        }
        MultiStatus multiStatus = new MultiStatus(PLUGIN_ID, severity, reason, null);
        if (details != null) {
            Status StatusObj = new Status(severity, PLUGIN_ID, severity, details, null);
            multiStatus.add((IStatus)StatusObj);
        }
        ErrorDialog.openError(null, (String)PLUGIN_ID, (String)message, (IStatus)multiStatus);
    }
}

