/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.facesconfig.util;

import com.ibm.etools.jsf.facesconfig.FacesConfigPlugin;
import com.ibm.etools.jsf.facesconfig.internal.Logger;
import com.ibm.etools.jsf.facesconfig.util.FacesConfigChangeEvent;
import com.ibm.etools.jsf.facesconfig.util.IFacesConfigChangeEvent;
import com.ibm.etools.jsf.facesconfig.util.IFacesConfigChangeListener;
import com.ibm.etools.jsf.facesconfig.util.JSFFacesConfigUtil;
import com.ibm.etools.webtools.server.ServerRestartUtil;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class FacesResourceChangeListener
implements IResourceChangeListener,
IResourceDeltaVisitor,
ISaveParticipant,
IResourceVisitor {
    private static FacesResourceChangeListener listener;
    private static boolean restartInProgress;
    private LinkedList facesConfigChangeListeners = new LinkedList();
    private static IPreferenceStore preferenceStore;
    public static final QualifiedName EDITOR_KEY;

    static {
        restartInProgress = false;
        preferenceStore = null;
        EDITOR_KEY = new QualifiedName("org.eclipse.ui.internal.registry.ResourceEditorRegistry", "EditorProperty");
    }

    public static void startup() {
        if (listener != null) {
            return;
        }
        listener = new FacesResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 24);
    }

    public static void shutdown() {
        if (listener == null) {
            return;
        }
        ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)FacesConfigPlugin.getPlugin());
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        listener = null;
    }

    private FacesResourceChangeListener() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException ignored) {
                Logger.log((Object)this, ignored);
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        if (resource.getType() == 8) {
            return true;
        }
        if (resource.getType() == 4 && !JSFFacesConfigUtil.isFacesProject((IProject)resource)) {
            return false;
        }
        this.checkForWebXmlChange(delta);
        this.checkForFacesConfigFile(delta);
        return true;
    }

    private void checkForWebXmlChange(IResourceDelta delta) {
        IResource resource;
        if (delta.getKind() == 4 && (resource = delta.getResource()) != null && "web.xml".equals(resource.getName())) {
            JSFFacesConfigUtil.projectToFacesConfigsMap.remove(resource.getProject());
        }
    }

    private void checkForFacesConfigFile(IResourceDelta delta) {
        IFile file;
        IResource resource;
        boolean isRemoved;
        boolean isAdded = delta.getKind() == 1;
        boolean bl = isRemoved = delta.getKind() == 2;
        if ((isAdded || isRemoved || delta.getKind() == 4 && (delta.getFlags() & 0x58100) != 0) && (resource = delta.getResource()).getType() == 1 && JSFFacesConfigUtil.isFacesConfigFile(file = (IFile)resource)) {
            FacesConfigChangeEvent facesConfigChangeEvent = new FacesConfigChangeEvent();
            this.fireFacesConfigChangeEvent(facesConfigChangeEvent);
            IVirtualComponent component = ComponentUtilities.findComponent((IResource)file);
            if (component != null) {
                this.restartServerIfNecessary(component);
            }
        }
    }

    private void checkForFacesConfigFile(IResource resource, boolean ignoreNonFacesProjects) {
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        context.needDelta();
    }

    public boolean visit(IResource resource) {
        this.checkForFacesConfigFile(resource, true);
        return true;
    }

    private void restartServerIfNecessary(IVirtualComponent component) {
        if (!restartInProgress) {
            boolean restart = false;
            if (preferenceStore != null) {
                restart = preferenceStore.getBoolean("jsf.project.restart");
            }
            if (restart) {
                restartInProgress = true;
                ServerRestartUtil.restartComponent((IVirtualComponent)component, (boolean)true);
                restartInProgress = false;
            }
        }
    }

    public static FacesResourceChangeListener getFacesResourceChangeListener() {
        if (listener == null) {
            listener = new FacesResourceChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 8);
        }
        return listener;
    }

    public void addFacesConfigChangeListener(IFacesConfigChangeListener facesConfigChangeListener) {
        this.facesConfigChangeListeners.add(facesConfigChangeListener);
    }

    public void removeFacesConfigChangeListener(IFacesConfigChangeListener facesConfigChangeListener) {
        this.facesConfigChangeListeners.remove(facesConfigChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFacesConfigChangeEvent(IFacesConfigChangeEvent event) {
        LinkedList localCopy;
        FacesResourceChangeListener facesResourceChangeListener = this;
        synchronized (facesResourceChangeListener) {
            localCopy = (LinkedList)this.facesConfigChangeListeners.clone();
        }
        ListIterator iter = localCopy.listIterator();
        while (iter.hasNext()) {
            IFacesConfigChangeListener facesConfigChangeListener = (IFacesConfigChangeListener)iter.next();
            facesConfigChangeListener.resourceChanged(event);
        }
    }

    public static void setPreferenceStore(IPreferenceStore preferenceStore) {
        FacesResourceChangeListener.preferenceStore = preferenceStore;
    }
}

