/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.facesconfig.scheme.schemes;

import com.ibm.etools.jsf.facesconfig.internal.nls.Messages;
import com.ibm.etools.jsf.facesconfig.scheme.FacesConfigScheme;
import com.ibm.etools.jsf.facesconfig.scheme.FacesConfigSchemeFilter;
import com.ibm.etools.jsf.facesconfig.scheme.schemes.DefaultSchemeFilter;
import com.ibm.etools.jsf.facesconfig.scheme.schemes.HierarchyFilesSchemeFilter;
import com.ibm.etools.jsf.facesconfig.util.JSFFacesConfigUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class FolderHierarchyScheme
implements FacesConfigScheme {
    protected String[] configFiles;
    protected String rootFolderPath = null;
    protected IProject project;
    private FacesConfigSchemeFilter[] filters = new FacesConfigSchemeFilter[]{new HierarchyFilesSchemeFilter(this, "hierarchyFiles", Messages.FolderHierarchyScheme_1), new DefaultSchemeFilter(this, this.getID(), Messages.SingleFileScheme_0)};

    @Override
    public String getID() {
        return "folderHierarchy";
    }

    @Override
    public FacesConfigSchemeFilter[] getConfigFileFilters() {
        return this.filters;
    }

    @Override
    public String getFacesConfigPath(String artifactID, IResource resource, int properties) {
        this.project = resource.getProject();
        this.configFiles = JSFFacesConfigUtil.getFacesConfigPaths(resource.getProject());
        this.rootFolderPath = this.getRootFolderPath();
        String configPath = this.traverseFolderHierarchy(resource);
        if (configPath == null) {
            return "/WEB-INF/faces-config.xml";
        }
        return configPath;
    }

    public String[] getAllFacesConfigPathsInHierarchy(String artifactID, IResource resource, int properties) {
        this.project = resource.getProject();
        this.configFiles = JSFFacesConfigUtil.getFacesConfigPaths(resource.getProject());
        this.rootFolderPath = this.getRootFolderPath();
        ArrayList folderConfigFiles = new ArrayList();
        this.traverseFolderHierarchyForAllFiles(resource, folderConfigFiles);
        if (folderConfigFiles.isEmpty()) {
            return new String[]{"/WEB-INF/faces-config.xml"};
        }
        return folderConfigFiles.toArray(new String[0]);
    }

    protected String getRootFolderPath() {
        IVirtualFolder contentFolder;
        IResource rootResource;
        String rootPath = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.project);
        if (component != null && (rootResource = (contentFolder = component.getRootFolder()).getUnderlyingResource()) != null) {
            rootPath = rootResource.getFullPath().toString();
        }
        if (rootPath == null) {
            rootPath = this.project.getName();
        }
        return rootPath;
    }

    protected String traverseFolderHierarchy(IResource resource) {
        switch (resource.getType()) {
            case 8: {
                return null;
            }
            case 2: {
                return this.searchFolder(resource);
            }
            case 4: {
                String configFile = this.getConfigFileMatchingFolderPath(this.rootFolderPath);
                if (configFile != null) {
                    return configFile;
                }
                return this.traverseFolderHierarchy((IResource)resource.getParent());
            }
            case 1: {
                return this.searchFolder((IResource)resource.getParent());
            }
        }
        return null;
    }

    protected String searchFolder(IResource folder) {
        String path = folder.getFullPath().toString();
        String configFile = this.getConfigFileMatchingFolderPath(path);
        if (configFile != null) {
            return configFile;
        }
        return this.traverseFolderHierarchy((IResource)folder.getParent());
    }

    protected String getConfigFileMatchingFolderPath(String folderPath) {
        int i = 0;
        while (i < this.configFiles.length) {
            int lastIndex;
            String configFileFolder;
            String fullConfigFilePath = String.valueOf(this.rootFolderPath) + this.configFiles[i];
            if (fullConfigFilePath.startsWith(folderPath) && (configFileFolder = fullConfigFilePath.substring(0, lastIndex = fullConfigFilePath.lastIndexOf("/"))).equals(folderPath)) {
                return this.configFiles[i];
            }
            ++i;
        }
        return null;
    }

    protected String traverseFolderHierarchyForAllFiles(IResource resource, List folderConfigFiles) {
        switch (resource.getType()) {
            case 8: {
                return null;
            }
            case 2: {
                return this.searchFolderForAllFiles(resource, folderConfigFiles);
            }
            case 4: {
                String configFile = this.getConfigFileMatchingFolderPath(this.rootFolderPath);
                if (configFile != null && !folderConfigFiles.contains(configFile)) {
                    folderConfigFiles.add(configFile);
                }
                return this.traverseFolderHierarchyForAllFiles((IResource)resource.getParent(), folderConfigFiles);
            }
            case 1: {
                return this.searchFolderForAllFiles((IResource)resource.getParent(), folderConfigFiles);
            }
        }
        return null;
    }

    protected String searchFolderForAllFiles(IResource folder, List folderConfigFiles) {
        String path = folder.getFullPath().toString();
        String configFile = this.getConfigFileMatchingFolderPath(path);
        if (configFile != null && !folderConfigFiles.contains(configFile)) {
            folderConfigFiles.add(configFile);
        }
        return this.traverseFolderHierarchyForAllFiles((IResource)folder.getParent(), folderConfigFiles);
    }
}

