/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.facesconfig.scheme;

import com.ibm.etools.jsf.facesconfig.scheme.FacesConfigScheme;
import com.ibm.etools.jsf.facesconfig.scheme.internal.ContributedScheme;
import com.ibm.etools.jsf.facesconfig.scheme.internal.SchemePropertyPage;
import com.ibm.etools.jsf.facesconfig.scheme.internal.SchemeRegistryReader;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class FacesConfigSchemeManager {
    private Map schemes;
    private List artifacts;
    private static FacesConfigSchemeManager instance;

    public static FacesConfigSchemeManager getInstance() {
        if (instance == null) {
            instance = new FacesConfigSchemeManager();
        }
        return instance;
    }

    public FacesConfigScheme getScheme(String artifactID, IProject project) {
        ContributedScheme contributedScheme;
        FacesConfigScheme scheme = null;
        String schemeID = this.getProjectSchemeForArtifact(artifactID, project);
        if (schemeID != null && (contributedScheme = (ContributedScheme)this.schemes.get(schemeID)) != null) {
            try {
                scheme = contributedScheme.getScheme();
            }
            catch (CoreException coreException) {}
        }
        return scheme;
    }

    private FacesConfigSchemeManager() {
        this.loadDefinedSchemes();
    }

    private void loadDefinedSchemes() {
        this.artifacts = SchemeRegistryReader.parseArtifactContributions();
        this.schemes = SchemeRegistryReader.parseSchemeContributions();
    }

    public String getFacesConfigFilePathFromPreferences(String artifactID, IProject project) {
        IVirtualComponent component;
        String facesConfigFilePath = null;
        if (project != null && (facesConfigFilePath = (String)(component = ComponentCore.createComponent((IProject)project)).getMetaProperties().get("jsf.standard.scheme." + artifactID + ".filePath")) == null) {
            this.initializeDefaults(component);
            facesConfigFilePath = (String)component.getMetaProperties().get("jsf.standard.scheme." + artifactID + ".filePath");
            if (facesConfigFilePath == null) {
                facesConfigFilePath = "/WEB-INF/faces-config.xml";
                component.setMetaProperty("jsf.standard.scheme." + artifactID + ".filePath", facesConfigFilePath);
            }
        }
        return facesConfigFilePath;
    }

    private void initializeDefaults(IVirtualComponent component) {
        SchemePropertyPage.initializeDefaultPrefs(component, this.artifacts);
    }

    private String getProjectSchemeForArtifact(String artifactID, IProject project) {
        IVirtualComponent component;
        String schemeID = null;
        if (project != null && ((schemeID = (String)(component = ComponentCore.createComponent((IProject)project)).getMetaProperties().get("jsf.standard.scheme." + artifactID)) == null || schemeID.length() == 0)) {
            this.initializeDefaults(component);
            schemeID = (String)component.getMetaProperties().get("jsf.standard.scheme." + artifactID);
            if (schemeID == null) {
                schemeID = "singleFile";
                component.setMetaProperty("jsf.standard.scheme." + artifactID, schemeID);
            }
        }
        return schemeID;
    }
}

