/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.debug.internal.views.tree;

import com.ibm.etools.jsf.debug.internal.nls.Messages;
import com.ibm.etools.jsf.debug.internal.views.JSFDebugView;
import com.ibm.etools.jsf.debug.internal.views.tree.ComponentTreeObject;
import com.ibm.etools.jsf.debug.internal.views.tree.TreeObject;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public class TreeAccessibleListener
extends AccessibleAdapter {
    public static final String SPACE = " ";
    JSFDebugView view;

    public TreeAccessibleListener(JSFDebugView view) {
        this.view = view;
    }

    public void getName(AccessibleEvent e) {
        if (e.childID == -1) {
            return;
        }
        TreeItem item = (TreeItem)Display.getCurrent().findWidget(this.view.getViewer().getTree().handle, e.childID);
        if (item == null) {
            return;
        }
        TreeObject treeObject = (TreeObject)item.getData();
        if (treeObject == null) {
            return;
        }
        StringBuilder accText = new StringBuilder();
        accText.append(treeObject.getName());
        if (treeObject.getState() == TreeObject.TreeObjectState.NEW) {
            accText.append(SPACE).append(Messages.TreeAccessibleListener_0);
        } else if (treeObject.getState() == TreeObject.TreeObjectState.CHANGED) {
            accText.append(SPACE).append(Messages.TreeAccessibleListener_1);
        }
        if (treeObject instanceof ComponentTreeObject) {
            ComponentTreeObject componentTreeObject = (ComponentTreeObject)treeObject;
            if (componentTreeObject.isInvalid()) {
                accText.append(SPACE).append(Messages.TreeAccessibleListener_2);
            }
            if (componentTreeObject.isNotRendered()) {
                accText.append(SPACE).append(Messages.TreeAccessibleListener_3);
            }
        }
        e.result = accText.toString();
    }
}

