/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.debug.internal.views;

import com.ibm.etools.jsf.debug.JSFDebugPlugin;
import com.ibm.etools.jsf.debug.internal.actions.BreakpointAction;
import com.ibm.etools.jsf.debug.internal.util.OverlayImage;
import com.ibm.etools.jsf.debug.internal.util.PrefUtil;
import com.ibm.etools.jsf.debug.internal.views.JSFDebugView;
import com.ibm.etools.jsf.debug.internal.views.tree.PhaseStageTreeObject;
import com.ibm.etools.jsf.debug.internal.views.tree.TreeObject;
import com.ibm.etools.jsf.debug.internal.views.tree.TreeParent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

class ViewLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider,
ILabelDecorator {
    private JSFDebugView view;

    public ViewLabelProvider(JSFDebugView view) {
        this.view = view;
    }

    public String getText(Object obj) {
        return obj.toString();
    }

    public Image getImage(Object obj) {
        TreeObject treeObject = (TreeObject)obj;
        if (treeObject.getImage() != null) {
            return JSFDebugPlugin.getDefault().getImage(treeObject.getImage());
        }
        if (obj instanceof TreeParent) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
    }

    public Color getBackground(Object element) {
        if (!this.view.isHighlightNewChanged()) {
            return null;
        }
        TreeObject treeObject = (TreeObject)element;
        String name = treeObject.getName();
        if (!this.view.isHighlightSystem() && PrefUtil.isSystemObject(name)) {
            return null;
        }
        switch (treeObject.getState()) {
            case NEW: {
                return this.view.getColorNew();
            }
            case CHANGED: {
                return this.view.getColorChanged();
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Font getFont(Object element) {
        TreeObject treeObject = (TreeObject)element;
        if (treeObject.getFont() != null) {
            if (treeObject.getFont().equals("italic")) {
                Font font = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
                return font;
            }
            if (treeObject.getFont().equals("bold")) {
                Font font = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
                return font;
            }
        }
        if (!this.view.isHighlightNewChanged()) {
            return null;
        }
        String name = treeObject.getName();
        if (!this.view.isHighlightSystem() && PrefUtil.isSystemObject(name)) {
            return null;
        }
        if (treeObject.getState() != TreeObject.TreeObjectState.NORMAL) {
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }
        return null;
    }

    public Image decorateImage(Image image, Object element) {
        TreeObject treeObject = (TreeObject)element;
        String overlay = null;
        if (treeObject.getOverlay() != null) {
            overlay = treeObject.getOverlay();
        } else if (treeObject instanceof PhaseStageTreeObject) {
            BreakpointAction action = new BreakpointAction(this.view.getViewer());
            action.setObject(treeObject);
            action.update();
            if (action.getExistingBreakpoint() != null) {
                overlay = "breakpoint_overlay";
            }
        }
        if (overlay != null) {
            String imageCode = String.valueOf(image.hashCode()) + "-" + overlay;
            Image decoratedImage = JSFDebugPlugin.getDefault().getImageRegistry().get(imageCode);
            if (decoratedImage == null) {
                ImageDescriptor decoratorImageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.etools.jsf.debug", (String)("icons/" + overlay + ".gif"));
                OverlayImage overlayImage = new OverlayImage(image, decoratorImageDescriptor, 3);
                decoratedImage = overlayImage.createImage();
                JSFDebugPlugin.getDefault().getImageRegistry().put(imageCode, decoratedImage);
            }
            return decoratedImage;
        }
        return null;
    }

    public String decorateText(String text, Object element) {
        return null;
    }
}

