/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.debug.internal.views;

import com.ibm.etools.jsf.debug.IConstants;
import com.ibm.etools.jsf.debug.JSFDebugPlugin;
import com.ibm.etools.jsf.debug.internal.actions.BreakpointAction;
import com.ibm.etools.jsf.debug.internal.actions.ClearViewAction;
import com.ibm.etools.jsf.debug.internal.actions.CollapseAllAction;
import com.ibm.etools.jsf.debug.internal.actions.CustomizeAction;
import com.ibm.etools.jsf.debug.internal.actions.ExpandAllAction;
import com.ibm.etools.jsf.debug.internal.actions.ExpandChangedAction;
import com.ibm.etools.jsf.debug.internal.actions.FilterAction;
import com.ibm.etools.jsf.debug.internal.actions.RemoveAllBreakpointsAction;
import com.ibm.etools.jsf.debug.internal.actions.WatchExpressionAction;
import com.ibm.etools.jsf.debug.internal.nls.Messages;
import com.ibm.etools.jsf.debug.internal.util.DOMUtil;
import com.ibm.etools.jsf.debug.internal.util.PrefUtil;
import com.ibm.etools.jsf.debug.internal.views.AutoOpenArea;
import com.ibm.etools.jsf.debug.internal.views.DebugViewFilter;
import com.ibm.etools.jsf.debug.internal.views.InfoArea;
import com.ibm.etools.jsf.debug.internal.views.ViewContentProvider;
import com.ibm.etools.jsf.debug.internal.views.ViewLabelProvider;
import com.ibm.etools.jsf.debug.internal.views.tree.ComponentTreeObject;
import com.ibm.etools.jsf.debug.internal.views.tree.MessagesTreeObject;
import com.ibm.etools.jsf.debug.internal.views.tree.PhaseStageTreeObject;
import com.ibm.etools.jsf.debug.internal.views.tree.PhaseTreeObject;
import com.ibm.etools.jsf.debug.internal.views.tree.ScopeTreeObject;
import com.ibm.etools.jsf.debug.internal.views.tree.TreeAccessibleListener;
import com.ibm.etools.jsf.debug.internal.views.tree.TreeObject;
import com.ibm.etools.jsf.debug.internal.views.tree.TreeParent;
import com.ibm.etools.jsf.debug.internal.views.tree.ViewAttributesTreeObject;
import com.ibm.etools.jsf.debug.internal.views.tree.ViewTreeObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JSFDebugView
extends ViewPart
implements IPropertyChangeListener,
IPartListener2 {
    private ServerSocket serverSocket = null;
    private Socket clientSocket = null;
    private Thread serverSocketThread = null;
    private Thread clientSocketThread = null;
    private int portNumber = 4444;
    private boolean bVisible;
    private MessageConsole console;
    private ScrolledComposite scrolledComposite;
    private Composite newParent;
    private TreeViewer viewer;
    private TreeParent currentPhaseParent;
    private MessageConsoleStream consoleOutput;
    private DebugViewFilter viewerFilter;
    private ViewContentProvider contentProvider = null;
    private ViewLabelProvider labelProvider = null;
    private Action actionClear;
    private Action actionExpandChanged;
    private Action actionExpandAll;
    private Action actionCollapseAll;
    private Action actionFilter;
    private Action actionCustomize;
    private BreakpointAction actionBreakpoint;
    private WatchExpressionAction watchExpressionAction;
    private RemoveAllBreakpointsAction actionRemoveAllBreakpoints;
    private ArrayList<BreakpointAction> actionBreakpoints = new ArrayList(12);
    private ArrayList<WatchExpressionAction> actionWatches = new ArrayList(4);
    private Color colorNew = null;
    private Color colorChanged = null;
    private boolean highlightSystem = false;
    private boolean highlightNewChanged = true;
    private boolean autoExpand = true;
    private boolean showOnNewMessage = true;
    private boolean bRenderResponsePhaseProcessed = false;
    private AutoOpenArea autoOpenArea;
    private InfoArea infoArea;

    public JSFDebugView() {
        JSFDebugPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.portNumber = JSFDebugPlugin.getDefault().getPreferenceStore().getInt("port");
        RGB rgbNew = PreferenceConverter.getColor((IPreferenceStore)JSFDebugPlugin.getDefault().getPreferenceStore(), (String)"colorNew");
        if (this.colorNew != null) {
            this.colorNew.dispose();
        }
        this.colorNew = new Color((Device)Display.getCurrent(), rgbNew);
        RGB rgbChanged = PreferenceConverter.getColor((IPreferenceStore)JSFDebugPlugin.getDefault().getPreferenceStore(), (String)"colorChanged");
        if (this.colorChanged != null) {
            this.colorChanged.dispose();
        }
        this.colorChanged = new Color((Device)Display.getCurrent(), rgbChanged);
        this.highlightNewChanged = JSFDebugPlugin.getDefault().getPreferenceStore().getBoolean("highlightNewChanged");
        this.highlightSystem = JSFDebugPlugin.getDefault().getPreferenceStore().getBoolean("highlightSystem");
        this.autoExpand = JSFDebugPlugin.getDefault().getPreferenceStore().getBoolean("autoExpends");
        this.showOnNewMessage = JSFDebugPlugin.getDefault().getPreferenceStore().getBoolean("openNewMessage");
        this.console = new MessageConsole(Messages.JSFDebugView_4, null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        this.consoleOutput = this.console.newMessageStream();
        this.startCommunication();
    }

    public void dispose() {
        this.stopCommunication();
        try {
            this.consoleOutput.close();
        }
        catch (IOException iOException) {}
        ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this.console});
        if (this.colorNew != null) {
            this.colorNew.dispose();
            this.colorNew = null;
        }
        if (this.colorChanged != null) {
            this.colorChanged.dispose();
            this.colorChanged = null;
        }
        this.contentProvider.dispose();
        this.labelProvider.dispose();
        JSFDebugPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.scrolledComposite = new ScrolledComposite(parent, 512);
        this.newParent = new Composite((Composite)this.scrolledComposite, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.newParent.setLayout((Layout)layout);
        this.scrolledComposite.setLayout((Layout)layout);
        this.newParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.newParent.setBackground(Display.getCurrent().getSystemColor(25));
        this.scrolledComposite.setBackground(Display.getCurrent().getSystemColor(5));
        this.newParent.setBackgroundMode(2);
        this.infoArea = new InfoArea(this.newParent, this);
        this.autoOpenArea = new AutoOpenArea(this.newParent, this);
        this.autoOpenArea.setVisible(false);
        this.viewer = new TreeViewer(this.newParent, 768);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.contentProvider = new ViewContentProvider(this);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new ViewLabelProvider(this);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)this.labelProvider, (ILabelDecorator)this.labelProvider));
        this.viewer.setInput((Object)this.getViewSite());
        this.viewerFilter = new DebugViewFilter();
        this.viewer.addFilter((ViewerFilter)this.viewerFilter);
        this.viewer.getTree().getAccessible().addAccessibleListener((AccessibleListener)new TreeAccessibleListener(this));
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.scrolledComposite.setContent((Control)this.newParent);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setMinSize(this.newParent.computeSize(-1, -1));
        parent.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                JSFDebugView.this.infoArea.resize();
                JSFDebugView.this.autoOpenArea.resize();
                JSFDebugView.this.scrolledComposite.setMinSize(JSFDebugView.this.newParent.computeSize(-1, -1));
            }
        });
        this.getViewSite().getPage().addPartListener((IPartListener2)this);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionFilter);
        manager.add((IAction)this.actionCustomize);
        MenuManager subBreakpointMenu = new MenuManager(Messages.JSFDebugView_5, null);
        manager.add((IContributionItem)subBreakpointMenu);
        for (BreakpointAction action : this.actionBreakpoints) {
            subBreakpointMenu.add((IAction)action);
        }
        subBreakpointMenu.add((IContributionItem)new Separator());
        subBreakpointMenu.add((IAction)this.actionRemoveAllBreakpoints);
        subBreakpointMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Iterator iterator = JSFDebugView.this.actionBreakpoints.iterator();
                while (iterator.hasNext()) {
                    BreakpointAction action;
                    action.setChecked((action = (BreakpointAction)((Object)iterator.next())).getExistingBreakpoint() != null);
                }
            }
        });
        MenuManager subWatchesMenu = new MenuManager(Messages.JSFDebugView_0, null);
        manager.add((IContributionItem)subWatchesMenu);
        for (WatchExpressionAction action : this.actionWatches) {
            subWatchesMenu.add((IAction)action);
        }
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionExpandChanged);
        manager.add((IAction)this.actionExpandAll);
        manager.add((IAction)this.actionCollapseAll);
    }

    private void fillContextMenu(IMenuManager manager, Object selectedObject) {
        TreeParent parent;
        if (selectedObject == null) {
            return;
        }
        TreeObject treeObject = (TreeObject)selectedObject;
        this.actionBreakpoint.setObject(treeObject);
        this.actionBreakpoint.update();
        if (this.actionBreakpoint.getText() != null) {
            manager.add((IAction)this.actionBreakpoint);
        }
        if ((parent = treeObject.getParent()) instanceof ScopeTreeObject) {
            manager.add((IAction)this.watchExpressionAction);
            this.watchExpressionAction.setObject(treeObject);
        } else if (parent instanceof ViewAttributesTreeObject) {
            manager.add((IAction)this.watchExpressionAction);
            this.watchExpressionAction.setObject(treeObject);
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ISelection selection = JSFDebugView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                JSFDebugView.this.fillContextMenu(manager, obj);
                manager.add((IContributionItem)new GroupMarker("additions"));
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void makeActions() {
        this.actionClear = new ClearViewAction(this);
        this.actionExpandChanged = new ExpandChangedAction(this);
        this.actionExpandAll = new ExpandAllAction(this);
        this.actionCollapseAll = new CollapseAllAction(this);
        this.actionFilter = new FilterAction(this);
        this.actionCustomize = new CustomizeAction();
        this.watchExpressionAction = new WatchExpressionAction();
        this.actionBreakpoint = new BreakpointAction(this.viewer);
        this.actionRemoveAllBreakpoints = new RemoveAllBreakpointsAction(this.viewer);
        String[] stringArray = IConstants.PHASES;
        int n = IConstants.PHASES.length;
        int n2 = 0;
        while (n2 < n) {
            String phase = stringArray[n2];
            BreakpointAction beforeAction = new BreakpointAction(this.viewer);
            beforeAction.setText(Messages.bind((String)Messages.JSFDebugView_8, (Object)phase));
            beforeAction.setMethodName("before" + phase + "Phase");
            this.actionBreakpoints.add(beforeAction);
            BreakpointAction afterAction = new BreakpointAction(this.viewer);
            afterAction.setText(Messages.bind((String)Messages.JSFDebugView_11, (Object)phase));
            afterAction.setMethodName("after" + phase + "Phase");
            this.actionBreakpoints.add(afterAction);
            ++n2;
        }
        WatchExpressionAction watchRequestObjectAction = new WatchExpressionAction();
        watchRequestObjectAction.setType(WatchExpressionAction.Type.REQUEST);
        this.actionWatches.add(watchRequestObjectAction);
        WatchExpressionAction watchSessionObjectAction = new WatchExpressionAction();
        watchSessionObjectAction.setType(WatchExpressionAction.Type.SESSION);
        this.actionWatches.add(watchSessionObjectAction);
        WatchExpressionAction watchApplicationObjectAction = new WatchExpressionAction();
        watchApplicationObjectAction.setType(WatchExpressionAction.Type.APPLICATION);
        this.actionWatches.add(watchApplicationObjectAction);
        WatchExpressionAction watchViewAttributeAction = new WatchExpressionAction();
        watchViewAttributeAction.setType(WatchExpressionAction.Type.VIEWATTRIBUTE);
        this.actionWatches.add(watchViewAttributeAction);
    }

    public void setFocus() {
        if (this.infoArea.isVisible()) {
            this.infoArea.setFocus();
        } else if (this.autoOpenArea.isVisible()) {
            this.autoOpenArea.setFocus();
        } else {
            this.viewer.getControl().setFocus();
        }
    }

    private void processMessage(String msg) {
        if (msg == null || msg.length() == 0) {
            return;
        }
        Node doc = null;
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(msg.getBytes("UTF-8"));
            doc = docBuilder.parse(stream);
        }
        catch (Exception e) {
            JSFDebugPlugin.log(e);
            doc = null;
        }
        if (doc == null) {
            return;
        }
        TreeParent createdTreeParent = null;
        Node rootNode = doc.getFirstChild();
        if (rootNode.getNodeName().equals("request")) {
            if (this.bRenderResponsePhaseProcessed) {
                this.contentProvider.clearContent();
                this.bRenderResponsePhaseProcessed = false;
            }
            this.addRequestNode((Document)doc);
        } else if (rootNode.getNodeName().equals("phase")) {
            createdTreeParent = this.addPhaseNode((Document)doc);
        } else if (rootNode.getNodeName().equals("messages")) {
            createdTreeParent = this.addMessagesNode((Document)doc);
        } else if (rootNode.getNodeName().equals("navigation")) {
            this.addNavigationNode((Document)doc);
        }
        final TreeParent treeParent = createdTreeParent;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                JSFDebugView.this.viewer.getControl().setRedraw(false);
                JSFDebugView.this.viewer.refresh();
                if (JSFDebugView.this.autoExpand && treeParent != null) {
                    JSFDebugView.this.expandNode(treeParent);
                }
                JSFDebugView.this.viewer.getControl().setRedraw(true);
                if (JSFDebugView.this.showOnNewMessage) {
                    JSFDebugView.this.getSite().getPage().activate(JSFDebugView.this.getSite().getPart());
                }
            }
        });
    }

    private TreeParent addRequestNode(Document doc) {
        Node requestNode = doc.getFirstChild();
        String object = DOMUtil.getNodeTextContent(DOMUtil.getChildNamed(requestNode, "object"));
        TreeParent requestTreeObject = new TreeParent(String.valueOf(Messages.JSFDebugView_19) + object);
        requestTreeObject.setImage("incoming");
        this.contentProvider.getRoot().addChild(requestTreeObject);
        String pathInfo = DOMUtil.getNodeTextContent(DOMUtil.getChildNamed(requestNode, "path-info"));
        TreeObject pathInfoTreeObject = new TreeObject(String.valueOf(Messages.JSFDebugView_22) + pathInfo);
        pathInfoTreeObject.setImage("path");
        requestTreeObject.addChild(pathInfoTreeObject);
        String servletPath = DOMUtil.getNodeTextContent(DOMUtil.getChildNamed(requestNode, "servlet-path"));
        TreeObject servletPathTreeObject = new TreeObject(String.valueOf(Messages.JSFDebugView_25) + servletPath);
        servletPathTreeObject.setImage("path");
        requestTreeObject.addChild(servletPathTreeObject);
        String contextPath = DOMUtil.getNodeTextContent(DOMUtil.getChildNamed(requestNode, "context-path"));
        TreeObject contextPathTreeObject = new TreeObject(String.valueOf(Messages.JSFDebugView_28) + contextPath);
        contextPathTreeObject.setImage("path");
        requestTreeObject.addChild(contextPathTreeObject);
        TreeParent parametersTreeObject = new TreeParent(Messages.JSFDebugView_30);
        parametersTreeObject.setImage("param");
        requestTreeObject.addChild(parametersTreeObject);
        this.addMapNode(parametersTreeObject, DOMUtil.getChildNamed(requestNode, "parameters"));
        TreeParent headersTreeObject = new TreeParent(Messages.JSFDebugView_33);
        headersTreeObject.setImage("header");
        requestTreeObject.addChild(headersTreeObject);
        this.addMapNode(headersTreeObject, DOMUtil.getChildNamed(requestNode, "headers"));
        TreeParent cookiesTreeObject = new TreeParent(Messages.JSFDebugView_36);
        cookiesTreeObject.setImage("cookies");
        requestTreeObject.addChild(cookiesTreeObject);
        this.addMapNode(cookiesTreeObject, DOMUtil.getChildNamed(requestNode, "cookies"));
        return requestTreeObject;
    }

    private TreeParent addPhaseNode(Document doc) {
        Node applicationScopeNode;
        Node sessionScopeNode;
        Node phaseNode = doc.getFirstChild();
        String phaseId = DOMUtil.getNodeTextContent(DOMUtil.getChildNamed(phaseNode, "id"));
        if (phaseId.startsWith("RENDER_RESPONSE")) {
            this.bRenderResponsePhaseProcessed = true;
        }
        Node beforeNode = DOMUtil.getChildNamed(phaseNode, "before");
        Node afterNode = DOMUtil.getChildNamed(phaseNode, "after");
        PhaseStageTreeObject currentPhaseStageParent = null;
        Node phaseStageNode = null;
        if (beforeNode != null) {
            this.currentPhaseParent = new PhaseTreeObject(phaseId);
            this.contentProvider.getRoot().addChild(this.currentPhaseParent);
            currentPhaseStageParent = new PhaseStageTreeObject(PhaseStageTreeObject.PhaseStage.BEFORE);
            this.currentPhaseParent.addChild(currentPhaseStageParent);
            phaseStageNode = beforeNode;
        } else if (afterNode != null) {
            currentPhaseStageParent = new PhaseStageTreeObject(PhaseStageTreeObject.PhaseStage.AFTER);
            this.currentPhaseParent.addChild(currentPhaseStageParent);
            phaseStageNode = afterNode;
            String duration = DOMUtil.getNodeTextContent(DOMUtil.getChildNamed(phaseNode, "duration"));
            if (duration != null) {
                Long milliSeconds = Long.valueOf(duration);
                this.currentPhaseParent.setName(String.valueOf(this.currentPhaseParent.getName()) + " " + Messages.bind((String)Messages.JSFDebugView_45, (Object)milliSeconds));
            }
        }
        this.addViewNode(currentPhaseStageParent, DOMUtil.getChildNamed(phaseStageNode, "view"));
        Node requestScopeNode = DOMUtil.getChildNamed(phaseStageNode, "requestScope");
        if (requestScopeNode != null) {
            ScopeTreeObject requestScopeTreeObject = new ScopeTreeObject(ScopeTreeObject.Scope.REQUEST);
            currentPhaseStageParent.addChild(requestScopeTreeObject);
            this.addMapNode(requestScopeTreeObject, requestScopeNode);
            this.contentProvider.getTreeValues().put(Messages.ScopeTreeObject_0, "1");
        }
        if ((sessionScopeNode = DOMUtil.getChildNamed(phaseStageNode, "sessionScope")) != null) {
            ScopeTreeObject sessionScopeTreeObject = new ScopeTreeObject(ScopeTreeObject.Scope.SESSION);
            currentPhaseStageParent.addChild(sessionScopeTreeObject);
            this.addMapNode(sessionScopeTreeObject, sessionScopeNode);
            this.contentProvider.getTreeValues().put(Messages.ScopeTreeObject_2, "1");
        }
        if ((applicationScopeNode = DOMUtil.getChildNamed(phaseStageNode, "applicationScope")) != null) {
            ScopeTreeObject applicationScopeTreeObject = new ScopeTreeObject(ScopeTreeObject.Scope.APPLICATION);
            currentPhaseStageParent.addChild(applicationScopeTreeObject);
            this.addMapNode(applicationScopeTreeObject, applicationScopeNode);
            this.contentProvider.getTreeValues().put(Messages.ScopeTreeObject_4, "1");
        }
        return currentPhaseStageParent;
    }

    private void addViewNode(TreeParent parent, Node viewNode) {
        String viewId = DOMUtil.getNodeTextContent(DOMUtil.getChildNamed(viewNode, "id"));
        ViewTreeObject viewParent = new ViewTreeObject(viewId);
        parent.addChild(viewParent);
        Node viewAttributesNode = DOMUtil.getChildNamed(viewNode, "attributes");
        if (viewAttributesNode != null) {
            ViewAttributesTreeObject attributesTreeObject = new ViewAttributesTreeObject();
            viewParent.addChild(attributesTreeObject);
            this.addMapNode(attributesTreeObject, viewAttributesNode);
            this.contentProvider.getTreeValues().put(Messages.ViewAttributesTreeObject_0, "1");
        }
        List<Node> components = DOMUtil.getChildrenNamed(viewNode, "component");
        for (Node component : components) {
            this.addComponentNode(viewParent, component);
        }
    }

    private void addComponentNode(TreeParent parent, Node componentNode) {
        TreeObject newObject;
        Node classNode = DOMUtil.getChildNamed(componentNode, "class");
        String componentClass = DOMUtil.getNodeTextContent(classNode);
        Node idNode = DOMUtil.getChildNamed(componentNode, "id");
        String componentId = DOMUtil.getNodeTextContent(idNode);
        Node valueNode = DOMUtil.getChildNamed(componentNode, "value");
        String value = DOMUtil.getNodeTextContent(valueNode);
        Node submittedNode = DOMUtil.getChildNamed(componentNode, "submitted-value");
        String submittedValue = DOMUtil.getNodeTextContent(submittedNode);
        Node renderedNode = DOMUtil.getChildNamed(componentNode, "rendered");
        String renderedValue = DOMUtil.getNodeTextContent(renderedNode);
        Node validNode = DOMUtil.getChildNamed(componentNode, "valid");
        String validValue = DOMUtil.getNodeTextContent(validNode);
        ComponentTreeObject componentTreeParent = new ComponentTreeObject(componentId, componentClass);
        parent.addChild(componentTreeParent);
        if (renderedValue != null && renderedValue.equals("false")) {
            componentTreeParent.setNotRendered();
        }
        if (validValue != null && validValue.equals("false")) {
            componentTreeParent.setInvalid();
        }
        if (value != null) {
            newObject = new TreeObject(String.valueOf(Messages.JSFDebugView_71) + value);
            newObject.setImage("attribute");
            componentTreeParent.addChild(newObject);
            this.setTreeObjectState(newObject, "value", value);
        }
        if (submittedValue != null) {
            newObject = new TreeObject(String.valueOf(Messages.JSFDebugView_74) + submittedValue);
            newObject.setImage("attribute");
            componentTreeParent.addChild(newObject);
            this.setTreeObjectState(newObject, "submitted value", submittedValue);
        }
        this.contentProvider.getTreeValues().put(componentTreeParent.toString(), "1");
        List<Node> components = DOMUtil.getChildrenNamed(componentNode, "component");
        for (Node component : components) {
            this.addComponentNode(componentTreeParent, component);
        }
    }

    private TreeParent addMessagesNode(Document doc) {
        Node messagesNode = doc.getFirstChild();
        MessagesTreeObject messagesTreeObject = new MessagesTreeObject();
        this.contentProvider.getRoot().addChild(messagesTreeObject);
        List<Node> messageNodes = DOMUtil.getChildrenNamed(messagesNode, "message");
        for (Node messageNode : messageNodes) {
            this.addMessageNode(messagesTreeObject, messageNode);
        }
        return messagesTreeObject;
    }

    private void addMessageNode(TreeParent parent, Node messageNode) {
        Node severityNode = DOMUtil.getChildNamed(messageNode, "severity");
        String severity = DOMUtil.getNodeTextContent(severityNode);
        Node summaryNode = DOMUtil.getChildNamed(messageNode, "summary");
        String summary = DOMUtil.getNodeTextContent(summaryNode);
        TreeObject object = new TreeObject(String.valueOf(summary) + " [" + severity + "]");
        if (severity != null && severity.startsWith("ERROR")) {
            object.setImage("error");
        }
        parent.addChild(object);
    }

    private TreeParent addNavigationNode(Document doc) {
        Node navigationNode = doc.getFirstChild();
        String fromView = DOMUtil.getNodeTextContent(DOMUtil.getChildNamed(navigationNode, "from-view"));
        String toView = DOMUtil.getNodeTextContent(DOMUtil.getChildNamed(navigationNode, "to-view"));
        TreeParent navigationTreeObject = new TreeParent(String.valueOf(Messages.JSFDebugView_88) + fromView + " -> " + toView);
        navigationTreeObject.setImage("buttonnav");
        this.contentProvider.getRoot().addChild(navigationTreeObject);
        String action = DOMUtil.getNodeTextContent(DOMUtil.getChildNamed(navigationNode, "action"));
        TreeObject child = new TreeObject(String.valueOf(Messages.JSFDebugView_92) + action);
        child.setImage("action");
        navigationTreeObject.addChild(child);
        String outcome = DOMUtil.getNodeTextContent(DOMUtil.getChildNamed(navigationNode, "outcome"));
        TreeObject child2 = new TreeObject(String.valueOf(Messages.JSFDebugView_95) + outcome);
        child2.setImage("outcome");
        navigationTreeObject.addChild(child2);
        return navigationTreeObject;
    }

    private void addMapNode(TreeParent parent, Node mapNode) {
        List<Node> entries = DOMUtil.getChildrenNamed(mapNode, "entry");
        for (Node entry : entries) {
            Node nameNode = DOMUtil.getChildNamed(entry, "name");
            String name = DOMUtil.getNodeTextContent(nameNode);
            Node valueNode = DOMUtil.getChildNamed(entry, "value");
            String value = DOMUtil.getNodeTextContent(valueNode);
            TreeParent newObject = new TreeParent(String.valueOf(name) + " = " + value);
            newObject.setImage("mapentry");
            newObject.setJavaObjectName(name);
            parent.addChild(newObject);
            this.setTreeObjectState(newObject, name, value);
            this.addMapNode(newObject, entry);
            this.contentProvider.getTreeValues().put(newObject.getName(), "1");
        }
    }

    private void setTreeObjectState(TreeObject object, String name, String value) {
        if (value == null) {
            value = "null";
        }
        TreeParent parent = object.getParent();
        if (this.contentProvider.getTreeValues().get(parent.toString()) == null) {
            this.contentProvider.getTreeValues().put(String.valueOf(parent.toString()) + "/" + name, value);
            return;
        }
        String oldValue = this.contentProvider.getTreeValues().get(String.valueOf(parent.toString()) + "/" + name);
        if (oldValue == null) {
            object.setState(TreeObject.TreeObjectState.NEW);
        } else if (!oldValue.equals(value)) {
            object.setState(TreeObject.TreeObjectState.CHANGED);
        }
        this.contentProvider.getTreeValues().put(String.valueOf(parent.toString()) + "/" + name, value);
    }

    public void expandNode(TreeParent object) {
        TreeObject[] children;
        if (object == null) {
            return;
        }
        TreeObject[] treeObjectArray = children = object.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeObject treeObject = treeObjectArray[n2];
            if (this.shouldExpand(treeObject)) {
                this.expandPathToNode(treeObject);
            }
            if (treeObject instanceof TreeParent) {
                this.expandNode((TreeParent)treeObject);
            }
            ++n2;
        }
    }

    private void expandPathToNode(TreeObject treeObject) {
        Vector<TreeObject> path = new Vector<TreeObject>();
        path.add(treeObject);
        TreeParent parent = treeObject.getParent();
        while (parent != null && !this.viewer.getExpandedState((Object)parent)) {
            path.add(0, parent);
            parent = parent.getParent();
        }
        int i = 0;
        while (i < path.size()) {
            this.viewer.setExpandedState(path.get(i), true);
            ++i;
        }
    }

    private boolean shouldExpand(TreeObject treeObject) {
        TreeParent parent = treeObject.getParent();
        if (parent instanceof MessagesTreeObject) {
            return true;
        }
        if (treeObject.getState() == TreeObject.TreeObjectState.CHANGED || treeObject.getState() == TreeObject.TreeObjectState.NEW) {
            String name = treeObject.toString();
            return !PrefUtil.isSystemObject(name);
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        RGB rgb;
        if (event.getProperty().equals("port")) {
            this.stopCommunication();
            this.portNumber = JSFDebugPlugin.getDefault().getPreferenceStore().getInt("port");
            this.startCommunication();
        }
        if (event.getProperty().equals("colorNew")) {
            rgb = PreferenceConverter.getColor((IPreferenceStore)JSFDebugPlugin.getDefault().getPreferenceStore(), (String)"colorNew");
            if (this.colorNew != null) {
                this.colorNew.dispose();
            }
            this.colorNew = new Color((Device)Display.getCurrent(), rgb);
            this.viewer.refresh();
        }
        if (event.getProperty().equals("colorChanged")) {
            rgb = PreferenceConverter.getColor((IPreferenceStore)JSFDebugPlugin.getDefault().getPreferenceStore(), (String)"colorChanged");
            if (this.colorChanged != null) {
                this.colorChanged.dispose();
            }
            this.colorChanged = new Color((Device)Display.getCurrent(), rgb);
            this.viewer.refresh();
        }
        if (event.getProperty().equals("highlightNewChanged")) {
            this.highlightNewChanged = JSFDebugPlugin.getDefault().getPreferenceStore().getBoolean("highlightNewChanged");
            this.viewer.refresh();
        }
        if (event.getProperty().equals("highlightSystem")) {
            this.highlightSystem = JSFDebugPlugin.getDefault().getPreferenceStore().getBoolean("highlightSystem");
            this.viewer.refresh();
        }
        if (event.getProperty().equals("autoExpends")) {
            this.autoExpand = JSFDebugPlugin.getDefault().getPreferenceStore().getBoolean("autoExpends");
        }
        if (event.getProperty().equals("openNewMessage")) {
            this.showOnNewMessage = JSFDebugPlugin.getDefault().getPreferenceStore().getBoolean("openNewMessage");
        }
        if (event.getProperty().equals("systemObjects")) {
            PrefUtil.load();
            this.viewer.refresh();
        }
    }

    private void startCommunication() {
        this.serverSocketThread = new Thread(){

            @Override
            public void run() {
                try {
                    JSFDebugView.this.serverSocket = new ServerSocket(JSFDebugView.this.portNumber);
                }
                catch (Exception exception) {}
                while (JSFDebugView.this.serverSocketThread == Thread.currentThread()) {
                    try {
                        JSFDebugView.this.clientSocket = JSFDebugView.this.serverSocket.accept();
                    }
                    catch (Exception exception) {}
                    if (JSFDebugView.this.clientSocket != null) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                JSFDebugView.this.infoArea.setVisible(false);
                                JSFDebugView.this.scrolledComposite.setMinSize(JSFDebugView.this.newParent.computeSize(-1, -1));
                                JSFDebugView.this.scrolledComposite.layout(true);
                            }
                        });
                    }
                    JSFDebugView.this.clientSocketThread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                String inputLine;
                                BufferedReader in = new BufferedReader(new InputStreamReader(JSFDebugView.this.clientSocket.getInputStream(), "UTF-8"));
                                String message = "";
                                while (JSFDebugView.this.clientSocketThread == Thread.currentThread() && (inputLine = in.readLine()) != null) {
                                    JSFDebugView.this.consoleOutput.println(inputLine);
                                    if (inputLine.equals("<JSFTRACE>")) {
                                        message = "";
                                        continue;
                                    }
                                    if (inputLine.equals("</JSFTRACE>")) {
                                        JSFDebugView.this.processMessage(message);
                                        continue;
                                    }
                                    message = String.valueOf(message) + inputLine;
                                }
                                in.close();
                                JSFDebugView.this.clientSocket.close();
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        JSFDebugView.this.infoArea.setVisible(true);
                                        JSFDebugView.this.scrolledComposite.setMinSize(JSFDebugView.this.newParent.computeSize(-1, -1));
                                        JSFDebugView.this.scrolledComposite.layout(true);
                                    }
                                });
                            }
                            catch (Exception exception) {}
                        }
                    };
                    JSFDebugView.this.clientSocketThread.start();
                }
            }
        };
        this.serverSocketThread.start();
    }

    private void stopCommunication() {
        try {
            if (this.clientSocket != null) {
                this.clientSocket.getOutputStream().write("CLOSE".getBytes());
                this.clientSocket.close();
                this.clientSocket = null;
            }
            this.clientSocketThread = null;
            this.serverSocketThread = null;
            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.serverSocket = null;
            }
        }
        catch (Exception exception) {}
        if (!this.infoArea.isDisposed()) {
            this.infoArea.setVisible(true);
            this.scrolledComposite.setMinSize(this.newParent.computeSize(-1, -1));
            this.scrolledComposite.layout(true);
        }
    }

    public Color getColorNew() {
        return this.colorNew;
    }

    public Color getColorChanged() {
        return this.colorChanged;
    }

    public boolean isHighlightSystem() {
        return this.highlightSystem;
    }

    public boolean isHighlightNewChanged() {
        return this.highlightNewChanged;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public ViewContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public DebugViewFilter getFilter() {
        return this.viewerFilter;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setAutoOpen() {
        if (JSFDebugPlugin.getDefault().getPreferenceStore().getBoolean("openShowMessage")) {
            this.autoOpenArea.setVisible(true);
            this.scrolledComposite.setMinSize(this.newParent.computeSize(-1, -1));
            this.scrolledComposite.layout(true);
        }
    }

    public boolean isVisible() {
        return this.bVisible;
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (partRef.getId().equals(this.getSite().getId())) {
            this.bVisible = true;
        }
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        if (partRef.getId().equals(this.getSite().getId())) {
            this.bVisible = false;
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }
}

