/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.debug.internal.views;

import com.ibm.etools.jsf.debug.JSFDebugPlugin;
import com.ibm.etools.jsf.debug.internal.views.filter.AbstractViewFilter;
import com.ibm.etools.jsf.debug.internal.views.filter.ApplicationScopeFilter;
import com.ibm.etools.jsf.debug.internal.views.filter.ChangedObjectsFilter;
import com.ibm.etools.jsf.debug.internal.views.filter.RequestScopeFilter;
import com.ibm.etools.jsf.debug.internal.views.filter.SessionScopeFilter;
import com.ibm.etools.jsf.debug.internal.views.filter.SystemObjectFilter;
import com.ibm.etools.jsf.debug.internal.views.filter.ViewAttributesFilter;
import com.ibm.etools.jsf.debug.internal.views.filter.ViewTreeFilter;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class DebugViewFilter
extends ViewerFilter {
    private IStructuredContentProvider contentProvider;
    private ArrayList<AbstractViewFilter> filters = new ArrayList(6);

    public DebugViewFilter() {
        String[] selectedFilters;
        this.filters.add(new ApplicationScopeFilter());
        this.filters.add(new SessionScopeFilter());
        this.filters.add(new RequestScopeFilter());
        this.filters.add(new SystemObjectFilter());
        this.filters.add(new ViewAttributesFilter());
        this.filters.add(new ViewTreeFilter());
        this.filters.add(new ChangedObjectsFilter());
        String prefFilters = JSFDebugPlugin.getDefault().getPreferenceStore().getString("filters");
        String[] stringArray = selectedFilters = prefFilters.split(",");
        int n = selectedFilters.length;
        int n2 = 0;
        while (n2 < n) {
            String selectedFilter = stringArray[n2];
            for (AbstractViewFilter filter : this.filters) {
                if (!filter.getName().equals(selectedFilter)) continue;
                filter.setSelected(true);
                break;
            }
            ++n2;
        }
        this.contentProvider = new FilterContentProvider();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        for (AbstractViewFilter filter : this.filters) {
            boolean ret;
            if (!filter.isSelected() || (ret = filter.select(viewer, parentElement, element))) continue;
            return false;
        }
        return true;
    }

    public IStructuredContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public Object[] getSelection() {
        ArrayList<String> list = new ArrayList<String>();
        for (AbstractViewFilter filter : this.filters) {
            if (!filter.isSelected()) continue;
            list.add(filter.getName());
        }
        return list.toArray();
    }

    public void setSelection(Object[] elements) {
        for (AbstractViewFilter filter : this.filters) {
            filter.setSelected(false);
        }
        StringBuilder str = new StringBuilder();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            String name = object.toString();
            str.append(name).append(",");
            for (AbstractViewFilter filter : this.filters) {
                if (!filter.getName().equals(name)) continue;
                filter.setSelected(true);
                break;
            }
            ++n2;
        }
        if (str.length() > 0) {
            str.deleteCharAt(str.length() - 1);
        }
        JSFDebugPlugin.getDefault().getPreferenceStore().setValue("filters", str.toString());
    }

    class FilterContentProvider
    implements IStructuredContentProvider {
        FilterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<String> list = new ArrayList<String>();
            for (AbstractViewFilter filter : DebugViewFilter.this.filters) {
                list.add(filter.getName());
            }
            return list.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

