/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.debug.internal.util;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImage
extends CompositeImageDescriptor {
    private Point fSize = new Point(16, 16);
    private Image fBase;
    private ImageDescriptor fOverlay;
    private int fQuadrant;

    public OverlayImage(Image base, ImageDescriptor overlayImage, int quadrant) {
        this.fBase = base;
        this.fOverlay = overlayImage;
        this.fQuadrant = quadrant;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.fBase.getImageData();
        this.drawImage(bg, 0, 0);
        switch (this.fQuadrant) {
            case 0: {
                this.drawTopLeft();
                break;
            }
            case 1: {
                this.drawTopRight();
                break;
            }
            case 2: {
                this.drawBottomLeft();
                break;
            }
            case 3: {
                this.drawBottomRight();
            }
        }
    }

    protected void drawTopLeft() {
        ImageData id = this.fOverlay.getImageData();
        this.drawImage(id, 0, 0);
    }

    protected void drawTopRight() {
        ImageData id = this.fOverlay.getImageData();
        this.drawImage(id, this.getSize().x - id.width, 0);
    }

    protected void drawBottomLeft() {
        ImageData id = this.fOverlay.getImageData();
        this.drawImage(id, 0, this.getSize().y - id.height);
    }

    protected void drawBottomRight() {
        ImageData id = this.fOverlay.getImageData();
        this.drawImage(id, this.getSize().x - id.width, this.getSize().y - id.height);
    }

    protected Point getSize() {
        return this.fSize;
    }
}

