/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.debug.internal.actions;

import com.ibm.etools.jsf.debug.internal.nls.Messages;
import com.ibm.etools.jsf.debug.internal.views.tree.ScopeTreeObject;
import com.ibm.etools.jsf.debug.internal.views.tree.TreeObject;
import com.ibm.etools.jsf.debug.internal.views.tree.TreeParent;
import com.ibm.etools.jsf.debug.internal.views.tree.ViewAttributesTreeObject;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WatchExpressionAction
extends Action {
    private Type type;
    private TreeObject treeObject;

    public WatchExpressionAction() {
        this.setText(Messages.WatchExpressionAction_0);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.etools.jsf.debug", (String)"icons/watch.gif"));
    }

    public void run() {
        String objName = null;
        if (this.treeObject == null) {
            InputDialog inputDlg = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.WatchExpressionAction_1, Messages.WatchExpressionAction_2, null, null);
            if (inputDlg.open() == 0) {
                objName = inputDlg.getValue();
            }
        } else {
            objName = this.treeObject.getJavaObjectName();
            TreeParent parent = this.treeObject.getParent();
            if (parent instanceof ScopeTreeObject) {
                ScopeTreeObject scopeObject = (ScopeTreeObject)parent;
                switch (scopeObject.getScope()) {
                    case REQUEST: {
                        this.type = Type.REQUEST;
                        break;
                    }
                    case SESSION: {
                        this.type = Type.SESSION;
                        break;
                    }
                    case APPLICATION: {
                        this.type = Type.APPLICATION;
                    }
                }
            } else if (parent instanceof ViewAttributesTreeObject) {
                this.type = Type.VIEWATTRIBUTE;
            }
        }
        if (objName == null) {
            return;
        }
        String expression = null;
        switch (this.type) {
            case REQUEST: {
                expression = "javax.faces.context.FacesContext.getCurrentInstance().getExternalContext().getRequestMap().get(\"" + objName + "\")";
                break;
            }
            case SESSION: {
                expression = "javax.faces.context.FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get(\"" + objName + "\")";
                break;
            }
            case APPLICATION: {
                expression = "javax.faces.context.FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().get(\"" + objName + "\")";
                break;
            }
            case VIEWATTRIBUTE: {
                expression = "javax.faces.context.FacesContext.getCurrentInstance().getViewRoot().getAttributes().get(\"" + objName + "\")";
            }
        }
        if (expression != null) {
            IWatchExpression watchExpression = DebugPlugin.getDefault().getExpressionManager().newWatchExpression(expression);
            DebugPlugin.getDefault().getExpressionManager().addExpression((IExpression)watchExpression);
        }
    }

    public void setObject(TreeObject obj) {
        this.treeObject = obj;
    }

    public void setType(Type type) {
        this.type = type;
        switch (type) {
            case REQUEST: {
                this.setText(Messages.bind((String)Messages.WatchExpressionAction_3, (Object)Messages.WatchExpressionAction_4));
                break;
            }
            case SESSION: {
                this.setText(Messages.bind((String)Messages.WatchExpressionAction_3, (Object)Messages.WatchExpressionAction_6));
                break;
            }
            case APPLICATION: {
                this.setText(Messages.bind((String)Messages.WatchExpressionAction_3, (Object)Messages.WatchExpressionAction_8));
                break;
            }
            case VIEWATTRIBUTE: {
                this.setText(Messages.WatchExpressionAction_9);
            }
        }
    }

    public static enum Type {
        REQUEST,
        SESSION,
        APPLICATION,
        VIEWATTRIBUTE;

    }
}

