/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.debug.internal.actions;

import com.ibm.etools.jsf.debug.internal.nls.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.osgi.framework.Bundle;

public class SetupAction
extends Action {
    private static final String RUNTIME_FOLDER = "/runtime/";
    private static final String JSF_TRACE_JAR = "jsf-trace.jar";
    private static final String WEB_CONTENT_WEB_INF_LIB = "/WebContent/WEB-INF/lib";
    private static final String TITLE = Messages.SetupAction_3;

    public void run() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        ArrayList<IProject> potentialProjects = new ArrayList<IProject>();
        ArrayList<IProject> selectedProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (this.canAddTracingToProject(project)) {
                potentialProjects.add(project);
            }
            ++n2;
        }
        if (potentialProjects.size() == 0) {
            MessageBox msgBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
            msgBox.setText(TITLE);
            msgBox.setMessage(Messages.SetupAction_4);
            msgBox.open();
            return;
        }
        if (potentialProjects.size() == 1) {
            selectedProjects = potentialProjects;
        } else {
            ListSelectionDialog dlg = new ListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)ResourcesPlugin.getWorkspace().getRoot(), (IStructuredContentProvider)new ProjectContentProvider(), (ILabelProvider)new WorkbenchLabelProvider(), Messages.SetupAction_5);
            dlg.setTitle(TITLE);
            dlg.open();
            if (dlg.getReturnCode() == 0) {
                Object[] results;
                Object[] objectArray = results = dlg.getResult();
                int n3 = results.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object object = objectArray[n4];
                    selectedProjects.add((IProject)object);
                    ++n4;
                }
            } else {
                return;
            }
        }
        for (IProject project : selectedProjects) {
            MessageBox msgBox = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 196);
            msgBox.setText(TITLE);
            StringBuilder str = new StringBuilder();
            str.append(Messages.bind((String)Messages.SetupAction_6, (Object)project.getName()));
            str.append("\n\n");
            str.append(Messages.SetupAction_8);
            str.append("\n\n");
            str.append(Messages.SetupAction_10);
            msgBox.setMessage(str.toString());
            if (msgBox.open() != 64) continue;
            this.copyJar(project, "/runtime/jsf-trace.jar");
        }
    }

    private void copyJar(IProject project, String jarName) {
        try {
            IFolder webInfLibFolder = project.getFolder(WEB_CONTENT_WEB_INF_LIB);
            String sourcePath = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"com.ibm.etools.jsf.debug"), (IPath)new Path(jarName), null)).getPath().toString();
            File sourceFile = new File(sourcePath);
            IFile copyFile = webInfLibFolder.getFile((IPath)new Path(sourceFile.getName()));
            FileInputStream sourceStream = new FileInputStream(sourceFile);
            if (!copyFile.exists()) {
                copyFile.create((InputStream)sourceStream, true, null);
            } else {
                copyFile.setContents((InputStream)sourceStream, true, false, null);
            }
            sourceStream.close();
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
    }

    private boolean canAddTracingToProject(IProject project) {
        IFolder webInfLibFolder = project.getFolder(WEB_CONTENT_WEB_INF_LIB);
        if (!webInfLibFolder.exists()) {
            return false;
        }
        IResource jarFile = webInfLibFolder.findMember(JSF_TRACE_JAR);
        return jarFile == null;
    }

    class ProjectContentProvider
    extends WorkbenchContentProvider {
        ProjectContentProvider() {
        }

        public Object[] getElements(Object element) {
            Object[] elements = super.getElements(element);
            ArrayList<IProject> projects = new ArrayList<IProject>();
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project;
                Object el = objectArray[n2];
                if (el instanceof IProject && SetupAction.this.canAddTracingToProject(project = (IProject)el)) {
                    projects.add(project);
                }
                ++n2;
            }
            return projects.toArray();
        }
    }
}

