/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.debug.internal.actions;

import com.ibm.etools.jsf.debug.JSFDebugPlugin;
import com.ibm.etools.jsf.debug.internal.nls.Messages;
import com.ibm.etools.jsf.debug.internal.views.tree.PhaseStageTreeObject;
import com.ibm.etools.jsf.debug.internal.views.tree.PhaseTreeObject;
import com.ibm.etools.jsf.debug.internal.views.tree.TreeObject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class BreakpointAction
extends Action {
    private String methodName;
    private TreeObject treeObject;
    private TreeViewer viewer;

    public BreakpointAction(TreeViewer viewer) {
        super(null, 2);
        this.viewer = viewer;
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.etools.jsf.debug", (String)"icons/breakpoint.gif"));
    }

    public void setMethodName(String name) {
        this.methodName = name;
    }

    public void run() {
        try {
            IBreakpoint existingBreakpoint = this.getExistingBreakpoint();
            if (existingBreakpoint == null) {
                JDIDebugModel.createMethodBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), (String)"com.ibm.faces.trace.TracePhaseListener", (String)this.methodName, (String)"(Ljavax/faces/context/FacesContext;)V", (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)-1, (int)-1, (int)0, (boolean)true, null);
            } else {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(existingBreakpoint, true);
            }
            this.viewer.refresh();
        }
        catch (CoreException e) {
            JSFDebugPlugin.log(e);
        }
    }

    public IBreakpoint getExistingBreakpoint() {
        try {
            IBreakpoint[] breakpoints;
            IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
            int n = breakpoints.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaMethodBreakpoint methodBreakpoint;
                IBreakpoint breakpoint = iBreakpointArray[n2];
                if (breakpoint instanceof IJavaMethodBreakpoint && (methodBreakpoint = (IJavaMethodBreakpoint)breakpoint).getMethodName().equals(this.methodName)) {
                    return breakpoint;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void setObject(TreeObject obj) {
        this.treeObject = obj;
    }

    public void update() {
        this.setText(null);
        this.setChecked(false);
        if (this.treeObject instanceof PhaseStageTreeObject) {
            PhaseStageTreeObject stage = (PhaseStageTreeObject)this.treeObject;
            PhaseTreeObject phase = (PhaseTreeObject)this.treeObject.getParent();
            String phaseName = phase.getPhaseId();
            if (phaseName.startsWith("RESTORE")) {
                phaseName = "RestoreView";
            } else if (phaseName.startsWith("APPLY")) {
                phaseName = "ApplyRequestValues";
            } else if (phaseName.startsWith("PROCESS")) {
                phaseName = "ProcessValidations";
            } else if (phaseName.startsWith("UPDATE")) {
                phaseName = "UpdateModel";
            } else if (phaseName.startsWith("INVOKE")) {
                phaseName = "InvokeApplication";
            } else if (phaseName.startsWith("RENDER")) {
                phaseName = "RenderResponse";
            }
            String stageName = "before";
            if (stage.getStage() == PhaseStageTreeObject.PhaseStage.AFTER) {
                stageName = "after";
            }
            this.setMethodName(String.valueOf(stageName) + phaseName + "Phase");
            String operation = Messages.BreakpointAction_0;
            if (this.getExistingBreakpoint() != null) {
                operation = Messages.BreakpointAction_1;
            }
            this.setText(operation, stage.getStage(), phaseName);
        }
    }

    public void setText(String operation, PhaseStageTreeObject.PhaseStage phaseStage, String phase) {
        String stageName = Messages.BreakpointAction_2;
        if (phaseStage == PhaseStageTreeObject.PhaseStage.AFTER) {
            stageName = Messages.BreakpointAction_3;
        }
        this.setText(Messages.bind((String)Messages.BreakpointAction_4, (Object[])new Object[]{operation, stageName, phase}));
    }
}

