/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jsf.debug;

import com.ibm.etools.jsf.debug.internal.nls.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JSFDebugPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.etools.jsf.debug";
    private static JSFDebugPlugin plugin;

    public JSFDebugPlugin() {
        plugin = this;
    }

    public static JSFDebugPlugin getDefault() {
        if (plugin == null) {
            plugin = new JSFDebugPlugin();
        }
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        Color changedColor;
        Color newColor;
        super.start(context);
        this.getPreferenceStore().setDefault("port", 4444);
        this.getPreferenceStore().setDefault("highlightNewChanged", true);
        this.getPreferenceStore().setDefault("autoExpends", true);
        this.getPreferenceStore().setDefault("highlightSystem", false);
        this.getPreferenceStore().setDefault("systemObjects", "com.ibm.,com.sun.,javax.,org.,/");
        this.getPreferenceStore().setDefault("openNewMessage", true);
        this.getPreferenceStore().setDefault("openShowMessage", true);
        this.getPreferenceStore().setDefault("openRunOnServer", true);
        Color foregroundColor = Display.getCurrent().getSystemColor(24);
        if (foregroundColor.equals((Object)Display.getCurrent().getSystemColor(1))) {
            newColor = Display.getDefault().getSystemColor(6);
            changedColor = Display.getDefault().getSystemColor(8);
        } else {
            newColor = Display.getDefault().getSystemColor(5);
            changedColor = Display.getDefault().getSystemColor(7);
        }
        PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"colorNew", (RGB)newColor.getRGB());
        PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"colorChanged", (RGB)changedColor.getRGB());
    }

    public Image getImage(String imageName) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(imageName);
        if (image != null && image.isDisposed()) {
            imageRegistry.remove(imageName);
            image = null;
        }
        if (image == null) {
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("icons/" + imageName + ".gif"));
            imageRegistry.put(imageName, imageDescriptor);
            image = imageRegistry.get(imageName);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String image) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)image);
    }

    public static void log(Throwable e) {
        JSFDebugPlugin.log((IStatus)new Status(4, PLUGIN_ID, 4, Messages.bind((String)Messages.ErrorThrown, (Object)PLUGIN_ID), e));
    }

    private static void log(IStatus status) {
        JSFDebugPlugin.getDefault().getLog().log(status);
    }
}

