/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.ltk.core.participant;

import com.ibm.etools.j2ee.reference.J2EETeamShareRefactorHandler;
import com.ibm.etools.javaee.ltk.core.change.DeleteEJBClientProjectChange;
import com.ibm.etools.javaee.ltk.core.change.EARReferenceRemoveChange;
import com.ibm.etools.javaee.ltk.core.change.NonEARModuleReferenceRemoveChange;
import com.ibm.etools.javaee.ltk.core.nls.RefactoringResourceHandler;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jst.j2ee.project.EJBUtilities;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraph;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class JavaEERefactoringParticipant
extends DeleteParticipant {
    private IProject projectToDelete = null;
    private IProject ejbClientProject = null;
    private boolean deletedProjectContainedInSharedEAR = false;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange result = null;
        result = this.createChangeObjects(result, this.projectToDelete);
        if (this.ejbClientProject != null) {
            result = this.createChangeObjects(result, this.ejbClientProject);
            DeleteEJBClientProjectChange dc = new DeleteEJBClientProjectChange(this.ejbClientProject, true, true);
            result.add((Change)dc);
        }
        return result;
    }

    private CompositeChange createChangeObjects(CompositeChange compositeChange, IProject projectToBeDeleted) {
        Set referencingComponents = IDependencyGraph.INSTANCE.getReferencingComponents(projectToBeDeleted);
        IProject[] dependentProjectList = referencingComponents.toArray(new IProject[referencingComponents.size()]);
        if (dependentProjectList.length > 0) {
            if (compositeChange == null) {
                compositeChange = new CompositeChange(this.getName());
            }
            int i = 0;
            while (i < dependentProjectList.length) {
                IProject dependentProject = dependentProjectList[i];
                if (JavaEEProjectUtilities.isEARProject((IProject)dependentProjectList[i])) {
                    EARReferenceRemoveChange ec = new EARReferenceRemoveChange(dependentProject, projectToBeDeleted);
                    if (this.deletedProjectContainedInSharedEAR) {
                        ec.setEnabled(false);
                    }
                    compositeChange.add((Change)ec);
                } else {
                    NonEARModuleReferenceRemoveChange nc = new NonEARModuleReferenceRemoveChange(dependentProject, projectToBeDeleted);
                    if (this.deletedProjectContainedInSharedEAR) {
                        nc.setEnabled(false);
                    }
                    compositeChange.add((Change)nc);
                }
                ++i;
            }
        }
        return compositeChange;
    }

    private IProject getClientProject(IProject ejbProject) {
        IVirtualComponent clientComponent;
        if (ejbProject.exists() && ejbProject.isAccessible() && (clientComponent = EJBUtilities.getEJBClientJar((IProject)ejbProject)) != null) {
            return clientComponent.getProject();
        }
        return null;
    }

    public String getName() {
        String name = NLS.bind((String)RefactoringResourceHandler.JavaEE_Refactorings_Participant_title, (Object[])new Object[]{this.projectToDelete.getName()});
        return name;
    }

    protected boolean initialize(Object element) {
        if (!(element instanceof IProject)) {
            return false;
        }
        this.projectToDelete = (IProject)element;
        if (this.isDeletedProjectContainedInSharedEAR(this.projectToDelete)) {
            this.deletedProjectContainedInSharedEAR = true;
        }
        if (JavaEEProjectUtilities.isEJBProject((IProject)this.projectToDelete)) {
            this.ejbClientProject = this.getClientProject(this.projectToDelete);
        }
        return true;
    }

    protected boolean isTeamShareEAR(IProject project) {
        IFile teamShareFile;
        return project != null && (teamShareFile = project.getFile(J2EETeamShareRefactorHandler.TEAM_SHARE_PATH)).exists();
    }

    protected boolean isDeletedProjectContainedInSharedEAR(IProject deletedProject) {
        IProject[] dependentEARProjectList = EarUtilities.getReferencingEARProjects((IProject)deletedProject);
        int i = 0;
        while (i < dependentEARProjectList.length) {
            if (this.isTeamShareEAR(dependentEARProjectList[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

