/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.javaee.ltk.core.change;

import com.ibm.etools.javaee.ltk.core.nls.RefactoringResourceHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.jee.application.ICommonApplication;
import org.eclipse.jst.jee.application.ICommonModule;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class EARReferenceRemoveChange
extends Change {
    IProject referencingEARProject = null;
    IVirtualComponent referencingEARProjectComp = null;
    IProject projectToRemove = null;
    IVirtualComponent projectToRemoveComp = null;
    IVirtualReference[] cachedRefs = null;
    IEARModelProvider earModel = null;
    String moduleURI = null;

    public EARReferenceRemoveChange(IProject referencingEARProject, IProject projectToRemove) {
        this.referencingEARProject = referencingEARProject;
        this.projectToRemove = projectToRemove;
        this.referencingEARProjectComp = ComponentCore.createComponent((IProject)referencingEARProject);
        this.cachedRefs = this.referencingEARProjectComp.getReferences();
        this.projectToRemoveComp = ComponentCore.createComponent((IProject)projectToRemove);
        this.earModel = (IEARModelProvider)ModelProviderManager.getModelProvider((IProject)referencingEARProject);
        this.moduleURI = this.earModel.getModuleURI(this.projectToRemoveComp);
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        String name = NLS.bind((String)RefactoringResourceHandler.Remove_JavaEE_References, (Object[])new Object[]{this.projectToRemove.getName()});
        name = String.valueOf(name) + this.referencingEARProject.getName();
        return name;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        this.updateEARDD();
        this.removeReferencedComponents(pm);
        return null;
    }

    public ChangeDescriptor getDescriptor() {
        return null;
    }

    private void updateEARDD() {
        if (!this.referencingEARProject.isAccessible()) {
            return;
        }
        J2EEComponentClasspathUpdater.getInstance().queueUpdateEAR(this.referencingEARProject);
        this.earModel.modify(new Runnable(){

            @Override
            public void run() {
                ICommonApplication application = (ICommonApplication)EARReferenceRemoveChange.this.earModel.getModelObject();
                if (application == null) {
                    return;
                }
                IVirtualComponent moduleComponent = EARReferenceRemoveChange.this.projectToRemoveComp.getComponent();
                if (!moduleComponent.isBinary()) {
                    J2EEComponentClasspathUpdater.getInstance().queueUpdateModule(moduleComponent.getProject());
                }
                EARReferenceRemoveChange.this.removeModule(application, EARReferenceRemoveChange.this.moduleURI);
                IVirtualFile vFile = EARReferenceRemoveChange.this.referencingEARProjectComp.getRootFolder().getFile(EARReferenceRemoveChange.this.moduleURI);
                IFile iFile = vFile.getUnderlyingFile();
                if (iFile.exists()) {
                    try {
                        iFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        J2EEPlugin.logError((CoreException)e);
                    }
                }
            }
        }, null);
    }

    protected void removeModule(ICommonApplication application, String moduleURI) {
        ICommonModule module = application.getFirstEARModule(moduleURI);
        application.getEARModules().remove(module);
    }

    protected void removeReferencedComponents(IProgressMonitor monitor) {
        if (this.referencingEARProjectComp == null || !this.referencingEARProjectComp.getProject().isAccessible() || this.referencingEARProjectComp.isBinary()) {
            return;
        }
        IVirtualReference[] existingReferencesArray = this.cachedRefs;
        if (existingReferencesArray == null || existingReferencesArray.length == 0) {
            return;
        }
        ArrayList<IVirtualReference> existingReferences = new ArrayList<IVirtualReference>();
        int i = 0;
        while (i < existingReferencesArray.length) {
            existingReferences.add(existingReferencesArray[i]);
            ++i;
        }
        ArrayList<IProject> targetprojectList = new ArrayList<IProject>();
        if (this.projectToRemoveComp == null) {
            return;
        }
        IVirtualReference ref = this.findMatchingReference(existingReferences, this.projectToRemoveComp, null);
        if (ref != null) {
            this.removeRefereneceInComponent(this.referencingEARProjectComp, ref);
            existingReferences.remove(ref);
            ref = this.findMatchingReference(existingReferences, this.projectToRemoveComp);
            if (ref == null) {
                IProject targetProject = this.projectToRemoveComp.getProject();
                targetprojectList.add(targetProject);
            }
        }
        try {
            ProjectUtilities.removeReferenceProjects((IProject)this.referencingEARProjectComp.getProject(), targetprojectList);
        }
        catch (CoreException e) {
            J2EEPlugin.logError((CoreException)e);
        }
    }

    private IVirtualReference findMatchingReference(List existingReferences, IVirtualComponent comp) {
        return this.findMatchingReference(existingReferences, comp, null);
    }

    protected void removeRefereneceInComponent(IVirtualComponent component, IVirtualReference reference) {
        ((VirtualComponent)component.getComponent()).removeReference(reference);
    }

    private IVirtualReference findMatchingReference(List existingReferences, IVirtualComponent comp, IPath path) {
        int i = 0;
        while (i < existingReferences.size()) {
            IVirtualReference ref = (IVirtualReference)existingReferences.get(i);
            IVirtualComponent c = ref.getReferencedComponent();
            if (c != null && c.getName().equals(comp.getName())) {
                if (path == null) {
                    return ref;
                }
                if (path.equals((Object)ref.getRuntimePath())) {
                    return ref;
                }
            }
            ++i;
        }
        return null;
    }
}

