/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.reference;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.j2ee.internal.project.J2EENature;
import com.ibm.etools.j2ee.reference.MessageDestReferenceCreationOperation;
import com.ibm.etools.j2ee.reference.ReferenceDataModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.MessageDestination;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.moduleextension.EarModuleManager;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class MessageDestReferenceDataModel
extends ReferenceDataModel {
    public static final String TARGET = "MessageDestReferenceDataModel.TARGET";
    public static final String TYPE = "MessageDestReferenceDataModel.TYPE";
    public static final String LINK = "MessageDestReferenceDataModel.LINK";
    public static final String USAGE = "MessageDestReferenceDataModel.USAGE";
    public static final String HAS_LINK = "MessageDestReferenceDataModel.HAS_LINK";
    public static final String TARGET_IN_DIFFERENT_EAR = "MessageDestReferenceDataModel.TARGET_IN_DIFFERENT_EAR";
    private List messageDestinationNames;

    @Override
    protected void init() {
        super.init();
    }

    @Override
    protected void initValidBaseProperties() {
        this.addValidBaseProperty(TARGET);
        this.addValidBaseProperty(TYPE);
        this.addValidBaseProperty(LINK);
        this.addValidBaseProperty(USAGE);
        this.addValidBaseProperty(HAS_LINK);
        this.addValidBaseProperty(TARGET_IN_DIFFERENT_EAR);
        super.initValidBaseProperties();
    }

    @Override
    protected Object getDefaultProperty(String propertyName) {
        return super.getDefaultProperty(propertyName);
    }

    @Override
    protected IStatus doValidateProperty(String propertyName) {
        IStatus status = super.doValidateProperty(propertyName);
        if (TYPE.equals(propertyName) || USAGE.equals(propertyName)) {
            String temp = this.getStringProperty(propertyName);
            if (temp == null || temp.trim().equals("")) {
                if (TYPE.equals(propertyName)) {
                    return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.MessageDestReferenceDataModel_7);
                }
                if (USAGE.equals(propertyName)) {
                    return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.MessageDestReferenceDataModel_8);
                }
            }
        } else if (LINK.equals(propertyName) && !this.getBooleanProperty(HAS_LINK)) {
            if (!this.verifyLinkUnique(this.getStringProperty(LINK))) {
                return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.MessageDestReferenceDataModel_9);
            }
        } else if (propertyName.equals(TARGET)) {
            Object target = this.getProperty(TARGET);
            if (this.getBooleanProperty(HAS_LINK) && (target == null || !(target instanceof MessageDestination))) {
                return WTPCommonPlugin.createErrorStatus((String)J2EECreationResourceHandler.EJBReferenceDataModel_UI_12);
            }
        }
        return status;
    }

    private boolean verifyLinkUnique(String link) {
        if (this.messageDestinationNames == null) {
            EObject owner = (EObject)this.getProperty("ReferenceDataModel.OWNER");
            IVirtualComponent component = ComponentUtilities.findComponent((EObject)owner);
            IProject[] ears = J2EEProjectUtilities.getReferencingEARProjects((IProject)component.getProject());
            if (ears == null) {
                this.messageDestinationNames = this.getModuleMessageDestinationNames(owner);
            } else {
                this.messageDestinationNames = new ArrayList();
                int j = 0;
                while (j < ears.length) {
                    try {
                        IProject[] refProj = ears[j].getProject().getReferencedProjects();
                        if (refProj != null) {
                            int k = 0;
                            while (k < refProj.length) {
                                this.messageDestinationNames.addAll(this.getModuleMessageDestinationNames(refProj[k]));
                                ++k;
                            }
                        }
                    }
                    catch (CoreException e) {
                        J2eePlugin.logError(e.getMessage());
                    }
                    ++j;
                }
            }
        }
        if (this.messageDestinationNames == null || this.messageDestinationNames.isEmpty()) {
            return true;
        }
        int i = 0;
        while (i < this.messageDestinationNames.size()) {
            String name = ((MessageDestination)this.messageDestinationNames.get(i)).getName();
            if (name != null && name.equals(link)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private List getModuleMessageDestinationNames(IProject project) throws CoreException {
        if (project.hasNature("org.eclipse.jst.j2ee.ApplicationClientNature")) {
            J2EENature runtime = (J2EENature)project.getNature("org.eclipse.jst.j2ee.ApplicationClientNature");
            ApplicationClient appClient = (ApplicationClient)runtime.getDeploymentDescriptorRoot();
            if (appClient != null) {
                return appClient.getMessageDestinations();
            }
        } else {
            EJBJar ejbJar;
            AssemblyDescriptor assDesc;
            if (project.hasNature("org.eclipse.jst.j2ee.web.WebNature")) {
                J2EENature runtime = (J2EENature)project.getNature("org.eclipse.jst.j2ee.web.WebNature");
                WebApp webApp = (WebApp)runtime.getDeploymentDescriptorRoot();
                if (webApp != null) {
                    return webApp.getMessageDestinations();
                }
                return (List)runtime.getDeploymentDescriptorRoot();
            }
            if (project.hasNature("org.eclipse.jst.j2ee.ejb.EJBNature") && (assDesc = (ejbJar = EarModuleManager.getEJBModuleExtension().getEJBJar(project)).getAssemblyDescriptor()) != null) {
                return assDesc.getMessageDestinations();
            }
        }
        return new ArrayList();
    }

    private List getModuleMessageDestinationNames(EObject owner) {
        EList temp = new ArrayList();
        if (owner == null) {
            return temp;
        }
        switch (this.getDeploymentDescriptorType()) {
            case 1: {
                ApplicationClient client = (ApplicationClient)owner;
                temp = client.getMessageDestinations();
                break;
            }
            case 3: {
                EnterpriseBean ejb = (EnterpriseBean)owner;
                AssemblyDescriptor assDesc = ejb.getEjbJar().getAssemblyDescriptor();
                if (assDesc == null) break;
                temp = assDesc.getMessageDestinations();
                break;
            }
            case 4: {
                WebApp app = (WebApp)owner;
                temp = app.getMessageDestinations();
            }
        }
        return temp;
    }

    @Override
    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        if (TARGET.equals(propertyName)) {
            MessageDestination target = (MessageDestination)propertyValue;
            if (target == null) {
                this.setProperty(HAS_LINK, Boolean.FALSE);
                this.setProperty(LINK, "");
                return super.doSetProperty(propertyName, propertyValue);
            }
            this.setProperty(HAS_LINK, Boolean.TRUE);
            this.setProperty(LINK, target.getName());
            this.setProperty("ReferenceDataModel.REF_NAME", target.getName());
            this.notifyEnablementChange(LINK);
        }
        return super.doSetProperty(propertyName, propertyValue);
    }

    protected Boolean basicIsEnabled(String propertyName) {
        if (propertyName.equals(LINK)) {
            if (this.getBooleanProperty(HAS_LINK)) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return super.basicIsEnabled(propertyName);
    }

    @Override
    public WTPOperation getDefaultOperation() {
        return new MessageDestReferenceCreationOperation(this);
    }
}

