/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.reference;

import com.ibm.etools.j2ee.J2EEProjectUtilities;
import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.j2ee.common.operations.AddUtilityJARMapCommand;
import com.ibm.etools.j2ee.common.operations.ModelModifierOperation;
import com.ibm.etools.j2ee.reference.EJBReferenceDataModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.client.internal.impl.ClientFactoryImpl;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.EJBLocalRef;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.EjbRefType;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.internal.moduleextension.EarModuleManager;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;

public class EJBReferenceCreationOperation
extends ModelModifierOperation {
    protected IProject ownerProject;
    protected IVirtualComponent targetEJBComponent;
    protected AddUtilityJARMapCommand addUtilityJarMapCommand = null;
    protected String refName = null;
    protected String refType = null;
    protected String refHome = null;
    protected String refRemote = null;
    protected String des = null;
    protected String refLink = null;

    public EJBReferenceCreationOperation(EJBReferenceDataModel dataModel) {
        super(dataModel);
    }

    @Override
    protected void doInitialize(IProgressMonitor monitor) {
        super.doInitialize(monitor);
        this.setUpDataForCommand();
    }

    @Override
    protected void addHelpers() throws CoreException {
        Object[] obj;
        ModifierHelper baseHelper = null;
        baseHelper = !this.operationDataModel.getBooleanProperty("EJBReferenceDataModel.IS_LOCAL") ? this.createEjbRefHelper() : this.createEJBLocalRefHelper();
        this.modifier.addHelper(baseHelper);
        if (((EJBReferenceDataModel)this.operationDataModel).shouldCreateClientJar() && ((obj = EJBReferenceCreationOperation.findEJBClientComponent(this.targetEJBComponent)) == null || obj[1].equals(this.targetEJBComponent))) {
            try {
                EarModuleManager.getEJBModuleExtension().createEJBClientJARProject(this.targetEJBComponent.getProject()).execute(null, null);
            }
            catch (ExecutionException e) {
                J2eePlugin.logError(e);
            }
        }
        if (this.operationDataModel.getBooleanProperty("EJBReferenceDataModel.IN_WORKSPACE")) {
            if (!this.operationDataModel.getBooleanProperty("EJBReferenceDataModel.TARGET_AND_SOURCE_HAVE_SAME_EARS") && this.operationDataModel.getBooleanProperty("EJBReferenceDataModel.CREATE_CLIENT_IN_TARGET") && (obj = EJBReferenceCreationOperation.findEJBClientComponent(this.targetEJBComponent)) != null) {
                String archiveNameToFind = (String)obj[0];
                IVirtualComponent compSearchFor = (IVirtualComponent)obj[1];
                IVirtualComponent ownerComponent = ComponentCore.createComponent((IProject)this.ownerProject);
                IProject[] earProjects = org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities.getReferencingEARProjects((IProject)ownerComponent.getProject());
                if (earProjects.length > 0) {
                    String archiveName;
                    IProject earProject = earProjects[0];
                    IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProject);
                    boolean archiveFound = false;
                    IVirtualReference[] earRefs = earComponent.getReferences();
                    int i = 0;
                    while (i < earRefs.length && !archiveFound) {
                        archiveName = earRefs[i].getArchiveName();
                        if (archiveName != null && archiveNameToFind.equals(archiveName)) {
                            archiveFound = true;
                            this.targetEJBComponent = earRefs[i].getReferencedComponent();
                        }
                        ++i;
                    }
                    if (!archiveFound) {
                        this.addUtilityToEAR(compSearchFor, archiveNameToFind, earProject);
                        archiveFound = false;
                        earRefs = earComponent.getReferences();
                        i = 0;
                        while (i < earRefs.length && !archiveFound) {
                            archiveName = earRefs[i].getArchiveName();
                            if (archiveName != null && archiveNameToFind.equals(archiveName)) {
                                archiveFound = true;
                                this.targetEJBComponent = earRefs[i].getReferencedComponent();
                            }
                            ++i;
                        }
                    }
                }
            }
            this.updateJARDependencyIfNecessary();
        }
    }

    protected ModifierHelper createEJBLocalRefHelper() {
        ModifierHelper helper = new ModifierHelper();
        EJBLocalRef ref = CommonPackage.eINSTANCE.getCommonFactory().createEJBLocalRef();
        ref.setName(this.refName);
        ref.setType(EjbRefType.get((String)this.refType));
        ref.setLocal(this.refRemote);
        ref.setLocalHome(this.refHome);
        ref.setLink(this.refLink);
        Integer version = (Integer)this.operationDataModel.getProperty("ReferenceDataModel.J2EE_VERSION");
        if (version != null && version <= 13) {
            ref.setDescription(this.des);
        } else {
            Description descriptionObj = CommonFactory.eINSTANCE.createDescription();
            descriptionObj.setValue(this.des);
            ref.getDescriptions().add((Object)descriptionObj);
        }
        helper.setOwner((EObject)this.operationDataModel.getProperty("ReferenceDataModel.OWNER"));
        helper.setFeature((EStructuralFeature)CommonPackage.eINSTANCE.getJNDIEnvRefsGroup_EjbLocalRefs());
        helper.setValue((Object)ref);
        return helper;
    }

    protected ModifierHelper createEjbRefHelper() {
        ModifierHelper helper = new ModifierHelper();
        EjbRef ref = CommonPackage.eINSTANCE.getCommonFactory().createEjbRef();
        ref.setName(this.refName);
        ref.setType(EjbRefType.get((String)this.refType));
        ref.setHome(this.refHome);
        ref.setRemote(this.refRemote);
        ref.setLink(this.refLink);
        helper.setOwner((EObject)this.operationDataModel.getProperty("ReferenceDataModel.OWNER"));
        Integer version = (Integer)this.operationDataModel.getProperty("ReferenceDataModel.J2EE_VERSION");
        if (version != null && version <= 13) {
            ref.setDescription(this.des);
        } else {
            Description descriptionObj = CommonFactory.eINSTANCE.createDescription();
            descriptionObj.setValue(this.des);
            ref.getDescriptions().add((Object)descriptionObj);
        }
        switch (((EJBReferenceDataModel)this.operationDataModel).getDeploymentDescriptorType()) {
            case 1: {
                helper.setFeature((EStructuralFeature)ClientFactoryImpl.getPackage().getApplicationClient_EjbReferences());
                break;
            }
            case 3: {
                helper.setFeature((EStructuralFeature)CommonPackage.eINSTANCE.getJNDIEnvRefsGroup_EjbRefs());
                break;
            }
            case 4: {
                helper.setFeature((EStructuralFeature)CommonPackage.eINSTANCE.getJNDIEnvRefsGroup_EjbRefs());
            }
        }
        helper.setValue((Object)ref);
        return helper;
    }

    private void addUtilityToEAR(IVirtualComponent utilityComponent, String archiveName, IProject earProject) {
        if (utilityComponent.isBinary() && org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities.isEARProject((IProject)utilityComponent.getProject())) {
            IFile jarFile = ((J2EEModuleVirtualArchiveComponent)utilityComponent).getUnderlyingWorkbenchFile();
            IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProject);
            try {
                earComponent.getRootFolder().getFile(archiveName).getUnderlyingFile().create(jarFile.getContents(), true, null);
            }
            catch (CoreException e) {
                J2eePlugin.logError(e);
            }
            return;
        }
        IVirtualComponent sourceComp = ComponentCore.createComponent((IProject)earProject);
        ArrayList<IVirtualComponent> targetCompList = new ArrayList<IVirtualComponent>();
        targetCompList.add(utilityComponent);
        IDataModel uDataModel = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
        uDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)sourceComp);
        uDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", targetCompList);
        uDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)archiveName);
        try {
            uDataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            J2eePlugin.logError(e);
        }
    }

    public void updateJARDependencyIfNecessary() {
        EJBReferenceCreationOperation.updateJARDependencyIfNecessary(this.ownerProject, this.targetEJBComponent);
    }

    private static Object[] findEJBClientComponent(IVirtualComponent ejbComponent) {
        String ejbClientJarName = EJBReferenceCreationOperation.getClientJarName(ejbComponent);
        IVirtualComponent[] earComponents = J2EEProjectUtilities.getReferencingEARComponents(ejbComponent);
        int i = 0;
        while (i < earComponents.length) {
            IVirtualReference[] earRefs = earComponents[i].getReferences();
            int j = 0;
            while (j < earRefs.length) {
                String archiveName;
                if (ejbClientJarName != null) {
                    archiveName = earRefs[j].getArchiveName();
                    if (archiveName != null && archiveName.equals(ejbClientJarName)) {
                        return new Object[]{archiveName, earRefs[j].getReferencedComponent()};
                    }
                } else if (earRefs[j].getReferencedComponent().equals(ejbComponent)) {
                    archiveName = earRefs[j].getArchiveName();
                    return new Object[]{archiveName, earRefs[j].getReferencedComponent()};
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private static String getClientJarName(IVirtualComponent ejbComponent) {
        Object ejbModel;
        String ejbClientJarName = null;
        IModelProvider provider = ModelProviderManager.getModelProvider((IVirtualComponent)ejbComponent);
        if (provider != null && (ejbModel = provider.getModelObject()) != null) {
            if (ejbModel instanceof org.eclipse.jst.j2ee.ejb.EJBJar) {
                ejbClientJarName = ((org.eclipse.jst.j2ee.ejb.EJBJar)ejbModel).getEjbClientJar();
            } else if (ejbModel instanceof EJBJar) {
                ejbClientJarName = ((EJBJar)ejbModel).getEjbClientJar();
            }
        }
        return ejbClientJarName;
    }

    public static void updateJARDependencyIfNecessary(IProject ownerProject, IVirtualComponent targetEJBComponent) {
        if (ownerProject != null) {
            IVirtualComponent ownerComponent = ComponentCore.createComponent((IProject)ownerProject);
            if (ownerComponent.equals(targetEJBComponent)) {
                return;
            }
            IVirtualReference[] existingRefs = ownerComponent.getReferences();
            int i = 0;
            while (i < existingRefs.length) {
                if (existingRefs[i].getReferencedComponent().equals(targetEJBComponent)) {
                    return;
                }
                ++i;
            }
            IProject[] earProjects = org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities.getReferencingEARProjects((IProject)ownerComponent.getProject());
            if (earProjects.length > 0) {
                String ejbClientJarName;
                IProject earProject = earProjects[0];
                IVirtualComponent earComponent = ComponentCore.createComponent((IProject)earProject);
                IVirtualReference[] earRefs = earComponent.getReferences();
                IVirtualComponent requiredComponent = targetEJBComponent;
                if (J2EEProjectUtilities.isEJBComponent((IVirtualComponent)targetEJBComponent) && (ejbClientJarName = EJBReferenceCreationOperation.getClientJarName(targetEJBComponent)) != null) {
                    int i2 = 0;
                    while (i2 < earRefs.length) {
                        String archiveName = earRefs[i2].getArchiveName();
                        if (archiveName != null && archiveName.equals(ejbClientJarName)) {
                            requiredComponent = earRefs[i2].getReferencedComponent();
                            int j = 0;
                            while (j < existingRefs.length) {
                                if (existingRefs[j].getReferencedComponent().equals(requiredComponent)) {
                                    return;
                                }
                                ++j;
                            }
                            break;
                        }
                        ++i2;
                    }
                }
                int i3 = 0;
                while (i3 < earRefs.length) {
                    if (earRefs[i3].getReferencedComponent().equals(requiredComponent)) {
                        String newClasspathEntry = earRefs[i3].getArchiveName();
                        ArchiveManifest manifest = org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities.readManifest((IProject)ownerComponent.getProject());
                        String existingClasspath = manifest.getClassPath();
                        if (existingClasspath != null) {
                            StringTokenizer strTok = new StringTokenizer(existingClasspath);
                            while (strTok.hasMoreTokens()) {
                                if (!strTok.nextToken().equals(newClasspathEntry)) continue;
                                return;
                            }
                        }
                        existingClasspath = existingClasspath == null ? newClasspathEntry : String.valueOf(existingClasspath) + " " + newClasspathEntry;
                        manifest.setClassPath(existingClasspath);
                        try {
                            org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities.writeManifest((IProject)ownerComponent.getProject(), (ArchiveManifest)manifest);
                        }
                        catch (IOException e) {
                            J2eePlugin.logError(e);
                        }
                        return;
                    }
                    ++i3;
                }
            }
        }
    }

    private void setUpDataForCommand() {
        String ownerProjName = this.operationDataModel.getStringProperty("ArtifactEditOperationDataModel.PROJECT_NAME");
        this.ownerProject = ProjectUtilities.getProject((String)ownerProjName);
        this.targetEJBComponent = (IVirtualComponent)this.operationDataModel.getProperty("EJBReferenceDataModel.TARGET_COMPONENT");
        this.refName = this.operationDataModel.getStringProperty("ReferenceDataModel.REF_NAME");
        this.refType = this.operationDataModel.getStringProperty("EJBReferenceDataModel.REF_TYPE");
        if (!this.operationDataModel.getBooleanProperty("EJBReferenceDataModel.TARGET_IN_DIFFERENT_EAR")) {
            this.refLink = this.operationDataModel.getStringProperty("EJBReferenceDataModel.LINK");
        }
        this.refHome = this.operationDataModel.getStringProperty("EJBReferenceDataModel.HOME_INTERFACE");
        this.refRemote = this.operationDataModel.getStringProperty("EJBReferenceDataModel.REMOTE_INTERACE");
        this.des = this.operationDataModel.getStringProperty("ReferenceDataModel.DESCRIPTION");
    }
}

