/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.reference;

import com.ibm.etools.j2ee.common.operations.ModelModifierOperation;
import com.ibm.etools.j2ee.reference.EJB3ServiceReferenceDataModel;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jst.j2ee.client.internal.impl.ClientFactoryImpl;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.webservices.WebServiceClientGenerator;
import org.eclipse.jst.j2ee.internal.webservices.WebServicesClientDataHelper;
import org.eclipse.jst.j2ee.internal.webservices.WebServicesClientDataRegistry;
import org.eclipse.jst.javaee.core.Description;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.PortComponentRef;
import org.eclipse.jst.javaee.core.ServiceRef;
import org.eclipse.jst.javaee.core.internal.metadata.JavaeePackage;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.javaee.ejb.EntityBean;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;
import org.eclipse.wst.server.core.IRuntime;

public class EJB3ServiceReferenceCreationOperation
extends ModelModifierOperation {
    EJB3ServiceReferenceDataModel dataModel;
    ServiceRef ref;

    public EJB3ServiceReferenceCreationOperation(EJB3ServiceReferenceDataModel dataModel) {
        super(dataModel);
        this.dataModel = dataModel;
    }

    @Override
    protected void addHelpers() {
        WebServiceClientGenerator actualGen = this.getWebServiceClientGenerator();
        if (actualGen != null) {
            actualGen.genWebServiceClientArtifacts((WebServicesClientDataHelper)this.dataModel);
        }
        if (!this.dataModel.didGenDescriptors()) {
            this.modifier.addHelper(this.createHelpers());
        }
        if (actualGen != null) {
            this.createPortCompRefHelpers();
        }
    }

    protected WebServiceClientGenerator getWebServiceClientGenerator() {
        List generators = WebServicesClientDataRegistry.getInstance().getWSClientGeneratorExtensions();
        WebServiceClientGenerator actualGen = null;
        IRuntime runtime = null;
        try {
            runtime = J2EEProjectUtilities.getServerRuntime((IProject)this.dataModel.getTargetProject());
        }
        catch (Exception exception) {}
        if (runtime == null) {
            return null;
        }
        String serverTargetID = runtime.getRuntimeType().getId();
        int i = 0;
        while (i < generators.size()) {
            WebServiceClientGenerator gen = (WebServiceClientGenerator)generators.get(i);
            if (gen.isRuntimeSupported(serverTargetID)) {
                if (serverTargetID.equals(WebServiceClientGenerator.GENERIC_J2EE_CONTAINER) && this.dataModel.getDeploymentDescriptorType() != 4) break;
                actualGen = gen;
                break;
            }
            ++i;
        }
        return actualGen;
    }

    public ModifierHelper createHelpers() {
        if (this.dataModel == null) {
            throw new NullPointerException();
        }
        ModifierHelper helper = null;
        this.ref = JavaeeFactory.eINSTANCE.createServiceRef();
        helper = new ModifierHelper();
        EObject owner = (EObject)this.dataModel.getProperty("ReferenceDataModel.OWNER");
        switch (this.dataModel.getDeploymentDescriptorType()) {
            case 1: {
                helper.setFeature((EStructuralFeature)ClientFactoryImpl.getPackage().getApplicationClient_ServiceRefs());
                helper.setOwner(owner);
                Description descriptionObj = JavaeeFactory.eINSTANCE.createDescription();
                descriptionObj.setValue(this.dataModel.getStringProperty("ReferenceDataModel.DESCRIPTION").trim());
                this.ref.getDescriptions().add(descriptionObj);
                break;
            }
            case 3: {
                if (this.dataModel.getProperty("ReferenceDataModel.OWNER") instanceof EntityBean) {
                    helper.setFeature((EStructuralFeature)EjbFactory.eINSTANCE.getEjbPackage().getEntityBean_ServiceRefs());
                } else if (this.dataModel.getProperty("ReferenceDataModel.OWNER") instanceof SessionBean) {
                    helper.setFeature((EStructuralFeature)EjbFactory.eINSTANCE.getEjbPackage().getSessionBean_ServiceRefs());
                } else if (this.dataModel.getProperty("ReferenceDataModel.OWNER") instanceof MessageDrivenBean) {
                    helper.setFeature((EStructuralFeature)EjbFactory.eINSTANCE.getEjbPackage().getMessageDrivenBean_ServiceRefs());
                }
                helper.setOwner(owner);
                Description descriptionObj = JavaeeFactory.eINSTANCE.createDescription();
                descriptionObj.setValue(this.dataModel.getStringProperty("ReferenceDataModel.DESCRIPTION"));
                this.ref.getDescriptions().add(descriptionObj);
                break;
            }
            case 4: {
                if (this.dataModel.getProperty("ReferenceDataModel.OWNER") instanceof EntityBean) {
                    helper.setFeature((EStructuralFeature)EjbFactory.eINSTANCE.getEjbPackage().getEntityBean_ServiceRefs());
                } else if (this.dataModel.getProperty("ReferenceDataModel.OWNER") instanceof SessionBean) {
                    helper.setFeature((EStructuralFeature)EjbFactory.eINSTANCE.getEjbPackage().getSessionBean_ServiceRefs());
                } else if (this.dataModel.getProperty("ReferenceDataModel.OWNER") instanceof MessageDrivenBean) {
                    helper.setFeature((EStructuralFeature)EjbFactory.eINSTANCE.getEjbPackage().getMessageDrivenBean_ServiceRefs());
                } else if (this.dataModel.getProperty("ReferenceDataModel.OWNER") instanceof WebApp) {
                    helper.setFeature((EStructuralFeature)WebFactory.eINSTANCE.getWebPackage().getWebApp_ServiceRefs());
                }
                helper.setOwner(owner);
                Description descriptionObj = JavaeeFactory.eINSTANCE.createDescription();
                descriptionObj.setValue(this.dataModel.getStringProperty("ReferenceDataModel.DESCRIPTION").trim());
                this.ref.getDescriptions().add(descriptionObj);
            }
        }
        this.ref.setServiceRefName(this.dataModel.getStringProperty("ReferenceDataModel.REF_NAME").trim());
        this.ref.setServiceInterface(this.dataModel.getServiceInterfaceName());
        Path wsdlPath = new Path(this.dataModel.getOutputWSDLFileName().trim());
        this.ref.setWsdlFile(wsdlPath.removeFirstSegments(2).toString());
        if (this.dataModel.getStringProperty("ServiceReferenceDataModel.JAX_RPC_MAPPING_FILE") != null && !this.dataModel.getStringProperty("ServiceReferenceDataModel.JAX_RPC_MAPPING_FILE").equals("")) {
            this.ref.setJaxrpcMappingFile(this.dataModel.getStringProperty("ServiceReferenceDataModel.JAX_RPC_MAPPING_FILE").trim());
        }
        QName qName = ((CommonPackage)EPackage.Registry.INSTANCE.getEPackage("common.xmi")).getCommonFactory().createQName();
        qName.setValues("prefix", this.dataModel.getStringProperty("ServiceReferenceDataModel.QNAME_NAMESPACE_URI"), this.dataModel.getStringProperty("ServiceReferenceDataModel.QNAME_lOCAL_PART"));
        this.ref.setServiceQname((Object)qName);
        helper.setValue((Object)this.ref);
        return helper;
    }

    public void createPortCompRefHelpers() {
        ModifierHelper helper = null;
        if (this.dataModel != null) {
            helper = new ModifierHelper();
            String[] serEndpoints = this.dataModel.getServiceEndpointInterfaceNames();
            if (serEndpoints == null || serEndpoints.length == 0) {
                return;
            }
            int i = 0;
            while (i < serEndpoints.length) {
                PortComponentRef portCompRef = JavaeeFactory.eINSTANCE.createPortComponentRef();
                helper.setOwner((EObject)this.ref);
                String serviceEndpointInterface = serEndpoints[i];
                portCompRef.setServiceEndpointInterface(((JavaClass)JavaRefFactory.eINSTANCE.reflectType(serviceEndpointInterface, (EObject)this.dataModel.getProperty("ReferenceDataModel.OWNER"))).getName());
                helper.setFeature((EStructuralFeature)JavaeePackage.eINSTANCE.getServiceRef_PortComponentRefs());
                helper.setValue((Object)portCompRef);
                this.modifier.addHelper(helper);
                ++i;
            }
        }
    }
}

