/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.project;

import com.ibm.etools.j2ee.internal.project.EARNatureRuntime;
import com.ibm.etools.j2ee.internal.project.J2EEModuleWorkbenchURIConverterImpl;
import com.ibm.etools.j2ee.internal.project.J2EENature;
import com.ibm.etools.j2ee.internal.project.J2EEWorkbenchURIConverterImpl;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.adapters.jdom.JavaJDOMAdapterFactory;
import org.eclipse.jem.internal.adapters.jdom.JavaReflectionSynchronizer;
import org.eclipse.jem.internal.plugin.IJavaProjectInfo;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverter;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.internal.project.J2EEJavaProjectInfo;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;

public abstract class J2EEModuleNature
extends J2EENature {
    private static final IPath APP_CLIENT_DD_PATH = new Path("META-INF/application-client.xml");
    private static final IPath EJBJAR_DD_PATH = new Path("META-INF/ejb-jar.xml");
    private static final IPath RAR_DD_PATH = new Path("META-INF/ra.xml");

    public abstract Module createNewModule();

    public IResource getBinaryProjectInputJARResource() {
        J2EEModuleWorkbenchURIConverterImpl conv = (J2EEModuleWorkbenchURIConverterImpl)this.getJ2EEWorkbenchURIConverter();
        IPath aPath = null;
        if (conv != null) {
            aPath = conv.getInputJARProjectRelativePath();
        }
        if (aPath != null) {
            return this.getProject().getFile(aPath);
        }
        return null;
    }

    public boolean canBeBinary() {
        return false;
    }

    @Override
    protected void createFolders() throws CoreException {
        IPath sourcePath = JemProjectUtilities.getSourcePathOrFirst((IProject)this.getProject(), null);
        if (sourcePath != null) {
            this.createFolder(sourcePath.toString());
            IContainer container = JemProjectUtilities.getJavaProjectOutputContainer((IProject)this.getProject());
            if (container != null && container.getType() == 2) {
                this.createFolder(container.getProjectRelativePath().toString());
            }
        }
    }

    public String computeModuleAbsolutePath() {
        return this.computeModuleAbsoluteLocation().toOSString();
    }

    public IPath computeModuleAbsoluteLocation() {
        IPath location = null;
        J2EEModuleWorkbenchURIConverterImpl conv = (J2EEModuleWorkbenchURIConverterImpl)this.getJ2EEWorkbenchURIConverter();
        if (conv != null) {
            location = conv.getInputJARLocation();
        }
        if (location != null) {
            return location;
        }
        return this.getModuleServerRoot().getLocation();
    }

    public void recomputeBinaryProject() {
        J2EEModuleWorkbenchURIConverterImpl conv = (J2EEModuleWorkbenchURIConverterImpl)this.getJ2EEWorkbenchURIConverter();
        if (conv != null) {
            conv.recomputeInputJARLocation();
        }
    }

    public static String getModuleAbsolutePath(IProject aJ2EEProject) {
        J2EEModuleNature aNature = (J2EEModuleNature)J2EEModuleNature.getRegisteredRuntime(aJ2EEProject);
        return aNature == null ? null : aNature.computeModuleAbsolutePath();
    }

    public IContainer getEMFRoot() {
        IPackageFragmentRoot[] srcContainers = J2EEProjectUtilities.getSourceContainers((IProject)this.project);
        if (srcContainers.length == 1) {
            try {
                return (IContainer)srcContainers[0].getCorrespondingResource();
            }
            catch (JavaModelException javaModelException) {
                return JemProjectUtilities.getSourceFolderOrFirst((IProject)this.project, null);
            }
        }
        Path metaPath = new Path(this.getMetaPathKey());
        int i = 0;
        while (i < srcContainers.length) {
            try {
                IFolder metaInf;
                IContainer srcContainer = (IContainer)srcContainers[i].getCorrespondingResource();
                if (srcContainer != null && srcContainer.exists() && (metaInf = srcContainer.getFolder((IPath)metaPath)) != null && metaInf.exists()) {
                    IFile deploymentDescriptor = null;
                    switch (this.getDeploymentDescriptorType()) {
                        case 1: {
                            deploymentDescriptor = srcContainer.getFile(APP_CLIENT_DD_PATH);
                            break;
                        }
                        case 3: {
                            deploymentDescriptor = srcContainer.getFile(EJBJAR_DD_PATH);
                            break;
                        }
                        case 5: {
                            deploymentDescriptor = srcContainer.getFile(RAR_DD_PATH);
                            break;
                        }
                    }
                    if (deploymentDescriptor != null && deploymentDescriptor.exists()) {
                        return srcContainer;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        return JemProjectUtilities.getSourceFolderOrFirst((IProject)this.project, null);
    }

    @Override
    protected void primConfigure() throws CoreException {
        super.primConfigure();
        ProjectUtilities.addToBuildSpec((String)"org.eclipse.jst.j2ee.LibCopyBuilder", (IProject)this.project);
    }

    public CommonarchiveFactory getCommonArchiveFactory() {
        return CommonarchiveFactory.eINSTANCE;
    }

    public boolean isBinaryProject() {
        J2EEModuleWorkbenchURIConverterImpl conv = (J2EEModuleWorkbenchURIConverterImpl)this.getJ2EEWorkbenchURIConverter();
        if (conv == null) {
            return false;
        }
        return conv.isBinary();
    }

    @Override
    protected J2EEWorkbenchURIConverterImpl getJ2EEWorkbenchURIConverter() {
        WorkbenchURIConverter conv = this.getWorkbenchURIConverter();
        if (conv instanceof J2EEModuleWorkbenchURIConverterImpl) {
            return (J2EEModuleWorkbenchURIConverterImpl)conv;
        }
        return null;
    }

    public void initializeFromInfo(IJavaProjectInfo info) throws CoreException {
        J2EEJavaProjectInfo j2eeInfo = (J2EEJavaProjectInfo)info;
        JemProjectUtilities.updateClasspath((IJavaProject)j2eeInfo.getJavaProject());
    }

    public EARNatureRuntime[] getReferencingEARProjects() {
        List earProjects = EARNatureRuntime.getAllEARProjectsInWorkbench();
        ArrayList<EARNatureRuntime> result = new ArrayList<EARNatureRuntime>();
        int i = 0;
        while (i < earProjects.size()) {
            IProject earProject = (IProject)earProjects.get(i);
            EARNatureRuntime earNature = EARNatureRuntime.getRuntime(earProject);
            if (earNature.getModule(this.getProject()) != null) {
                result.add(earNature);
            }
            ++i;
        }
        return result.toArray(new EARNatureRuntime[result.size()]);
    }

    public String getModuleUriInFirstEAR() {
        EARNatureRuntime[] earNatures = this.getReferencingEARProjects();
        int i = 0;
        while (i < earNatures.length) {
            EARNatureRuntime earNature = earNatures[i];
            Module mod = earNature.getModule(this.getProject());
            if (mod != null && mod.getUri() != null && mod.getUri().length() > 0) {
                return mod.getUri();
            }
            ++i;
        }
        return null;
    }

    public IFolder getSourceFolder() {
        IContainer output = JemProjectUtilities.getJavaProjectOutputContainer((IProject)this.getProject());
        List sources = JemProjectUtilities.getSourceContainers((IProject)this.getProject());
        if (sources == null || sources.isEmpty() || ((IContainer)sources.get(0)).getType() != 2) {
            return null;
        }
        if (output != null && sources.contains(output)) {
            return (IFolder)output;
        }
        int i = 0;
        while (i < sources.size()) {
            IFolder source = (IFolder)sources.get(i);
            if (source.getFile(this.getDeploymentDescriptorURI()).isAccessible()) {
                return source;
            }
            ++i;
        }
        return (IFolder)sources.get(0);
    }

    @Override
    protected J2EEWorkbenchURIConverterImpl initializeWorbenchURIConverter(ProjectResourceSet set) {
        return new J2EEModuleWorkbenchURIConverterImpl(this, set.getSynchronizer());
    }

    @Override
    protected void addAdapterFactories(ResourceSet aSet) {
        this.addJavaReflectionAdapterFactories(aSet);
    }

    protected void addJavaReflectionAdapterFactories(ResourceSet aSet) {
        AdapterFactory factory;
        EList factories = aSet.getAdapterFactories();
        if (!factories.isEmpty() && (factory = EcoreUtil.getAdapterFactory((List)factories, (Object)"JavaReflection")) != null) {
            factories.remove(factory);
        }
        JavaJDOMAdapterFactory jdomFactory = new JavaJDOMAdapterFactory(JemProjectUtilities.getJavaProject((IProject)this.project)){

            protected void initializeSynchronizer() {
                this.synchronizer = new JavaReflectionSynchronizer(this){

                    protected void processJavaElementChanged(ICompilationUnit element, IJavaElementDelta delta) {
                        switch (delta.getKind()) {
                            case 4: {
                                if ((delta.getFlags() & 0x40000) == 0) break;
                                this.flush(element);
                                break;
                            }
                            case 1: 
                            case 2: {
                                this.disAssociateSourcePlusInner(this.getFullNameFromElement(element));
                            }
                        }
                    }
                };
            }
        };
        factories.add(jdomFactory);
    }
}

