/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.project;

import com.ibm.etools.j2ee.internal.project.EAREditModel;
import com.ibm.etools.j2ee.internal.project.IEARNatureConstants;
import com.ibm.etools.j2ee.internal.project.J2EEEditModel;
import com.ibm.etools.j2ee.internal.project.J2EENature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.ModuleMapping;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.UtilityJARMapping;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EECreationResourceHandler;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;

public class EARNatureRuntime
extends J2EENature {
    private static final String EAR_PROJECT_12_OVERLAY = "1_2_ovr";
    private static final String EAR_PROJECT_13_OVERLAY = "1_3_ovr";
    private static final String EAR_PROJECT_14_OVERLAY = "1_4_ovr";
    protected static final String ALT_ROOT_EDEFAULT = null;
    public static Map EMPTY_MAP = new HashMap(0);

    @Override
    public Archive asArchive() throws OpenFailureException {
        return null;
    }

    @Override
    public Archive asArchive(boolean shouldExportSource) throws OpenFailureException {
        return null;
    }

    @Override
    public int getJ2EEVersion() {
        return this.getModuleVersion();
    }

    protected boolean projectIsJavaProject() {
        return false;
    }

    @Override
    protected EditModel createCacheEditModel() {
        return this.getEarEditModelForRead((Object)this);
    }

    @Override
    protected void createFolders() throws CoreException {
        this.createFolder(this.getMetaPath());
    }

    public Module createNewModule() {
        return null;
    }

    public static List getAllEARProjectsInWorkbench() {
        List<IProject> allProjects = Arrays.asList(J2EEPlugin.getWorkspace().getRoot().getProjects());
        ArrayList<IProject> earProjects = new ArrayList<IProject>();
        int i = 0;
        while (i < allProjects.size()) {
            IProject p = allProjects.get(i);
            if (p.exists() && p.isOpen() && EARNatureRuntime.hasRuntime(p)) {
                earProjects.add(p);
            }
            ++i;
        }
        return earProjects;
    }

    public Application getApplication() {
        return ((EAREditModel)this.getCacheEditModel()).getApplication();
    }

    public Resource getApplicationXmiResource() {
        return this.getResource(URI.createURI((String)"META-INF/application.xml"));
    }

    public String getClassPathKey() {
        return null;
    }

    @Override
    public String getEditModelKey() {
        return "org.eclipse.jst.j2ee.application.editModel";
    }

    public EAREditModel getEarEditModelForRead(Object accessorKey) {
        return (EAREditModel)this.getEditModelForRead("org.eclipse.jst.j2ee.application.editModel", accessorKey);
    }

    public EAREditModel getEarEditModelForWrite(Object accessorKey) {
        return (EAREditModel)this.getEditModelForWrite("org.eclipse.jst.j2ee.application.editModel", accessorKey);
    }

    public Resource getEjbXmiResource() {
        return this.getResource(URI.createURI((String)"META-INF/ejb-jar.xml"));
    }

    @Override
    public String getMetaPathKey() {
        return "META-INF";
    }

    public Module getModule(IProject referencedProject) {
        EAREditModel model = (EAREditModel)this.getCacheEditModel();
        ModuleMapping map = model.getModuleMapping(referencedProject);
        if (map != null) {
            return map.getModule();
        }
        return null;
    }

    public IProject getMappedProject(String uri) {
        EAREditModel model = (EAREditModel)this.getCacheEditModel();
        return model.getMappedProject(uri);
    }

    public J2EENature getModuleProject(Module aModule) {
        IProject aProject = this.primGetModuleProject(aModule);
        if (aProject != null) {
            return J2EENature.getRegisteredRuntime(aProject);
        }
        return null;
    }

    public J2EENature getModuleProject(String moduleURI) {
        Application dd = this.getApplication();
        return dd == null ? null : this.getModuleProject(dd.getFirstModule(moduleURI));
    }

    public String getJARUri(IProject aProject) {
        EAREditModel model = (EAREditModel)this.getCacheEditModel();
        ModuleMapping moduleMap = model.getModuleMapping(aProject);
        if (moduleMap != null) {
            Module aModule = moduleMap.getModule();
            return aModule == null ? J2EECreationResourceHandler.UNKNOWN_UI_ : aModule.getUri();
        }
        UtilityJARMapping jarMap = model.getUtilityJARMapping(aProject);
        if (jarMap != null) {
            return jarMap.getUri();
        }
        return null;
    }

    public Map getModuleProjects() {
        Application dd = this.getApplication();
        if (dd == null) {
            return EMPTY_MAP;
        }
        EList modules = this.getApplication().getModules();
        HashMap<String, J2EENature> result = new HashMap<String, J2EENature>();
        int i = 0;
        while (i < modules.size()) {
            Module m = (Module)modules.get(i);
            J2EENature nature = this.getModuleProject(m);
            result.put(m.getUri(), nature);
            ++i;
        }
        return result;
    }

    public Map getAllMappedProjects() {
        EAREditModel model = (EAREditModel)this.getCacheEditModel();
        return model.getModuleMappedProjectsAsMap();
    }

    public IContainer getEMFRoot() {
        return this.getProject();
    }

    public String getNatureID() {
        return "org.eclipse.jst.j2ee.EARNature";
    }

    protected String getPluginID() {
        return "org.eclipse.jst.j2ee";
    }

    public IProject[] getReferencedProjects() {
        try {
            return this.getProject().getReferencedProjects();
        }
        catch (CoreException coreException) {
            return new IProject[0];
        }
    }

    public static EARNatureRuntime getRuntime(IProject project) {
        return (EARNatureRuntime)EARNatureRuntime.getRuntime(project, IEARNatureConstants.NATURE_IDS);
    }

    public String getSourcePathKey() {
        return null;
    }

    public static boolean hasRuntime(IProject project) {
        return EARNatureRuntime.hasRuntime((IProject)project, (String[])IEARNatureConstants.NATURE_IDS);
    }

    public Resource makeApplicationXmiResource() {
        return this.createResource(URI.createURI((String)"META-INF/application.xml"));
    }

    public IProject primGetModuleProject(Module aModule) {
        block4: {
            try {
                if (aModule != null) break block4;
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        EAREditModel model = (EAREditModel)this.getCacheEditModel();
        ModuleMapping map = model.getModuleMapping(aModule);
        if (map != null && map.getProjectName() != null && map.getProjectName().length() > 0) {
            return J2EEPlugin.getWorkspace().getRoot().getProject(map.getProjectName());
        }
        return null;
    }

    public IStatus validateModuleProjects() {
        EAREditModel model = this.getEarEditModelForWrite((Object)this);
        try {
            if (model.isShared() && model.isDirty()) {
                String msg = EARCreationResourceHandler.getString((String)"UNSAVED_CHANGES_WARN_", (Object[])new Object[]{this.getProject().getName()});
                IStatus iStatus = J2EEPlugin.newStatus((int)2, (int)0, (String)msg, null);
                return iStatus;
            }
            String message = EARCreationResourceHandler.getString((String)"PROJECT_MAP_PROBLEMS_ERROR_", (Object[])new Object[]{this.getProject().getName()});
            Application dd = model.getApplication();
            EList modules = dd.getModules();
            boolean closedProject = false;
            int i = 0;
            while (i < modules.size()) {
                Module m = (Module)modules.get(i);
                IProject p = this.primGetModuleProject(m);
                if (p == null) {
                    Status status = new Status(4, "org.eclipse.jst.j2ee", 76, message, null);
                    return status;
                }
                if (!p.isOpen()) {
                    closedProject = true;
                }
                ++i;
            }
            if (closedProject) {
                String msg = EARCreationResourceHandler.getString((String)"MODULE_PROJECTS_CLOSED_WARN_", (Object[])new Object[]{this.getProject().getName()});
                IStatus iStatus = J2EEPlugin.newStatus((int)2, (int)0, (String)msg, null);
                return iStatus;
            }
            IStatus iStatus = J2EEPlugin.newStatus((int)0, (int)0, (String)"", null);
            return iStatus;
        }
        finally {
            model.releaseAccess((Object)this);
        }
    }

    @Override
    public String getOverlayIconName() {
        switch (this.getJ2EEVersion()) {
            case 12: {
                return EAR_PROJECT_12_OVERLAY;
            }
            case 13: {
                return EAR_PROJECT_13_OVERLAY;
            }
        }
        return EAR_PROJECT_14_OVERLAY;
    }

    @Override
    public int getDeploymentDescriptorType() {
        return 2;
    }

    protected void addJavaReflectionAdapterFactories(ResourceSet aContext) {
    }

    @Override
    public EObject getDeploymentDescriptorRoot() {
        return this.getApplication();
    }

    @Override
    protected int getVersionFromModuleFile() {
        Application ddRoot = this.getApplication();
        if (ddRoot != null) {
            return ddRoot.getVersionID();
        }
        return 14;
    }

    @Override
    public J2EEEditModel getJ2EEEditModelForRead(Object accessorKey) {
        return this.getEarEditModelForRead(accessorKey);
    }

    @Override
    public J2EEEditModel getJ2EEEditModelForWrite(Object accessorKey) {
        return this.getEarEditModelForWrite(accessorKey);
    }
}

