/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.java.codegen;

import com.ibm.etools.j2ee.internal.codegen.GenerationBuffer;
import com.ibm.etools.j2ee.internal.java.codegen.IJavaMergeStrategy;
import com.ibm.etools.j2ee.internal.java.codegen.JavaCodeGenResourceHandler;
import com.ibm.etools.j2ee.internal.java.codegen.JavaMemberMerglet;
import com.ibm.etools.j2ee.internal.java.codegen.MergeException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.IDOMMember;
import org.eclipse.jdt.core.jdom.IDOMMethod;

public class JavaMethodMerglet
extends JavaMemberMerglet {
    private static final String METHOD_COLLISION_INFORMATIONAL = JavaCodeGenResourceHandler.The_method_will_not_gen_INFO_;
    private static final String METHOD_NOT_DELETED_INFORMATIONAL = JavaCodeGenResourceHandler.The_method_will_not_del_INFO_;
    private static final String ABSTRACT_METHOD_BODY = ";";
    private String[] fNoMergeExceptionNames = null;

    public JavaMethodMerglet(IJavaMergeStrategy jms) {
        super(jms);
    }

    protected String getBody(IMethod theMethod) throws MergeException {
        try {
            String body = ABSTRACT_METHOD_BODY;
            String source = theMethod.getSource();
            int sourceIndex = theMethod.getNameRange().getOffset() - theMethod.getSourceRange().getOffset();
            sourceIndex = source.indexOf(123, sourceIndex);
            if (sourceIndex >= 0) {
                --sourceIndex;
                while (sourceIndex >= 0 && Character.isWhitespace(source.charAt(sourceIndex))) {
                    --sourceIndex;
                }
                body = source.substring(++sourceIndex);
            }
            return body;
        }
        catch (JavaModelException exc) {
            throw new MergeException((Exception)((Object)exc));
        }
    }

    @Override
    protected Object getMemberCollisionReason() {
        return METHOD_COLLISION_INFORMATIONAL;
    }

    @Override
    protected Object getMemberNotDeletedReason() {
        return METHOD_NOT_DELETED_INFORMATIONAL;
    }

    public String[] getNoMergeExceptionNames() {
        return this.fNoMergeExceptionNames;
    }

    @Override
    protected String getReadableIdFor(IMember member) throws MergeException {
        try {
            return Signature.toString((String)((IMethod)member).getSignature(), (String)member.getElementName(), null, (boolean)false, (boolean)true);
        }
        catch (JavaModelException exc) {
            throw new MergeException((Exception)((Object)exc));
        }
    }

    protected boolean injectUserCode(String name, String oldSource, StringBuffer mergedSource) throws RuntimeException {
        GenerationBuffer genBuf = new GenerationBuffer();
        genBuf.format(this.getJavaMergeStrategy().getUserCodeBeginTemplate(), new String[]{name});
        String codePointTag = genBuf.toString();
        int oldUserCodePos = oldSource.indexOf(codePointTag);
        boolean merged = false;
        if (oldUserCodePos >= 0) {
            int endOldUserCodePos = oldSource.indexOf(this.getJavaMergeStrategy().getUserCodeEnd(), oldUserCodePos += codePointTag.length());
            if (endOldUserCodePos < oldUserCodePos) {
                throw new RuntimeException();
            }
            String oldUserCode = oldSource.substring(oldUserCodePos, endOldUserCodePos);
            int i = 0;
            while (!merged && i < oldUserCode.length()) {
                merged = !Character.isWhitespace(oldUserCode.charAt(i));
                ++i;
            }
            if (merged) {
                mergedSource.append(oldUserCode);
            }
        }
        return merged;
    }

    protected boolean matchBody(IMethod collisionMethod, IDOMMethod newMethod) throws MergeException {
        return this.getBody(collisionMethod).trim().equals(newMethod.getBody().trim());
    }

    protected boolean mergeBody(IMethod oldMethod, IDOMMethod newMethod) throws MergeException {
        return this.mergeUserCode(oldMethod, newMethod);
    }

    protected boolean mergeExceptions(IMethod oldMethod, IDOMMethod newMethod) throws MergeException {
        boolean merged = false;
        try {
            String[] oldExceptionNames = this.makeReadable(oldMethod.getExceptionTypes());
            if (oldExceptionNames != null && oldExceptionNames.length != 0) {
                String[] newExceptionNames = newMethod.getExceptions();
                IType oldType = oldMethod.getDeclaringType();
                String[] noMergeExceptionNames = this.getNoMergeExceptionNames();
                int i = 0;
                while (i < oldExceptionNames.length) {
                    int found = this.findTypeNameMatch(oldType, oldExceptionNames[i], newExceptionNames);
                    if (found < 0 && (found = this.findTypeNameMatch(oldType, oldExceptionNames[i], noMergeExceptionNames)) < 0) {
                        newMethod.addException(oldExceptionNames[i]);
                        merged = true;
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException exc) {
            throw new MergeException((Exception)((Object)exc));
        }
        return merged;
    }

    @Override
    protected boolean mergeMember(IMember oldMember, IDOMMember newMember) throws MergeException {
        boolean merged = this.mergeExceptions((IMethod)oldMember, (IDOMMethod)newMember);
        merged |= this.mergeBody((IMethod)oldMember, (IDOMMethod)newMember);
        return merged |= this.mergeReturnTypes((IMethod)oldMember, (IDOMMethod)newMember);
    }

    protected boolean mergeReturnTypes(IMethod oldMethod, IDOMMethod newMethod) throws MergeException {
        try {
            String oldName = this.makeReadable(oldMethod.getReturnType());
            String newName = newMethod.getReturnType();
            return !this.matchTypeNames(oldMethod.getDeclaringType(), oldName, newName);
        }
        catch (JavaModelException exc) {
            throw new MergeException((Exception)((Object)exc));
        }
    }

    protected boolean mergeUserCode(IMethod oldMethod, IDOMMethod newMethod) throws MergeException {
        boolean merged = false;
        try {
            String oldSource = this.getBody(oldMethod);
            String newSource = newMethod.getBody();
            StringBuffer mergedSource = new StringBuffer(newSource.length() * 2);
            int namePos = 0;
            int nameEnd = 0;
            int doneSourcePos = 0;
            String name = null;
            boolean mergedThisPoint = false;
            String userCodeBegin = this.getJavaMergeStrategy().getUserCodeBegin();
            int userCodePos = newSource.indexOf(userCodeBegin);
            while (userCodePos >= 0) {
                namePos = newSource.indexOf(123, userCodePos) + 1;
                if (namePos < userCodePos) {
                    throw new RuntimeException();
                }
                nameEnd = newSource.indexOf(125, namePos);
                if (nameEnd < namePos) {
                    throw new RuntimeException();
                }
                name = newSource.substring(namePos, nameEnd);
                userCodePos = nameEnd + 1;
                mergedSource.append(newSource.substring(doneSourcePos, userCodePos));
                doneSourcePos = userCodePos;
                mergedThisPoint = this.injectUserCode(name, oldSource, mergedSource);
                if (mergedThisPoint) {
                    doneSourcePos = newSource.indexOf(this.getJavaMergeStrategy().getUserCodeEnd(), doneSourcePos);
                    if (doneSourcePos == -1) {
                        throw new RuntimeException();
                    }
                    merged = true;
                }
                userCodePos = newSource.indexOf(userCodeBegin, doneSourcePos);
            }
            if (merged) {
                mergedSource.append(newSource.substring(doneSourcePos));
                newMethod.setBody(mergedSource.toString());
            }
        }
        catch (RuntimeException runtimeException) {
            merged = false;
        }
        return merged;
    }

    @Override
    protected boolean needToGenerate(IMember collisionMember, IDOMMember newMember) throws MergeException {
        boolean needToGenerate = false;
        IMethod collisionMethod = (IMethod)collisionMember;
        IDOMMethod newMethod = (IDOMMethod)newMember;
        try {
            needToGenerate = collisionMethod.getFlags() != newMember.getFlags();
            IType collisionType = null;
            if (!needToGenerate) {
                collisionType = collisionMethod.getDeclaringType();
                boolean bl = needToGenerate = !this.matchTypeNames(collisionType, this.makeReadable(collisionMethod.getReturnType()), newMethod.getReturnType());
            }
            if (!needToGenerate) {
                boolean bl = needToGenerate = !this.matchTypeNames(collisionType, this.makeReadable(collisionMethod.getExceptionTypes()), newMethod.getExceptions());
            }
            if (!needToGenerate) {
                needToGenerate = !this.matchBody(collisionMethod, newMethod);
            }
        }
        catch (JavaModelException exc) {
            throw new MergeException((Exception)((Object)exc));
        }
        return needToGenerate;
    }

    public void setNoMergeExceptionNames(String[] newNoMergeExceptionNames) {
        this.fNoMergeExceptionNames = newNoMergeExceptionNames;
    }
}

