/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.java.codegen;

import com.ibm.etools.j2ee.internal.java.codegen.IJavaMergeStrategy;
import com.ibm.etools.j2ee.internal.java.codegen.IJavaMerglet;
import com.ibm.etools.j2ee.internal.java.codegen.MergeException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public abstract class JavaMerglet
implements IJavaMerglet {
    private boolean fPreserveNonCollisionOldMembers = false;
    private boolean fIncrementalPreserveCollision = false;
    private IJavaMergeStrategy fJavaMergeStrategy = null;

    public JavaMerglet(IJavaMergeStrategy jms) {
        this.fJavaMergeStrategy = jms;
        this.fPreserveNonCollisionOldMembers = jms.isDefaultPreserveNonCollisionOldMembers();
        this.fIncrementalPreserveCollision = jms.isDefaultIncrementalPreserveCollision();
    }

    protected int findTypeNameMatch(IType type, String typeName1, String[] typeName2s) throws MergeException {
        if (typeName2s == null || typeName2s.length == 0) {
            return -1;
        }
        int index = -1;
        boolean found = false;
        String tn1 = typeName1.trim();
        int i = 0;
        while (!found && i < typeName2s.length) {
            found = this.matchTypeNames(type, tn1, typeName2s[i]);
            if (found) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    protected IJavaMergeStrategy getJavaMergeStrategy() {
        return this.fJavaMergeStrategy;
    }

    @Override
    public boolean isIncrementalPreserveCollision() {
        return this.fIncrementalPreserveCollision;
    }

    @Override
    public boolean isPreserveNonCollisionOldMembers() {
        return this.fPreserveNonCollisionOldMembers;
    }

    protected String[] makeReadable(String[] sigs) {
        if (sigs == null) {
            return null;
        }
        String[] names = new String[sigs.length];
        int i = 0;
        while (i < sigs.length) {
            names[i] = this.makeReadable(sigs[i]);
            ++i;
        }
        return names;
    }

    protected String makeReadable(String sig) {
        if (sig == null) {
            return null;
        }
        return Signature.toString((String)sig);
    }

    protected boolean matchTypeNames(IType type, String[] typeName1s, String[] typeName2s) throws MergeException {
        boolean match;
        if (typeName1s == null || typeName2s == null) {
            if (typeName1s == typeName2s) {
                return true;
            }
            if (typeName1s == null) {
                return typeName2s.length == 0;
            }
            return typeName1s.length == 0;
        }
        boolean bl = match = typeName1s.length == typeName2s.length;
        if (match) {
            String[] typeName2sCopy = new String[typeName2s.length];
            int i = 0;
            while (i < typeName2s.length) {
                typeName2sCopy[i] = typeName2s[i];
                ++i;
            }
            i = 0;
            while (match && i < typeName1s.length) {
                int found = this.findTypeNameMatch(type, typeName1s[i], typeName2sCopy);
                if (found >= 0) {
                    typeName2sCopy[found] = null;
                } else {
                    match = false;
                }
                ++i;
            }
        }
        return match;
    }

    protected boolean matchTypeNames(IType type, String typeName1, String typeName2) throws MergeException {
        if (typeName1 == null || typeName2 == null) {
            return typeName1 == typeName2;
        }
        boolean result = false;
        String tn1 = typeName1.trim();
        String tn2 = typeName2.trim();
        if (!(tn1.indexOf(46) == -1 ^ tn2.indexOf(46) == -1)) {
            result = tn1.equals(tn2);
        } else {
            String qualifiedName = null;
            String simpleName = null;
            if (tn1.indexOf(46) == -1) {
                qualifiedName = tn2;
                simpleName = tn1;
            } else {
                qualifiedName = tn1;
                simpleName = tn2;
            }
            result = qualifiedName.equals(this.resolveSimpleTypeName(type, simpleName));
        }
        return result;
    }

    protected String resolveSimpleTypeName(IType type, String simpleName) throws MergeException {
        String[][] result = null;
        try {
            result = type.resolveType(simpleName);
        }
        catch (JavaModelException exc) {
            throw new MergeException((Exception)((Object)exc));
        }
        if (result == null) {
            return simpleName;
        }
        return String.valueOf(result[0][0]) + "." + result[0][1];
    }

    @Override
    public void setIncrementalPreserveCollision(boolean newIncrementalPreserveCollision) {
        this.fIncrementalPreserveCollision = newIncrementalPreserveCollision;
    }

    @Override
    public void setPreserveNonCollisionOldMembers(boolean newPreserveNonCollisionOldMembers) {
        this.fPreserveNonCollisionOldMembers = newPreserveNonCollisionOldMembers;
    }

    public boolean wasGenerated(String source, int endCheckIndex) {
        return this.getJavaMergeStrategy().wasGenerated(source, endCheckIndex);
    }

    public boolean wasGenerated(IMember member) throws MergeException {
        return this.getJavaMergeStrategy().wasGenerated(member);
    }
}

