/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.codegen;

import com.ibm.etools.j2ee.internal.codegen.DictionaryExtensionReader;
import com.ibm.etools.j2ee.internal.codegen.GeneratorDictionary;
import com.ibm.etools.j2ee.internal.codegen.GeneratorDictionaryLookUp;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.registry.RegistryCompatibilityHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;

public class DictionaryExtensionRegistry {
    static final String GROUP_ID = "groupID";
    static final String BASE_DICTIONARY = "baseDictionary";
    static final String EXTENSION_DICTIONARY = "extensionDictionary";
    private static DictionaryExtensionReader reader = null;
    private static HashMap dictionaryExtMap = null;
    private static boolean extPointHasRead = false;

    public static GeneratorDictionary generateDictionary(String xmlDictionaryName, ClassLoader loader) throws FileNotFoundException {
        dictionaryExtMap = DictionaryExtensionRegistry.getDictionaryExtensions();
        if (dictionaryExtMap == null) {
            return new GeneratorDictionary(xmlDictionaryName, loader);
        }
        List extensionsList = (List)dictionaryExtMap.get(xmlDictionaryName);
        if (extensionsList == null) {
            return new GeneratorDictionary(xmlDictionaryName, loader);
        }
        GeneratorDictionaryLookUp lookUp = new GeneratorDictionaryLookUp(xmlDictionaryName, loader);
        int i = 0;
        while (i < extensionsList.size()) {
            IConfigurationElement configElement = (IConfigurationElement)extensionsList.get(i);
            String groupID = configElement.getAttribute(GROUP_ID);
            String extDictionary = configElement.getAttribute(EXTENSION_DICTIONARY);
            try {
                String namespace = configElement.getDeclaringExtension().getNamespaceIdentifier();
                Plugin plugin = RegistryCompatibilityHelper.getPluginDescriptor((String)namespace).getPlugin();
                ClassLoader extLoader = plugin.getClass().getClassLoader();
                lookUp.addDictionaryExtension(extDictionary, extLoader, groupID);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return lookUp;
    }

    private static HashMap getDictionaryExtensions() {
        if (!extPointHasRead) {
            reader = new DictionaryExtensionReader();
            reader.readRegistry();
            extPointHasRead = true;
        }
        if (reader != null) {
            return DictionaryExtensionReader.getDictionaryExtensions();
        }
        return null;
    }
}

