/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.binary;

import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.j2ee.internal.binary.IBinaryEARExpandDataModelProperties;
import com.ibm.etools.j2ee.internal.binary.J2EEUtilityJarImportDataModelProvider;
import com.ibm.etools.j2ee.internal.binary.Messages;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.j2ee.applicationclient.internal.creation.AppClientComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.internal.jca.operations.ConnectorComponentImportDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebComponentImportDataModelProvider;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class BinaryEARExpandDataModelOperation
extends AbstractDataModelOperation
implements IBinaryEARExpandDataModelProperties {
    private int WORK_TO_EXPAND_MODULE = 1000;
    private int WORK_TO_FIND_ARCHIVE = 10;
    private int WORK_TO_SETUP_IMPORT = 100;
    protected IRuntime primaryRuntime = null;

    public BinaryEARExpandDataModelOperation(IDataModel dataModel) {
        super(dataModel);
    }

    protected int computeTotalWork() {
        int totalWork = 0;
        List binaryComponents = (List)this.getDataModel().getProperty("COMPONENTS");
        totalWork += binaryComponents.size() * this.WORK_TO_FIND_ARCHIVE;
        totalWork += binaryComponents.size() * this.WORK_TO_SETUP_IMPORT;
        return totalWork += binaryComponents.size() * this.WORK_TO_EXPAND_MODULE;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        List binaryComponents = (List)this.getDataModel().getProperty("COMPONENTS");
        monitor.beginTask(Messages.BinaryEARExpandDataModelOperation_Ext, this.computeTotalWork());
        IVirtualComponent earComponent = (IVirtualComponent)this.getDataModel().getProperty("EAR_COMPONENT");
        IProject earProject = earComponent.getProject();
        try {
            IFacetedProject facetedEarProject = ProjectFacetsManager.create((IProject)earProject);
            this.primaryRuntime = facetedEarProject.getPrimaryRuntime();
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        int i = 0;
        while (i < binaryComponents.size()) {
            if (monitor.isCanceled()) break;
            int subWork = this.WORK_TO_FIND_ARCHIVE + this.WORK_TO_SETUP_IMPORT + this.WORK_TO_EXPAND_MODULE;
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, subWork);
            try {
                subMonitor.beginTask(Messages.BinaryEARExpandDataModelOperation_Ext_1, subWork);
                J2EEModuleVirtualArchiveComponent component = (J2EEModuleVirtualArchiveComponent)binaryComponents.get(i);
                IDataModel importDataModel = this.getImportModel((IVirtualComponent)component);
                subMonitor.worked(this.WORK_TO_FIND_ARCHIVE);
                subMonitor.worked(this.WORK_TO_SETUP_IMPORT);
                if (importDataModel == null) {
                    J2eePlugin.logError(new NullPointerException());
                } else {
                    try {
                        importDataModel.getDefaultOperation().execute((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, this.WORK_TO_EXPAND_MODULE), null);
                    }
                    catch (ExecutionException e) {
                        J2eePlugin.logError(e);
                    }
                }
            }
            finally {
                subMonitor.done();
            }
            ++i;
        }
        monitor.done();
        return OK_STATUS;
    }

    protected IDataModel getImportModel(IVirtualComponent component) {
        Map componentToStringMap;
        String projectName;
        JavaEEQuickPeek qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek((IVirtualComponent)component);
        IDataModel importDataModel = null;
        String primaryFacetID = null;
        switch (qp.getType()) {
            case 0: {
                importDataModel = DataModelFactory.createDataModel((IDataModelProvider)new EJBComponentImportDataModelProvider());
                primaryFacetID = "jst.ejb";
                break;
            }
            case 4: {
                importDataModel = DataModelFactory.createDataModel((IDataModelProvider)new WebComponentImportDataModelProvider());
                primaryFacetID = "jst.web";
                break;
            }
            case 3: {
                importDataModel = DataModelFactory.createDataModel((IDataModelProvider)new AppClientComponentImportDataModelProvider());
                primaryFacetID = "jst.appclient";
                break;
            }
            case 2: {
                importDataModel = DataModelFactory.createDataModel((IDataModelProvider)new ConnectorComponentImportDataModelProvider());
                primaryFacetID = "jst.connector";
                break;
            }
            default: {
                importDataModel = DataModelFactory.createDataModel((IDataModelProvider)new J2EEUtilityJarImportDataModelProvider());
                primaryFacetID = "jst.utility";
            }
        }
        IDataModel nestedProjectCreationModel = importDataModel.getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION");
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)nestedProjectCreationModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetDataModel = map.getFacetDataModel(primaryFacetID);
        facetDataModel.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR", false);
        String archiveURI = null;
        JavaEEBinaryComponentHelper helper = null;
        try {
            helper = new JavaEEBinaryComponentHelper(component);
            archiveURI = helper.getAbsolutePath().toOSString();
        }
        finally {
            if (helper != null) {
                helper.dispose();
            }
        }
        importDataModel.setProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME", (Object)archiveURI);
        if (this.primaryRuntime != null) {
            importDataModel.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)this.primaryRuntime);
        }
        if ((projectName = (String)(componentToStringMap = (Map)this.getDataModel().getProperty("PROJECT_NAME_MAP")).get(component)) != null) {
            importDataModel.setProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME", (Object)projectName);
        }
        return importDataModel;
    }
}

