/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.internal.binary;

import com.ibm.etools.j2ee.J2eePlugin;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.internal.archive.operations.J2EEComponentSaveStrategyImpl;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class BinaryEARComponentSaveStrategyImpl
extends J2EEComponentSaveStrategyImpl {
    private File componentFile = null;
    private InputStream componentInputStream = null;

    public BinaryEARComponentSaveStrategyImpl(IVirtualComponent vComponent) {
        super(vComponent);
    }

    protected void saveFiles() throws SaveFailureException {
        try {
            try {
                FileIterator iterator = this.getArchive().getFilesForSave();
                while (iterator.hasNext()) {
                    File aFile = iterator.next();
                    if (!this.shouldSave(aFile)) continue;
                    if (this.isComponentFile(aFile)) {
                        this.componentFile = aFile;
                        try {
                            this.componentInputStream = iterator.getInputStream(aFile);
                            continue;
                        }
                        catch (IOException ex) {
                            throw new SaveFailureException(aFile.getURI(), (Exception)ex);
                        }
                    }
                    this.save(aFile, iterator);
                }
                if (this.componentFile != null && this.componentInputStream != null) {
                    this.save(this.componentFile, this.componentInputStream);
                }
            }
            finally {
                if (this.componentInputStream != null) {
                    this.componentInputStream.close();
                }
            }
        }
        catch (IOException iox) {
            throw new SaveFailureException(CommonArchiveResourceHandler.Error_occurred_iterating_f_EXC_, (Exception)iox);
        }
    }

    private boolean isComponentFile(File aFile) {
        return aFile.getURI().endsWith(StructureEdit.MODULE_META_FILE_NAME);
    }

    public void save(File aFile, InputStream in) throws SaveFailureException {
        boolean saved = false;
        if (this.isComponentFile(aFile)) {
            IPath projectRelativePath = this.getOutputPathForFile(aFile);
            IFile iFile = this.vComponent.getProject().getFile(projectRelativePath);
            if (iFile.exists()) {
                StructureEdit edit = null;
                try {
                    edit = StructureEdit.getStructureEditForWrite((IProject)this.vComponent.getProject());
                    WorkbenchComponent comp = edit.getComponent();
                    Resource resource = comp.eResource();
                    boolean flushed = false;
                    if (resource.isLoaded()) {
                        flushed = true;
                        resource.unload();
                    }
                    try {
                        iFile.delete(true, null);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    saved = true;
                    super.save(aFile, in);
                    if (flushed) {
                        try {
                            resource.load(null);
                        }
                        catch (IOException e) {
                            J2eePlugin.logError(e);
                        }
                    }
                }
                finally {
                    if (edit != null) {
                        edit.dispose();
                    }
                }
            }
        }
        if (!saved) {
            super.save(aFile, in);
        }
    }
}

