/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.operations;

import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.j2ee.internal.project.EAREditModel;
import com.ibm.etools.j2ee.internal.project.EARNatureRuntime;
import com.ibm.etools.j2ee.internal.project.IEJBNatureConstants;
import com.ibm.etools.j2ee.internal.project.J2EENature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.internal.moduleextension.EarModuleManager;
import org.eclipse.jst.j2ee.internal.moduleextension.WebModuleExtension;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class ServerTargetHelper {
    public static final String JAVA_NATURE_ID = "org.eclipse.jdt.core.javanature";
    public static final String SERVER_CONTAINER = "org.eclipse.jst.server.core.container";

    public static void cleanUpNonServerTargetClasspath(IProject project) {
        List existingClasspathEntries = ServerTargetHelper.getExistingNonServerTargetClasspath(project);
        if (!existingClasspathEntries.isEmpty()) {
            ServerTargetHelper.removeNonSeverTargetClasspathEntries(project, existingClasspathEntries);
        }
    }

    public static void removeNonSeverTargetClasspathEntries(IProject project, List existingClasspathEntries) {
        try {
            JemProjectUtilities.removeFromJavaClassPath((IProject)project, (List)existingClasspathEntries);
        }
        catch (JavaModelException jme) {
            J2eePlugin.logError((CoreException)((Object)jme));
        }
    }

    public static void setNewServerTargetForEARModules(IRuntime newServerTarget, IProject project) {
        List moduleProjects = ServerTargetHelper.getAllEarModuleProjects(project);
        if (!moduleProjects.isEmpty()) {
            int i = 0;
            while (i < moduleProjects.size()) {
                IProject moduleProject = (IProject)moduleProjects.get(i);
                String j2eeType = J2EEProjectUtilities.getJ2EEProjectType((IProject)moduleProject);
                String j2eeVersion = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)moduleProject);
                if (j2eeType != null && j2eeVersion != null) {
                    IRuntime existingTargetType = ServerCore.getProjectProperties((IProject)moduleProject).getRuntimeTarget();
                    if (existingTargetType != null) {
                        if (!existingTargetType.getId().equals(newServerTarget.getId())) {
                            ServerTargetHelper.setServerTargetForModuleProject(newServerTarget, moduleProject);
                        }
                    } else {
                        ServerTargetHelper.setServerTargetForModuleProject(newServerTarget, moduleProject);
                    }
                }
                ++i;
            }
        }
    }

    public static void setServerTargetForModuleProject(IRuntime newServerTarget, IProject moduleProject) {
        ServerTargetHelper.cleanUpNonServerTargetClasspath(moduleProject);
        ServerTargetHelper.setServerTarget(moduleProject, newServerTarget, null);
    }

    public static List getWebProjectsInEAR(IProject earProject) {
        List moduleProjects = ServerTargetHelper.getAllEarModuleProjects(earProject);
        if (!moduleProjects.isEmpty()) {
            ArrayList<IProject> webProjects = new ArrayList<IProject>();
            int i = 0;
            while (i < moduleProjects.size()) {
                IProject project = (IProject)moduleProjects.get(i);
                WebModuleExtension webExt = EarModuleManager.getWebModuleExtension();
                if (webExt.hasRuntime(project)) {
                    webProjects.add(project);
                }
                ++i;
            }
            return webProjects;
        }
        return Collections.EMPTY_LIST;
    }

    public static void setNewServerTargetForEARUtilityJars(IRuntime newServerTarget, IProject project) {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)project);
            IVirtualReference[] utilRefs = edit.getUtilityModuleReferences();
            if (utilRefs.length > 0) {
                int i = 0;
                while (i < utilRefs.length) {
                    IVirtualReference moduleRef = utilRefs[i];
                    IProject moduleProject = moduleRef.getReferencedComponent().getProject();
                    IRuntime existingTargetType = ServerCore.getProjectProperties((IProject)moduleProject).getRuntimeTarget();
                    if (existingTargetType != null) {
                        if (!existingTargetType.getId().equals(newServerTarget.getId())) {
                            ServerTargetHelper.setServerTargetForUtilProject(newServerTarget, moduleProject);
                        }
                    } else {
                        ServerTargetHelper.setServerTargetForUtilProject(newServerTarget, moduleProject);
                    }
                    ++i;
                }
            }
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public static void setServerTargetForUtilProject(IRuntime newServerTarget, IProject moduleProject) {
        ServerTargetHelper.cleanUpNonServerTargetClasspath(moduleProject);
        ServerTargetHelper.setServerTarget(moduleProject, newServerTarget, null);
    }

    public static void setServerTarget(IProject project, IRuntime runtime, IProgressMonitor monitor) {
        ServerTargetHelper.setFacetRuntime(project, monitor);
    }

    public static void setFacetRuntime(IProject project, IProgressMonitor monitor) {
        block7: {
            IRuntime runtime = ServerCore.getProjectProperties((IProject)project).getRuntimeTarget();
            try {
                if (runtime == null) break block7;
                IRuntime run = ServerTargetHelper.getRuntimeByID(runtime.getId());
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = null;
                IFacetedProject facetProject = ProjectFacetsManager.create((IProject)project);
                try {
                    if (run != null) {
                        facetRuntime = FacetUtil.getRuntime((IRuntime)run);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (facetRuntime != null) {
                    facetProject.setRuntime(facetRuntime, null);
                }
            }
            catch (IllegalArgumentException e) {
                J2eePlugin.logError(e);
            }
            catch (CoreException ce) {
                J2eePlugin.logError(ce);
            }
        }
    }

    public static IRuntime getRuntimeByID(String id) {
        IRuntime[] targets = ServerUtil.getRuntimes((String)"", (String)"");
        int i = 0;
        while (i < targets.length) {
            IRuntime target = targets[i];
            if (id.equals(target.getId())) {
                return target;
            }
            ++i;
        }
        return null;
    }

    public static List getAllEarModuleProjects(IProject earProject) {
        ArrayList<IProject> moduleProjects = new ArrayList<IProject>();
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForRead((IProject)earProject);
            IVirtualReference[] moduleRefs = edit.getJ2EEModuleReferences();
            int i = 0;
            while (i < moduleRefs.length) {
                moduleProjects.add(moduleRefs[i].getReferencedComponent().getProject());
                ++i;
            }
            ArrayList<IProject> arrayList = moduleProjects;
            return arrayList;
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public static String[] getProjectTypeAndJ2EELevel(IProject project) {
        String[] projectAttr = new String[2];
        boolean isJ2EE13 = true;
        if (EARNatureRuntime.hasRuntime(project)) {
            projectAttr[0] = "j2ee.ear";
            isJ2EE13 = EARNatureRuntime.getRuntime(project).isJ2EE1_3();
        } else if (J2EENature.hasRuntime((IProject)project, (String[])IEJBNatureConstants.EJB_NATURE_IDS)) {
            projectAttr[0] = "j2ee.ejb";
            isJ2EE13 = J2EENature.getRuntime(project, IEJBNatureConstants.EJB_NATURE_IDS).isJ2EE1_3();
        } else if (J2EENature.hasRuntime((IProject)project, (String)"org.eclipse.jst.j2ee.web.WebNature")) {
            projectAttr[0] = "j2ee.web";
            isJ2EE13 = J2EENature.getRuntime(project, "org.eclipse.jst.j2ee.web.WebNature").isJ2EE1_3();
        } else if (J2EENature.hasRuntime((IProject)project, (String)"org.eclipse.jst.j2ee.ApplicationClientNature")) {
            projectAttr[0] = "j2ee.appclient";
            isJ2EE13 = J2EENature.getRuntime(project, "org.eclipse.jst.j2ee.ApplicationClientNature").isJ2EE1_3();
        } else if (J2EENature.hasRuntime((IProject)project, (String)"org.eclipse.jst.j2ee.jca.ConnectorNature")) {
            projectAttr[0] = "j2ee.connector";
            isJ2EE13 = J2EENature.getRuntime(project, "org.eclipse.jst.j2ee.jca.ConnectorNature").isJ2EE1_3();
        } else if (ServerTargetHelper.hasJavaNature(project)) {
            projectAttr[0] = null;
        }
        if (projectAttr[0] != null && projectAttr[0].length() > 0) {
            projectAttr[1] = isJ2EE13 ? "1.3" : "1.2";
        }
        return projectAttr;
    }

    public static boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature(JAVA_NATURE_ID);
        }
        catch (CoreException ce) {
            J2eePlugin.logError(ce);
            return false;
        }
    }

    public static List getAllEarUtilityProjects(EAREditModel earEditModel, IProject earProject) {
        ArrayList utilityProjects = new ArrayList();
        Set utilProjects = earEditModel.getModuleMappedUtilityJarProjects();
        if (!utilProjects.isEmpty()) {
            utilityProjects.addAll(utilProjects);
        }
        return utilityProjects;
    }

    public static int getExistingServerTargetIndex(List validServerTargets, IProject project) {
        IRuntime st;
        if (validServerTargets != null && (st = ServerCore.getProjectProperties((IProject)project).getRuntimeTarget()) != null) {
            int i = 0;
            while (i < validServerTargets.size()) {
                if (((IRuntime)validServerTargets.get(i)).getId() == st.getId()) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static List getExistingNonServerTargetClasspath(IProject project) {
        IJavaProject javaProject = null;
        ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
        try {
            javaProject = (IJavaProject)project.getNature(JAVA_NATURE_ID);
        }
        catch (Exception exception) {}
        if (javaProject != null) {
            try {
                IClasspathEntry[] cp = javaProject.getRawClasspath();
                int size = cp.length;
                int i = 0;
                while (i < size) {
                    int entryKind = cp[i].getEntryKind();
                    if (entryKind != 3 && entryKind != 1 && entryKind != 2 && entryKind == 4 && ServerTargetHelper.isWASVariable(cp[i]) && (entryKind != 5 || !cp[i].getPath().segment(0).equals(SERVER_CONTAINER))) {
                        list.add(cp[i]);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
            return list;
        }
        return list;
    }

    private static boolean isWASVariable(IClasspathEntry entry) {
        return false;
    }

    public static boolean serverTargetValidForEAR(IProject earProject, IRuntime st) {
        return !J2EENature.hasRuntime((IProject)earProject, (String)"org.eclipse.jst.j2ee.EARNature") || !st.getId().equals("com.ibm.etools.websphere.aes.v4");
    }

    public static List getServerTargets(String type, String version) {
        List<IRuntime> targets = Arrays.asList(ServerUtil.getRuntimes((String)type, (String)version));
        return targets;
    }
}

