/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.AddArchiveProjectToEAROperation;
import com.ibm.etools.j2ee.common.operations.AddArchiveToEARDataModel;
import com.ibm.etools.j2ee.common.operations.ServerTargetDataModel;
import com.ibm.etools.j2ee.internal.project.EARNatureRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.j2ee.application.internal.operations.UpdateManifestDataModelProvider;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class AddUtilityProjectToEARDataModel
extends AddArchiveToEARDataModel {
    private static final String NESTED_MODEL_SERVER_TARGET = "AddUtilityProjectToEARDataModel.NESTED_MODEL_SERVER_TARGET";
    private IDataModel manifestModel;
    private ServerTargetDataModel serverTargetModel;

    public static AddUtilityProjectToEARDataModel createAddToEARDataModel(String earProjectName, IProject moduleProject) {
        AddUtilityProjectToEARDataModel model = new AddUtilityProjectToEARDataModel();
        model.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", earProjectName);
        return model;
    }

    public static AddUtilityProjectToEARDataModel createAddToEARDataModel(String earProjectName, WorkbenchComponent module) {
        AddUtilityProjectToEARDataModel model = new AddUtilityProjectToEARDataModel();
        model.setProperty("ArtifactEditOperationDataModel.PROJECT_NAME", earProjectName);
        model.setProperty("AddModuleToEARDataModel.ARCHIVE_PROJECT", module);
        return model;
    }

    @Override
    public WTPOperation getDefaultOperation() {
        return new AddArchiveProjectToEAROperation(this);
    }

    protected void initNestedModels() {
        super.initNestedModels();
        this.manifestModel = DataModelFactory.createDataModel(UpdateManifestDataModelProvider.class);
        this.serverTargetModel = new ServerTargetDataModel();
        this.addNestedModel(NESTED_MODEL_SERVER_TARGET, this.serverTargetModel);
    }

    private void updateServerTargetIDs() {
        EARNatureRuntime nature = EARNatureRuntime.getRuntime(this.getTargetProject());
        if (nature != null) {
            this.serverTargetModel.setIntProperty("ServerTargetDataModel.J2EE_VERSION_ID", nature.getJ2EEVersion());
            IRuntime targetType = ServerCore.getProjectProperties((IProject)this.getTargetProject()).getRuntimeTarget();
            if (targetType != null) {
                this.serverTargetModel.setProperty("ServerTargetDataModel.RUNTIME_TARGET_ID", targetType.getId());
            }
            this.serverTargetModel.setIntProperty("ServerTargetDataModel.DD_TYPE_ID", 2);
        }
    }

    public String getUtilityJARUriInFirstEAR(IProject utilProject) {
        return null;
    }

    @Override
    protected boolean doSetProperty(String propertyName, Object propertyValue) {
        boolean result = super.doSetProperty(propertyName, propertyValue);
        if (propertyName.equals("AddModuleToEARDataModel.ARCHIVE_PROJECT")) {
            WorkbenchComponent wbComp = (WorkbenchComponent)propertyValue;
            IProject proj = this.getProjectForGivenComponent(wbComp);
            this.updateManifestModel(proj);
            this.updateServerTargetModel(proj);
        } else if (propertyName.equals("ArtifactEditOperationDataModel.PROJECT_NAME")) {
            this.updateServerTargetIDs();
        }
        return result;
    }

    private void updateServerTargetModel(IProject proj) {
        if (proj != null) {
            this.serverTargetModel.setProperty("ServerTargetDataModel.PROJECT_NAME", proj.getName());
        }
    }

    private void updateManifestModel(IProject proj) {
        if (proj != null) {
            this.manifestModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)proj.getName());
        } else {
            this.manifestModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", null);
        }
    }

    @Override
    protected String getDefaultArchiveURI() {
        WorkbenchComponent wbComp = (WorkbenchComponent)this.getProperty("AddModuleToEARDataModel.ARCHIVE_PROJECT");
        return wbComp.getHandle().toString();
    }

    @Override
    protected IStatus doValidateProperty(String propertyName) {
        if ("AddModuleToEARDataModel.ARCHIVE_PROJECT".equals(propertyName)) {
            IStatus status = super.doValidateProperty(propertyName);
            if (!status.isOK()) {
                return status;
            }
            WorkbenchComponent wbComp = (WorkbenchComponent)this.getProperty("AddModuleToEARDataModel.ARCHIVE_PROJECT");
            if (this.isWebOrClientModule(wbComp) || !this.isJavaModule(wbComp)) {
                return WTPCommonPlugin.createErrorStatus((String)EARCreationResourceHandler.ADD_PROJECT_NOT_JAVA);
            }
        } else if ("AddModuleToEARDataModel.URI".equals(propertyName)) {
            IStatus status = super.doValidateProperty(propertyName);
            if (!status.isOK()) {
                return status;
            }
            if (!this.getStringProperty("AddModuleToEARDataModel.URI").endsWith(".jar")) {
                return WTPCommonPlugin.createErrorStatus((String)EARCreationResourceHandler.ADD_PROJECT_UTIL_URI);
            }
        }
        return super.doValidateProperty(propertyName);
    }

    private boolean isJavaModule(WorkbenchComponent wbComp) {
        return wbComp.getComponentType().getComponentTypeId().equals("jst.utility");
    }

    private boolean isWebOrClientModule(WorkbenchComponent wbComp) {
        String typeID = wbComp.getComponentType().getComponentTypeId();
        return typeID.equals("jst.web") || typeID.equals("jst.appclient");
    }

    public IDataModel getManifestModel() {
        return this.manifestModel;
    }

    public ServerTargetDataModel getServerTargetModel() {
        return this.serverTargetModel;
    }
}

