/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.common.operations;

import com.ibm.etools.j2ee.J2eePlugin;
import com.ibm.etools.j2ee.common.operations.AddArchiveToEARDataModel;
import com.ibm.etools.j2ee.common.operations.AddModuleToEARProjectCommand;
import com.ibm.etools.j2ee.common.operations.AddUtilityJARMapCommand;
import com.ibm.etools.j2ee.common.operations.AddUtilityProjectToEARDataModel;
import com.ibm.etools.j2ee.common.operations.EARArtifactEditOperation;
import com.ibm.etools.j2ee.common.operations.JARDependencyTraverser;
import com.ibm.etools.j2ee.common.operations.RemoveModuleFromEARProjectCommand;
import com.ibm.etools.j2ee.common.operations.ServerTargetDataModel;
import com.ibm.etools.j2ee.common.operations.ServerTargetOperation;
import com.ibm.etools.j2ee.internal.project.EARNatureRuntime;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationResource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.internal.impl.ApplicationResourceImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.EJBArchiveOpsResourceHandler;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;

public class AddArchiveProjectToEAROperation
extends EARArtifactEditOperation {
    private IProgressMonitor monitor;

    public AddArchiveProjectToEAROperation(AddArchiveToEARDataModel dataModel) {
        super(dataModel);
    }

    @Override
    protected void execute(IProgressMonitor aMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        Command command;
        this.monitor = aMonitor;
        AddArchiveToEARDataModel dataModel = (AddArchiveToEARDataModel)this.operationDataModel;
        String originalID = null;
        ApplicationResource resource = null;
        String uri = dataModel.getStringProperty("AddModuleToEARDataModel.URI");
        EARNatureRuntime nature = EARNatureRuntime.getRuntime(dataModel.getTargetProject());
        Application app = nature.getApplication();
        Module module = app.getFirstModule(uri);
        if (module != null) {
            resource = (ApplicationResource)module.eResource();
            originalID = resource.getID((EObject)module);
        }
        if ((command = this.createCommand(dataModel)) != null) {
            this.getCommandStack().execute(command);
        }
        if (originalID != null) {
            module = app.getFirstModule(uri);
            resource = (ApplicationResourceImpl)module.eResource();
            resource.setID((EObject)module, originalID);
        }
        this.addServerTarget(aMonitor);
        if (!dataModel.isModuleArchive()) {
            this.updateUtilProject((AddUtilityProjectToEARDataModel)dataModel, aMonitor);
        }
        this.addAllDependentJARs();
    }

    private void addAllDependentJARs() throws CoreException {
        Map dependents = this.computeAllDependents();
        if (dependents.isEmpty()) {
            return;
        }
        Iterator iter = dependents.entrySet().iterator();
        Map.Entry entry = null;
        IResource resource = null;
        String uri = null;
        CompoundCommand compoundCommand = new CompoundCommand();
        compoundCommand.setLabel(EJBArchiveOpsResourceHandler.Copy_Dep_JARS_UI);
        while (iter.hasNext()) {
            entry = iter.next();
            resource = (IResource)entry.getKey();
            uri = (String)entry.getValue();
            switch (resource.getType()) {
                case 1: {
                    this.addDependentJARFile((IFile)resource, uri, compoundCommand);
                    break;
                }
                case 4: {
                    this.addDependentJARProject((IProject)resource, uri, compoundCommand);
                }
            }
        }
        this.getCommandStack().execute((Command)compoundCommand);
    }

    private void addDependentJARProject(IProject project, String uri, CompoundCommand compoundCommand) {
        AddUtilityJARMapCommand cmd = new AddUtilityJARMapCommand(this.getEARProject(), uri, project);
        compoundCommand.append((Command)cmd);
    }

    private void addDependentJARFile(IFile file, String uri, CompoundCommand compoundCommand) throws CoreException {
        CopyJARFileCommand cmd = new CopyJARFileCommand(this.getEARProject(), this.monitor, file, uri);
        compoundCommand.append((Command)cmd);
    }

    protected void addServerTarget(IProgressMonitor aMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        if (this.operationDataModel.getBooleanProperty("AddModuleToEARDataModel.SYNC_TARGET_RUNTIME")) {
            ServerTargetDataModel model = ((AddArchiveToEARDataModel)this.operationDataModel).getServerTargetDataModel();
            ServerTargetOperation serverTargetOperation = new ServerTargetOperation(model);
            serverTargetOperation.doRun(aMonitor);
        }
    }

    private void updateUtilProject(AddUtilityProjectToEARDataModel model, IProgressMonitor aMonitor) {
    }

    private Command createCommand(AddArchiveToEARDataModel dataModel) {
        IProject project = this.getArchiveProject();
        String uri = dataModel.getStringProperty("AddModuleToEARDataModel.URI");
        EARNatureRuntime nature = EARNatureRuntime.getRuntime(dataModel.getTargetProject());
        if (project == nature.getMappedProject(uri)) {
            return null;
        }
        Module m = null;
        RemoveModuleFromEARProjectCommand removeCommand = null;
        if (m != null) {
            removeCommand = new RemoveModuleFromEARProjectCommand(m, dataModel.getTargetProject());
        }
        AbstractCommand addCommand = null;
        if (dataModel.isModuleArchive()) {
            String contextRoot = null;
            addCommand = new AddModuleToEARProjectCommand(project, dataModel.getTargetProject(), uri, contextRoot, null);
        } else {
            addCommand = new AddUtilityJARMapCommand(dataModel.getTargetProject(), uri, project);
        }
        if (removeCommand != null) {
            return removeCommand.chain((Command)addCommand);
        }
        return addCommand;
    }

    private IProject getArchiveProject() {
        WorkbenchComponent wbComp = (WorkbenchComponent)this.operationDataModel.getProperty("AddModuleToEARDataModel.ARCHIVE_PROJECT");
        return ((AddArchiveToEARDataModel)this.operationDataModel).getProjectForGivenComponent(wbComp);
    }

    private IProject getEARProject() {
        return ((AddArchiveToEARDataModel)this.operationDataModel).getTargetProject();
    }

    private Map computeAllDependents() {
        IProject archiveProject = this.getArchiveProject();
        IProject earProject = this.getEARProject();
        if (archiveProject == null || earProject == null) {
            return Collections.EMPTY_MAP;
        }
        return new JARDependencyTraverser(archiveProject, earProject).run();
    }

    private static class CopyJARFileCommand
    extends AbstractCommand
    implements Command {
        IProject earProject = null;
        IProgressMonitor monitor = null;
        IFile file = null;
        String uri = null;
        IFile target = null;

        public CopyJARFileCommand(IProject earProject, IProgressMonitor monitor, IFile file, String uri) {
            this.earProject = earProject;
            this.monitor = monitor;
            this.file = file;
            this.uri = uri;
        }

        public void execute() {
            Path path = null;
            try {
                path = new Path(this.uri);
                this.target = this.earProject.getFile((IPath)path);
                this.mkdirs((IPath)path);
                this.file.copy(this.target.getFullPath(), true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)new NullProgressMonitor(), 1));
            }
            catch (Exception ex) {
                J2eePlugin.logError(ex);
            }
        }

        public void undo() {
            try {
                if (this.target != null) {
                    this.target.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                J2eePlugin.logError(e);
            }
        }

        public void redo() {
            this.execute();
        }

        protected boolean prepare() {
            return true;
        }

        private void mkdirs(IPath path) throws CoreException {
            int segments = path.segmentCount();
            int i = segments - 1;
            while (i > 0) {
                IFolder folder = this.earProject.getFolder(path.removeLastSegments(i));
                if (!folder.exists()) {
                    folder.create(true, true, null);
                }
                --i;
            }
        }
    }
}

