/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.j2ee.common.operations.ModelModifierOperation;
import com.ibm.etools.j2ee.common.operations.ModelModifierOperationDataModel;
import com.ibm.etools.j2ee.web.internal.operations.RemoveServletDataModel;
import com.ibm.etools.j2ee.web.internal.plugin.WebPlugin;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.webapplication.FilterMapping;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;
import org.eclipse.jst.j2ee.webapplication.internal.impl.WebapplicationFactoryImpl;
import org.eclipse.wst.common.internal.emfworkbench.integration.ModifierHelper;

public class RemoveServletOperation
extends ModelModifierOperation {
    public RemoveServletOperation(RemoveServletDataModel model) {
        super((ModelModifierOperationDataModel)model);
    }

    protected void addHelpers() {
        RemoveServletDataModel model = (RemoveServletDataModel)this.operationDataModel;
        boolean removeClass = model.getBooleanProperty("RemoveServletDataModel.REMOVE_JAVA_CLASS");
        IProject project = model.getTargetProject();
        WebApp webApp = (WebApp)this.getArtifactEdit().getContentModelRoot();
        boolean isServlet2_3OrGreater = webApp.getJ2EEVersionID() >= 13;
        List servletList = (List)model.getProperty("RemoveServletDataModel.SERVLET_LIST");
        int count = servletList.size();
        int i = 0;
        while (i < count) {
            Servlet servlet = (Servlet)servletList.get(i);
            ModifierHelper helper = this.createRemoveServletHelper(webApp, servlet);
            this.modifier.addHelper(helper);
            EList servletMappings = webApp.getServletMappings();
            int j = 0;
            while (j < servletMappings.size()) {
                ServletMapping sm = (ServletMapping)servletMappings.get(j);
                if (sm.eIsSet((EStructuralFeature)WebapplicationPackage.eINSTANCE.getServletMapping_Servlet()) && servlet.equals(sm.getServlet())) {
                    ModifierHelper helper1 = this.createRemoveServletMappingHelper(webApp, sm);
                    this.modifier.addHelper(helper1);
                }
                ++j;
            }
            if (isServlet2_3OrGreater) {
                EList filterMappings = webApp.getFilterMappings();
                int j2 = 0;
                while (j2 < filterMappings.size()) {
                    FilterMapping fm = (FilterMapping)filterMappings.get(j2);
                    if (fm.eIsSet((EStructuralFeature)WebapplicationPackage.eINSTANCE.getFilterMapping_Servlet()) && servlet.equals(fm.getServlet())) {
                        ModifierHelper helper1 = this.createRemoveFilterMappingHelper(webApp, fm);
                        this.modifier.addHelper(helper1);
                    }
                    ++j2;
                }
            }
            if (removeClass) {
                try {
                    JavaClass javaClass = servlet.getServletClass();
                    String qualifiedName = javaClass.getQualifiedName();
                    qualifiedName = String.valueOf(qualifiedName.replace('.', '/')) + ".java";
                    List sourceFolders = JemProjectUtilities.getSourceContainers((IProject)project);
                    int j3 = 0;
                    while (j3 < sourceFolders.size()) {
                        IFolder sourceFolder = (IFolder)sourceFolders.get(j3);
                        IFile file = sourceFolder.getFile(qualifiedName);
                        if (file.exists()) {
                            file.delete(true, null);
                            break;
                        }
                        ++j3;
                    }
                }
                catch (CoreException ex) {
                    WebPlugin.logError(ex);
                }
            }
            ++i;
        }
    }

    private ModifierHelper createRemoveServletHelper(WebApp webApp, Servlet servlet) {
        ModifierHelper helper = new ModifierHelper();
        helper.setOwner((EObject)webApp);
        helper.setFeature((EStructuralFeature)WebapplicationPackage.eINSTANCE.getWebApp_Servlets());
        helper.setValue((Object)servlet);
        helper.doUnsetValue();
        return helper;
    }

    private ModifierHelper createRemoveServletMappingHelper(WebApp webApp, ServletMapping servletMapping) {
        ModifierHelper helper = new ModifierHelper();
        helper.setOwner((EObject)webApp);
        helper.setFeature((EStructuralFeature)WebapplicationFactoryImpl.getPackage().getWebApp_ServletMappings());
        helper.setValue((Object)servletMapping);
        helper.doUnsetValue();
        this.modifier.addHelper(helper);
        return helper;
    }

    private ModifierHelper createRemoveFilterMappingHelper(WebApp webApp, FilterMapping filterMapping) {
        ModifierHelper helper = new ModifierHelper();
        helper.setOwner((EObject)webApp);
        helper.setFeature((EStructuralFeature)WebapplicationFactoryImpl.getPackage().getWebApp_FilterMappings());
        helper.setValue((Object)filterMapping);
        helper.doUnsetValue();
        this.modifier.addHelper(helper);
        return helper;
    }
}

