/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.web.internal.operations.AddServletInitParamOperation;
import com.ibm.etools.j2ee.web.internal.operations.WebMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.webapplication.InitParam;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddServletInitParamDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String SERVLET = "AddServletInitParamOperationDataModel.SERVLET";
    public static final String PARAMETER_NAME = "AddServletInitParamOperationDataModel.PARAMETER_NAME";
    public static final String PARAMETER_VALUE = "AddServletInitParamOperationDataModel.PARAMETER_VALUE";
    public static final String DESCRIPTION = "AddServletInitParamOperationDataModel.DESCRIPTION";

    public WTPOperation getDefaultOperation() {
        return new AddServletInitParamOperation(this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(SERVLET);
        this.addValidBaseProperty(PARAMETER_NAME);
        this.addValidBaseProperty(PARAMETER_VALUE);
        this.addValidBaseProperty(DESCRIPTION);
    }

    protected IStatus doValidateProperty(String propertyName) {
        if (propertyName.equals(PARAMETER_NAME)) {
            return this.validateParameterName(this.getStringProperty(propertyName));
        }
        if (propertyName.equals(PARAMETER_VALUE)) {
            return this.validateParameterValue(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    private IStatus validateParameterName(String name) {
        EList list14;
        if (name == null || name.trim().length() == 0) {
            String msg = WebMessages.getResourceString(WebMessages.ERR_SERVLET_PARAMETER_NAME_EMPTY, new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        boolean exists = false;
        Servlet servlet = (Servlet)this.getProperty(SERVLET);
        EList list13 = servlet.getParams();
        if (list13 != null) {
            int size = list13.size();
            int i = 0;
            while (i < size) {
                String parName;
                InitParam p = (InitParam)list13.get(i);
                if (p != null && name.equals(parName = p.getParamName())) {
                    exists = true;
                    break;
                }
                ++i;
            }
        }
        if ((list14 = servlet.getInitParams()) != null) {
            int size = list14.size();
            int i = 0;
            while (i < size) {
                String parName;
                ParamValue p = (ParamValue)list14.get(i);
                if (p != null && name.equals(parName = p.getName())) {
                    exists = true;
                    break;
                }
                ++i;
            }
        }
        if (exists) {
            String msg = WebMessages.getResourceString(WebMessages.ERR_SERVLET_PARAMETER_NAME_EXIST, new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateParameterValue(String value) {
        if (value == null || value.trim().length() == 0) {
            String msg = WebMessages.getResourceString(WebMessages.ERR_SERVLET_PARAMETER_VALUE_EMPTY, new String[]{value});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

