/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.j2ee.web.internal.operations;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperation;
import com.ibm.etools.j2ee.common.operations.J2EEModelModifierOperationDataModel;
import com.ibm.etools.j2ee.internal.java.codegen.JavaCodeGenResourceHandler;
import com.ibm.etools.j2ee.web.internal.operations.AddSecurityConstraintOperation;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.common.DisplayName;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;

public class AddSecurityConstraintDataModel
extends J2EEModelModifierOperationDataModel {
    public static final String CONSTRAINT_NAME = "AddSecurityConstraintOperationDataModel.CONSTRAINT_NAME";

    public WTPOperation getDefaultOperation() {
        return new AddSecurityConstraintOperation(this);
    }

    protected void initValidBaseProperties() {
        super.initValidBaseProperties();
        this.addValidBaseProperty(CONSTRAINT_NAME);
    }

    protected IStatus doValidateProperty(String propertyName) {
        IStatus status = this.validateEE5Project();
        if (!status.isOK()) {
            return status;
        }
        if (propertyName.equals(CONSTRAINT_NAME)) {
            return this.validateConstraintName(this.getStringProperty(propertyName));
        }
        return super.doValidateProperty(propertyName);
    }

    protected IStatus validateEE5Project() {
        EObject app = this.getDeploymentDescriptorRoot();
        if (app == null) {
            String msg = MessageFormat.format(JavaCodeGenResourceHandler.AddSecurityRoleOperationDataModel_This_wizard_is_not_applicable_on_pr_, new Object[1]);
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }

    private IStatus validateConstraintName(String name) {
        if (name == null || name.trim().length() == 0) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_SECURITY_CONSTRAINT_NAME_EMPTY, (Object[])new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        WebApp webApp = (WebApp)this.getDeploymentDescriptorRoot();
        EList scList = webApp.getConstraints();
        boolean exists = false;
        if (scList != null) {
            int size = scList.size();
            if (webApp.getJ2EEVersionID() >= 14) {
                int i = 0;
                while (i < size) {
                    DisplayName displayName;
                    String scName;
                    EList displayNameList = ((SecurityConstraint)scList.get(i)).getDisplayNames();
                    if (displayNameList != null && !displayNameList.isEmpty() && name.equals(scName = (displayName = (DisplayName)displayNameList.get(0)).getValue())) {
                        exists = true;
                        break;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < size) {
                    String scName = ((SecurityConstraint)scList.get(i)).getDisplayName();
                    if (name.equals(scName)) {
                        exists = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (exists) {
            String msg = WebMessages.getResourceString((String)WebMessages.ERR_SECURITY_CONSTRAINT_NAME_EXIST, (Object[])new String[]{name});
            return WTPCommonPlugin.createErrorStatus((String)msg);
        }
        return WTPCommonPlugin.OK_STATUS;
    }
}

