/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.ui.editor.common;

import com.ibm.etools.webservice.atk.ui.editor.IPageContainer;
import com.ibm.etools.webservice.atk.ui.editor.common.PageItem;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class PageCollection {
    private static Hashtable configElementsTable_ = new Hashtable();
    private IConfigurationElement[] configElements_;
    private Vector pages_;

    private PageCollection(IConfigurationElement[] configElements, String pluginId, String extensionPoint) {
        this.configElements_ = configElements;
        this.pages_ = new Vector();
        this.instantiatePages();
    }

    public static PageCollection newCollection(String pluginId, String extensionPoint) {
        IConfigurationElement[] elements = PageCollection.getConfigurationElements(pluginId, extensionPoint);
        return new PageCollection(elements, pluginId, extensionPoint);
    }

    private static IConfigurationElement[] getConfigurationElements(String pluginId, String extensionPoint) {
        StringBuffer id = new StringBuffer();
        id.append(pluginId);
        id.append("#");
        id.append(extensionPoint);
        IConfigurationElement[] elements = (IConfigurationElement[])configElementsTable_.get(id.toString());
        if (elements == null) {
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            elements = reg.getConfigurationElementsFor(pluginId, extensionPoint);
            configElementsTable_.put(id.toString(), elements);
        }
        return elements;
    }

    private void instantiatePages() {
        int i = 0;
        while (i < this.configElements_.length) {
            try {
                Object pageContainer = this.configElements_[i].createExecutableExtension("class");
                if (pageContainer instanceof IPageContainer) {
                    String id = this.configElements_[i].getAttribute("id");
                    String name = this.configElements_[i].getAttribute("name");
                    String pageIndex = this.configElements_[i].getAttribute("pageindex");
                    String modelName = this.configElements_[i].getAttribute("model");
                    this.pages_.add(new PageItem(id, name, pageIndex, modelName, (IPageContainer)pageContainer));
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
    }

    public PageItem[] getItemsSortByIndex() {
        PageItem[] items = new PageItem[this.pages_.size()];
        int itemsIndex = 0;
        int i = 0;
        while (i < this.pages_.size()) {
            PageItem item = (PageItem)this.pages_.get(i);
            int pageIndex = item.getPageIndex();
            int j = 0;
            while (j < itemsIndex) {
                if (pageIndex < 0) {
                    j = itemsIndex;
                    break;
                }
                if (pageIndex < items[j].getPageIndex()) {
                    this.shiftItems(items, j);
                    break;
                }
                ++j;
            }
            items[j] = item;
            ++itemsIndex;
            ++i;
        }
        return items;
    }

    private void shiftItems(PageItem[] items, int startIndex) {
        PageItem currItem = items[startIndex];
        int i = startIndex;
        while (i < items.length - 1) {
            PageItem nextItem = items[i + 1];
            items[i + 1] = currItem;
            currItem = nextItem;
            ++i;
        }
        items[startIndex] = null;
    }
}

