/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webservice.atk.ui.editor.common;

import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.webservice.atk.ui.editor.common.BackgroundColorSashForm;
import com.ibm.etools.webservice.atk.ui.editor.common.FormControlInitializer;
import com.ibm.etools.webservice.atk.ui.editor.common.PageCommon;
import com.ibm.etools.webservice.atk.ui.utils.AtkUtils;
import com.ibm.etools.webtools.flatui.WidgetFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.Workbench;

public abstract class FormCommon
extends Composite
implements IPropertyChangeListener {
    private Class COMPOSITE_CLASS = Composite.class;
    private Class FORM_COMMON_CLASS = FormCommon.class;
    private Class CCOMBO_CLASS = CCombo.class;
    protected Color white = this.getDisplay().getSystemColor(25);
    protected Color black = this.getDisplay().getSystemColor(24);
    protected Color skyBlue = new Color((Device)this.getDisplay(), 152, 170, 203);
    protected Color blue = new Color((Device)this.getDisplay(), 0, 0, 153);
    protected WidgetFactory wf;
    protected String title;
    public Text messageLabel;
    public String formTitle = "";
    protected String formInformation = "";
    protected FormControlInitializer controlInitializer;
    protected Text headerLabel;
    protected final int SASH_WIDTH = 10;
    protected Composite messageComposite;
    protected Composite topControlComposite;
    protected boolean inStackComposite = false;

    public FormCommon(Composite parent, int style, String aTitle, String formInfo, FormControlInitializer initializer) {
        super(parent, style);
        this.title = aTitle;
        this.formInformation = formInfo;
        this.setWf(AtkUtils.getWidgetFactory());
        this.controlInitializer = initializer;
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.createPartControl(this);
    }

    public void moveScrollBar(Composite parent, ScrolledComposite scroll) {
        Point x = parent.getLocation();
        scroll.setOrigin(x);
    }

    protected void reInitializeScrolledComposite(ScrolledComposite scrolledComposite) {
        Point minSize = scrolledComposite.getChildren()[0].computeSize(-1, -1);
        scrolledComposite.setMinHeight(minSize.y);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
    }

    protected void reInitializeScrolledCompositeWithTopControl(ScrolledComposite scrolledComposite, Composite topControl) {
        Point minSize = topControl.computeSize(-1, -1);
        scrolledComposite.setMinHeight(minSize.y);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
    }

    public Composite findScrollComposite(Composite comp) {
        if (comp instanceof ScrolledComposite) {
            return comp;
        }
        if (comp != null) {
            comp = comp.getParent();
            return this.findScrollComposite(comp);
        }
        return null;
    }

    public void createSectionHeader(Composite parent, String aTitle, String aFormInfo) {
        this.title = aTitle;
        this.formInformation = aFormInfo;
        this.createHeaderComposite(parent);
        this.createSeperatorComposite(parent);
        this.getWf().paintBordersFor((Composite)this);
    }

    public Composite createMessageArea(Composite parent) {
        Composite messageArea = this.getWf().createComposite(parent);
        GridData data = new GridData(770);
        messageArea.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 4;
        gl.marginHeight = 0;
        messageArea.setLayout((Layout)gl);
        messageArea.setBackground(this.white);
        this.messageLabel = this.getWf().createText(messageArea, this.formInformation, 66);
        this.messageLabel.setEditable(false);
        GridData gd = new GridData(770);
        gd.widthHint = this.controlInitializer.getMessageAreaWidth();
        this.messageLabel.setLayoutData((Object)gd);
        return messageArea;
    }

    protected BackgroundColorSashForm primCreateSashForm(Composite parent) {
        BackgroundColorSashForm splitView = new BackgroundColorSashForm(parent, 256);
        GridLayout gl = this.commonGridLayout();
        gl.numColumns = 2;
        gl.makeColumnsEqualWidth = true;
        splitView.setLayout((Layout)gl);
        splitView.setLayoutData(new GridData(1808));
        splitView.setForeground(this.white);
        splitView.setBackground(this.white);
        return splitView;
    }

    public Composite createHeaderComposite(Composite parent) {
        Composite headerComposite = this.getWf().createComposite(parent);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 4;
        gl.marginHeight = 0;
        headerComposite.setLayout((Layout)gl);
        headerComposite.setLayoutData((Object)new GridData(768));
        this.headerLabel = this.getWf().createText(headerComposite, this.title, 0);
        this.headerLabel.setBackground(this.white);
        this.headerLabel.setForeground(this.black);
        this.headerLabel.setFont(JFaceResources.getHeaderFont());
        return headerComposite;
    }

    public Composite createSeperatorComposite(Composite parent) {
        Composite separatorComposite = this.getWf().createCompositeSeparator(parent);
        GridData seperatorGridData = new GridData(768);
        seperatorGridData.heightHint = 2;
        separatorComposite.setLayoutData((Object)seperatorGridData);
        return separatorComposite;
    }

    protected GridData commonGridData() {
        GridData gd = new GridData(768);
        return gd;
    }

    protected GridLayout commonTwoColumnGridLayout() {
        GridLayout gl = this.commonGridLayout();
        gl.marginHeight = 2;
        gl.marginWidth = 2;
        gl.numColumns = 2;
        return gl;
    }

    protected GridLayout commonThreeColumnGridLayout() {
        GridLayout gl = this.commonGridLayout();
        gl.marginHeight = 2;
        gl.marginWidth = 2;
        gl.numColumns = 3;
        return gl;
    }

    protected GridLayout commonGridLayout() {
        GridLayout gl = new GridLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        return gl;
    }

    protected GridLayout commonSectionGridLayout() {
        GridLayout gl = new GridLayout();
        gl.marginWidth = 5;
        gl.marginHeight = 2;
        gl.verticalSpacing = 5;
        return gl;
    }

    public WidgetFactory getWf() {
        return this.wf;
    }

    public void setWf(WidgetFactory wf) {
        this.wf = wf;
    }

    protected IStructuredSelection getStructuredSelection(SelectionChangedEvent event) {
        ISelection sel;
        if (event != null && (sel = event.getSelection()) != null && sel instanceof IStructuredSelection) {
            return (IStructuredSelection)sel;
        }
        return null;
    }

    public void setReadOnly(boolean aBoolean) {
        this.setReadOnly(aBoolean, this);
    }

    protected void setReadOnly(boolean aBoolean, Composite composite) {
        Control[] children = composite.getChildren();
        int size = children.length;
        Control control = null;
        int i = 0;
        while (i < size) {
            control = children[i];
            if (this.FORM_COMMON_CLASS.isInstance(control)) {
                ((FormCommon)control).setReadOnly(aBoolean);
            } else if (this.CCOMBO_CLASS.isInstance(control)) {
                this.setReadOnly(aBoolean, control);
            } else if (this.COMPOSITE_CLASS.isInstance(control)) {
                this.setReadOnly(aBoolean, (Composite)control);
            } else {
                this.setReadOnly(aBoolean, control);
            }
            ++i;
        }
    }

    protected void setReadOnly(boolean aBoolean, Control control) {
        control.setEnabled(!aBoolean);
    }

    protected void addFormInfoIfNecessary(Composite parent) {
        if (this.formInformation != null && this.formInformation.trim().length() > 0) {
            this.messageComposite = this.createMessageArea(parent);
        }
    }

    protected void setupInfopop() {
        if (this.controlInitializer != null && this.controlInitializer.getInfopopID() != null) {
            Workbench.getInstance().getHelpSystem().setHelp((Control)this, this.controlInitializer.getInfopopID());
        }
    }

    public void enableChildren(Control[] controls, boolean enable) {
        if (controls == null || controls.length == 0) {
            return;
        }
        int i = 0;
        while (i < controls.length) {
            controls[i].setEnabled(enable);
            if (controls[i] instanceof Composite) {
                this.enableChildren(((Composite)controls[i]).getChildren(), enable);
            }
            ++i;
        }
    }

    public void dispose() {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        this.skyBlue.dispose();
        this.blue.dispose();
        super.dispose();
    }

    protected void layoutParents(Control control) {
        Composite parent = control.getParent();
        while (parent != null) {
            parent.layout();
            if (parent instanceof ScrolledComposite) {
                this.reInitializeScrolledComposite((ScrolledComposite)parent);
            } else if (parent instanceof PageCommon) break;
            parent = parent.getParent();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    protected String getMessage(String msgId) {
        return J2EEUIPlugin.getResourceString(msgId);
    }

    protected String getMessage(String msgId, Object[] objects) {
        return J2EEUIPlugin.getResourceString(msgId, objects);
    }

    protected abstract void createPartControl(Composite var1);
}

