/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.web.ui.wizards;

import com.ibm.etools.common.frameworks.internal.datamodel.WTPOperationDataModel;
import com.ibm.etools.emf.workbench.ui.wizard.datamodel.WTPWizardPage;
import com.ibm.etools.j2ee.ui.plugin.J2EEUIPlugin;
import com.ibm.etools.j2ee.web.internal.operations.AddAuthConstraintDataModel;
import com.ibm.etools.web.ui.nls.WebUIResourceHandler;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.webapplication.AuthConstraint;
import org.eclipse.jst.j2ee.webapplication.SecurityConstraint;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class AddAuthConstraintWizardPage
extends WTPWizardPage {
    private CheckboxTableViewer viewer;
    private Text descText;

    public AddAuthConstraintWizardPage(AddAuthConstraintDataModel model, String pageName) {
        super((WTPOperationDataModel)model, pageName);
        this.setDescription(WebUIResourceHandler.AUTH_CONSTRAINT_WIZARD_PAGE_DESC);
        this.setTitle(WebUIResourceHandler.AUTH_CONSTRAINT_WIZARD_PAGE_TITLE);
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"AddAuthConstraintOperationDataModel.AUTH_DESCRIPTION", "AddAuthConstraintOperationDataModel.AUTH_ROLES"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        WebApp webApp = (WebApp)((AddAuthConstraintDataModel)this.model).getDeploymentDescriptorRoot();
        SecurityConstraint sc = (SecurityConstraint)((AddAuthConstraintDataModel)this.model).getProperty("AddAuthConstraintOperationDataModel.SECURITY_CONSTRAINT");
        AuthConstraint ac = sc.getAuthConstraint();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 16384);
        label.setText(WebUIResourceHandler.AUTH_CONSTRAINT_DESC_LABEL);
        data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        this.descText = new Text(composite, 2052);
        data = new GridData(272);
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 100;
        this.descText.setLayoutData((Object)data);
        if (ac != null) {
            String desc = null;
            if (webApp.getJ2EEVersionID() >= 14) {
                EList list = ac.getDescriptions();
                if (list != null && list.size() > 0) {
                    desc = ((Description)list.get(0)).getValue();
                }
            } else {
                desc = ac.getDescription();
            }
            if (desc != null && desc.length() > 0) {
                this.descText.setText(desc);
                this.descText.setEnabled(false);
                ((AddAuthConstraintDataModel)this.model).setProperty("AddAuthConstraintOperationDataModel.AUTH_DESCRIPTION", (Object)desc);
            }
        }
        this.synchHelper.synchText(this.descText, "AddAuthConstraintOperationDataModel.AUTH_DESCRIPTION", null);
        Label roleLabel = new Label(composite, 16384);
        roleLabel.setText(WebUIResourceHandler.AUTH_CONSTRAINT_ROLE_NAME_COLUMN);
        data = new GridData();
        data.horizontalSpan = 2;
        roleLabel.setLayoutData((Object)data);
        this.viewer = new CheckboxTableViewer(composite, 2048);
        Table table = this.viewer.getTable();
        data = new GridData(1040);
        data.widthHint = 400;
        data.heightHint = 200;
        data.horizontalSpan = 2;
        table.setLayoutData((Object)data);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AddAuthConstraintWizardPage.this.handleCheckStateChanged(event);
            }
        });
        this.viewer.setContentProvider((IContentProvider)new RoleListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RoleListLabelProvider());
        EList allRoles = webApp.getSecurityRoles();
        if (ac != null) {
            EList existingRoles = ac.getRoles();
            ArrayList<SecurityRole> roles = new ArrayList<SecurityRole>();
            int size = allRoles.size();
            int i = 0;
            while (i < size) {
                SecurityRole role = (SecurityRole)allRoles.get(i);
                if (!existingRoles.contains(role.getRoleName())) {
                    roles.add(role);
                }
                ++i;
            }
            this.viewer.setInput(roles);
        } else {
            this.viewer.setInput((Object)allRoles);
        }
        this.descText.setFocus();
        return composite;
    }

    private void handleCheckStateChanged(CheckStateChangedEvent event) {
        ArrayList<String> result = new ArrayList<String>();
        Object[] checkedObjects = this.viewer.getCheckedElements();
        if (checkedObjects != null && checkedObjects.length > 0) {
            int i = 0;
            while (i < checkedObjects.length) {
                result.add(((SecurityRole)checkedObjects[i]).getRoleName());
                ++i;
            }
        }
        this.model.setProperty("AddAuthConstraintOperationDataModel.AUTH_ROLES", result);
    }

    class RoleListContentProvider
    implements IStructuredContentProvider {
        RoleListContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof List) {
                List list = (List)element;
                return list.toArray(new Object[list.size()]);
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isDeleted(Object element) {
            return false;
        }
    }

    class RoleListLabelProvider
    implements ILabelProvider {
        RoleListLabelProvider() {
        }

        public Image getImage(Object element) {
            return J2EEUIPlugin.getDefault().getImage("security_role");
        }

        public String getText(Object element) {
            if (element instanceof SecurityRole) {
                return ((SecurityRole)element).getRoleName();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

