/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.ui.navigator.framework;

import com.ibm.etools.ui.navigator.framework.AbstractRootObjectProvider;
import com.ibm.etools.ui.navigator.framework.ModelManager;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class RootObjectProvider
extends AbstractRootObjectProvider
implements IElementChangedListener {
    public RootObjectProvider() {
        JavaCore.addElementChangedListener((IElementChangedListener)this, (int)1);
    }

    @Override
    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource != null) {
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    boolean projectOpenStateChanged;
                    boolean bl = projectOpenStateChanged = (delta.getFlags() & 0x4000) != 0;
                    if (delta.getKind() == 2 || projectOpenStateChanged) {
                        IProject project = (IProject)resource;
                        this.dispose(project);
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public void elementChanged(ElementChangedEvent event) {
        this.processDelta(event.getDelta());
    }

    private void processDelta(IJavaElementDelta delta) {
        IJavaElement jElement = delta.getElement();
        int type = jElement.getElementType();
        if (type == 1) {
            IJavaElementDelta[] deltas = delta.getChangedChildren();
            int i = 0;
            while (i < deltas.length) {
                IJavaElementDelta javaElementDelta = deltas[i];
                this.processDelta(javaElementDelta);
                ++i;
            }
        } else if (type == 2) {
            IJavaProject jproj = (IJavaProject)jElement;
            int kind = delta.getKind();
            if (kind == 4 && this.hasLoadedModels(jproj.getProject())) {
                this.notifyListeners(jproj.getProject());
            }
        }
    }

    @Override
    public synchronized Object[] getModels(Object context) {
        try {
            ModelManager modelManager = (ModelManager)this.getModelManagerCache().get(context);
            return modelManager.getModels();
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setModelManager(ModelManager aModelManager, Object context) {
        block5: {
            try {
                ModelManager modelManager = (ModelManager)this.getModelManagerCache().get(context);
                if (modelManager != null) break block5;
                HashMap hashMap = this.getModelManagerCache();
                synchronized (hashMap) {
                    this.getModelManagerCache().put(context, aModelManager);
                }
            }
            catch (Exception exception) {}
        }
    }
}

