/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.jee.ui.navigator.internal;

import com.ibm.etools.jee.ui.navigator.internal.EMFRootObjectProvider;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jst.j2ee.navigator.internal.ClearPlaceHolderJob;
import org.eclipse.jst.j2ee.navigator.internal.LoadingDDNode;
import org.eclipse.jst.j2ee.navigator.internal.LoadingDDUIJob;
import org.eclipse.jst.j2ee.navigator.internal.NonConflictingRule;

public class LoadingDDJob
extends Job {
    private static final Class IPROJECT_CLASS = IProject.class;
    private EMFRootObjectProvider rootObjectProvider;
    private LoadingDDNode placeHolder;
    private AbstractTreeViewer viewer;
    private IAdaptable parent;

    public LoadingDDJob(AbstractTreeViewer viewer, LoadingDDNode placeHolder, IAdaptable parent, EMFRootObjectProvider rootObjectProvider) {
        super(placeHolder.getText());
        this.viewer = viewer;
        this.placeHolder = placeHolder;
        this.parent = parent;
        this.rootObjectProvider = rootObjectProvider;
        this.setSystem(true);
        this.setRule((ISchedulingRule)new NonConflictingRule());
    }

    protected IStatus run(IProgressMonitor monitor) {
        LoadingDDUIJob updateUIJob = new LoadingDDUIJob((StructuredViewer)this.viewer, this.placeHolder);
        updateUIJob.schedule();
        ArrayList<Object> children = new ArrayList<Object>();
        try {
            Object[] rootObjects;
            IProject project = (IProject)this.parent.getAdapter(IPROJECT_CLASS);
            Object[] objectArray = rootObjects = this.rootObjectProvider != null ? this.rootObjectProvider.getModels(project) : null;
            if (rootObjects != null) {
                int x = 0;
                while (x < rootObjects.length) {
                    children.add(rootObjects[x]);
                    ++x;
                }
            }
        }
        finally {
            this.placeHolder.dispose();
            new ClearPlaceHolderJob(this.viewer, this.placeHolder, (Object)this.parent, children.toArray()).schedule();
        }
        return Status.OK_STATUS;
    }
}

